#!/usr/bin/perl
use warnings;
use strict;

BEGIN { push(@INC,'lib'); }

use Test::More;

# Make sure we can include the module

use_ok('Image::BMP');

#use Image::BMP;

my @files = @ARGV ? @ARGV : <t/images/*.bmp>;

sub getImg {
	my ($f) = @_;
	my $img;
	#$f="convert $f bmp:- |" unless $f =~ /\.bmp$/;
	$img = new Image::BMP(file => $f, ignore_imagemagick_bug => 1);
	$img->debug(2);
	$img;
}

sub testImg {
	my ($f) = @_;
	my $expect = $f; $expect =~ s/(\.[^\.]{1,3})?$/.expect/;
	my $out = $f; $out =~ s/(\.[^\.]{1,3})?$/.txt/;
	unless (-f $expect) {
		print "Skipping: $f [No .expect]\n";
		return unless -f $expect;
	}
	#print "TEST: $f\n";

	my $img = getImg($f);
	$img->view_ascii($out);
	system('diff',$out,$expect);
	ok($?==0, "image check: $f");

	if ($?) {
		print "DIFFERENCE FOUND:  $out and $expect\n";
		exit -1;
	}
	unlink($out);
}

foreach my $file ( @files ) {
	testImg($file);
}


done_testing();

1;
