=begin comment

PeakForest REST API

API specification to support \"PeakForest - REST API\" operations

The version of the OpenAPI document: 2.3.4
Contact: contact@peakforest.org
Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package PeakForest::REST_Client::SpectraApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use PeakForest::REST_Client::ApiClient;

use base "Class::Data::Inheritable";

our $VERSION = '2.3.0';

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'PeakForest::REST_Client::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = PeakForest::REST_Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# generate_sub_bank
#
# Generate a spectra subbank
#
# @param string $spectra_type the mandatory spectra type (required)
# @param string $polarity the optional spectra polarity (mass spectra only) (optional)
# @param string $resolution the optional spectra resolution (mass spectra only) (optional)
# @param string $ionisation_method the optional spectra analyzer ionisation method (mass spectra only; for GCMS, only EI or CI; for LCMS, CI not possible) (optional)
# @param string $ion_analyzer_type the optional mass analyzer type (mass spectra only) (optional)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'polarity' => {
        data_type => 'string',
        description => 'the optional spectra polarity (mass spectra only)',
        required => '0',
    },
    'resolution' => {
        data_type => 'string',
        description => 'the optional spectra resolution (mass spectra only)',
        required => '0',
    },
    'ionisation_method' => {
        data_type => 'string',
        description => 'the optional spectra analyzer ionisation method (mass spectra only; for GCMS, only EI or CI; for LCMS, CI not possible)',
        required => '0',
    },
    'ion_analyzer_type' => {
        data_type => 'string',
        description => 'the optional mass analyzer type (mass spectra only)',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'generate_sub_bank' } = {
        summary => 'Generate a spectra subbank',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub generate_sub_bank {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling generate_sub_bank");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}/subbank';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/octet-stream');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'polarity'}) {
        $query_params->{'polarity'} = $self->{api_client}->to_query_value($args{'polarity'});
    }

    # query params
    if ( exists $args{'resolution'}) {
        $query_params->{'resolution'} = $self->{api_client}->to_query_value($args{'resolution'});
    }

    # query params
    if ( exists $args{'ionisation_method'}) {
        $query_params->{'ionisation_method'} = $self->{api_client}->to_query_value($args{'ionisation_method'});
    }

    # query params
    if ( exists $args{'ion_analyzer_type'}) {
        $query_params->{'ion_analyzer_type'} = $self->{api_client}->to_query_value($args{'ion_analyzer_type'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# get_spectra
#
# Get spectra from the database.
#
# @param string $spectra_type The mandatory spectra type filter. (required)
# @param ARRAY[string] $id_compounds The optional spectra compounds filter. (optional)
# @param ARRAY[string] $id_chromatographies The optional spectra chromatography filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). (optional)
# @param string $polarity The optional mass spectra polarity filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). (optional)
# @param string $resolution The optional mass spectra resolution filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). (optional)
# @param string $ionization_method The optional mass spectra ionization method filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). (optional)
# @param string $ion_analyzer_type The optional mass spectra ion analyzer type filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). For &#39;fullscan-gcms&#39;, only &#39;EI&#39; and &#39;CI&#39; are available. The &#39;CI&#39; value is only available for &#39;fullscan-gcms&#39; spectra.  (optional)
# @param string $derivation_method The optional GCMS spectra derivation method filter (only for &#39;fullscan-gcms&#39; spectra). (optional)
# @param string $derivated_type The optional GCMS spectra derivated type filter (only for &#39;fullscan-gcms&#39; spectra). (optional)
# @param double $ph The optional NMR spectra sample pH filter (only for &#39;1d-nmr&#39;, &#39;2d-nmr&#39; and &#39;jres&#39; spectra). (optional)
# @param string $acquisition The optional NMR spectra acquisition filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra). (optional)
# @param string $magnetic_field_strength The optional NMR spectra magnetic field strength filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra; in MHz). (optional)
# @param string $solvent The optional NMR spectra sample solvent filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra). (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'The mandatory spectra type filter.',
        required => '1',
    },
    'id_compounds' => {
        data_type => 'ARRAY[string]',
        description => 'The optional spectra compounds filter.',
        required => '0',
    },
    'id_chromatographies' => {
        data_type => 'ARRAY[string]',
        description => 'The optional spectra chromatography filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra).',
        required => '0',
    },
    'polarity' => {
        data_type => 'string',
        description => 'The optional mass spectra polarity filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra).',
        required => '0',
    },
    'resolution' => {
        data_type => 'string',
        description => 'The optional mass spectra resolution filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra).',
        required => '0',
    },
    'ionization_method' => {
        data_type => 'string',
        description => 'The optional mass spectra ionization method filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra).',
        required => '0',
    },
    'ion_analyzer_type' => {
        data_type => 'string',
        description => 'The optional mass spectra ion analyzer type filter (only for &#39;fullscan-gcms&#39;, &#39;fullscan-lcms&#39; and &#39;fragmentation-lcms&#39; spectra). For &#39;fullscan-gcms&#39;, only &#39;EI&#39; and &#39;CI&#39; are available. The &#39;CI&#39; value is only available for &#39;fullscan-gcms&#39; spectra. ',
        required => '0',
    },
    'derivation_method' => {
        data_type => 'string',
        description => 'The optional GCMS spectra derivation method filter (only for &#39;fullscan-gcms&#39; spectra).',
        required => '0',
    },
    'derivated_type' => {
        data_type => 'string',
        description => 'The optional GCMS spectra derivated type filter (only for &#39;fullscan-gcms&#39; spectra).',
        required => '0',
    },
    'ph' => {
        data_type => 'double',
        description => 'The optional NMR spectra sample pH filter (only for &#39;1d-nmr&#39;, &#39;2d-nmr&#39; and &#39;jres&#39; spectra).',
        required => '0',
    },
    'acquisition' => {
        data_type => 'string',
        description => 'The optional NMR spectra acquisition filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra).',
        required => '0',
    },
    'magnetic_field_strength' => {
        data_type => 'string',
        description => 'The optional NMR spectra magnetic field strength filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra; in MHz).',
        required => '0',
    },
    'solvent' => {
        data_type => 'string',
        description => 'The optional NMR spectra sample solvent filter (only for &#39;1d-nmr&#39; and &#39;2d-nmr&#39; spectra).',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_spectra' } = {
        summary => 'Get spectra from the database.',
        params => $params,
        returns => 'ARRAY[Spectrum]',
        };
}
# @return ARRAY[Spectrum]
#
sub get_spectra {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_spectra");
    }

    # parse inputs
    my $_resource_path = '/spectra/{spectraType}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'id_compounds'}) {
        $query_params->{'id_compounds'} = $self->{api_client}->to_query_value($args{'id_compounds'});
    }

    # query params
    if ( exists $args{'id_chromatographies'}) {
        $query_params->{'id_chromatographies'} = $self->{api_client}->to_query_value($args{'id_chromatographies'});
    }

    # query params
    if ( exists $args{'polarity'}) {
        $query_params->{'polarity'} = $self->{api_client}->to_query_value($args{'polarity'});
    }

    # query params
    if ( exists $args{'resolution'}) {
        $query_params->{'resolution'} = $self->{api_client}->to_query_value($args{'resolution'});
    }

    # query params
    if ( exists $args{'ionization_method'}) {
        $query_params->{'ionization_method'} = $self->{api_client}->to_query_value($args{'ionization_method'});
    }

    # query params
    if ( exists $args{'ion_analyzer_type'}) {
        $query_params->{'ion_analyzer_type'} = $self->{api_client}->to_query_value($args{'ion_analyzer_type'});
    }

    # query params
    if ( exists $args{'derivation_method'}) {
        $query_params->{'derivation_method'} = $self->{api_client}->to_query_value($args{'derivation_method'});
    }

    # query params
    if ( exists $args{'derivated_type'}) {
        $query_params->{'derivated_type'} = $self->{api_client}->to_query_value($args{'derivated_type'});
    }

    # query params
    if ( exists $args{'ph'}) {
        $query_params->{'ph'} = $self->{api_client}->to_query_value($args{'ph'});
    }

    # query params
    if ( exists $args{'acquisition'}) {
        $query_params->{'acquisition'} = $self->{api_client}->to_query_value($args{'acquisition'});
    }

    # query params
    if ( exists $args{'magnetic_field_strength'}) {
        $query_params->{'magnetic_field_strength'} = $self->{api_client}->to_query_value($args{'magnetic_field_strength'});
    }

    # query params
    if ( exists $args{'solvent'}) {
        $query_params->{'solvent'} = $self->{api_client}->to_query_value($args{'solvent'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Spectrum]', $response);
    return $_response_object;
}

#
# get_spectra_matching_peaks
#
# Perform a Spectra naïve Peakmachting query (without either ranking or scoring; return all spectra with at least one peak matching the query)
#
# @param string $spectra_type the mandatory spectra type (required)
# @param string $column_code the optional column code (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param string $polarity the optional mass polarity mode (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param string $resolution the optional mass resolution filter (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $rt_min the starting range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $rt_max the ending range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param ARRAY[double] $list_mz the optional list of MZ to match (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional)
# @param double $precursor_mz the optional MS precursor MZ to match (only for LC-MSMS spectra matching) (optional)
# @param double $delta the delta tolerance for MZ or PPM peaks matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching) (optional, default to 0.05)
# @param ARRAY[double] $list_ppm the optional list of PPM to match (only for either 1D-NMR spectra matching) (optional)
# @param ARRAY[double] $list_ppm_f1 the optional list of PPM to match in F1 (only for either 2D-NMR spectra matching) (optional)
# @param ARRAY[double] $list_ppm_f2 the optional list of PPM to match in F2 (only for either 2D-NMR spectra matching) (optional)
{
    my $params = {
    'spectra_type' => {
        data_type => 'string',
        description => 'the mandatory spectra type',
        required => '1',
    },
    'column_code' => {
        data_type => 'string',
        description => 'the optional column code (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'polarity' => {
        data_type => 'string',
        description => 'the optional mass polarity mode (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'resolution' => {
        data_type => 'string',
        description => 'the optional mass resolution filter (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'rt_min' => {
        data_type => 'double',
        description => 'the starting range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'rt_max' => {
        data_type => 'double',
        description => 'the ending range to Retention Time in peak matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'list_mz' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of MZ to match (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'precursor_mz' => {
        data_type => 'double',
        description => 'the optional MS precursor MZ to match (only for LC-MSMS spectra matching)',
        required => '0',
    },
    'delta' => {
        data_type => 'double',
        description => 'the delta tolerance for MZ or PPM peaks matching (only for either LC-MS / LC-MSMS or GC-MS spectra matching)',
        required => '0',
    },
    'list_ppm' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match (only for either 1D-NMR spectra matching)',
        required => '0',
    },
    'list_ppm_f1' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match in F1 (only for either 2D-NMR spectra matching)',
        required => '0',
    },
    'list_ppm_f2' => {
        data_type => 'ARRAY[double]',
        description => 'the optional list of PPM to match in F2 (only for either 2D-NMR spectra matching)',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_spectra_matching_peaks' } = {
        summary => 'Perform a Spectra naïve Peakmachting query (without either ranking or scoring; return all spectra with at least one peak matching the query)',
        params => $params,
        returns => 'ARRAY[Spectrum]',
        };
}
# @return ARRAY[Spectrum]
#
sub get_spectra_matching_peaks {
    my ($self, %args) = @_;

    # verify the required parameter 'spectra_type' is set
    unless (exists $args{'spectra_type'}) {
      croak("Missing the required parameter 'spectra_type' when calling get_spectra_matching_peaks");
    }

    # parse inputs
    my $_resource_path = '/spectra-peakmatching/{spectraType}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'column_code'}) {
        $query_params->{'column_code'} = $self->{api_client}->to_query_value($args{'column_code'});
    }

    # query params
    if ( exists $args{'polarity'}) {
        $query_params->{'polarity'} = $self->{api_client}->to_query_value($args{'polarity'});
    }

    # query params
    if ( exists $args{'resolution'}) {
        $query_params->{'resolution'} = $self->{api_client}->to_query_value($args{'resolution'});
    }

    # query params
    if ( exists $args{'rt_min'}) {
        $query_params->{'rt_min'} = $self->{api_client}->to_query_value($args{'rt_min'});
    }

    # query params
    if ( exists $args{'rt_max'}) {
        $query_params->{'rt_max'} = $self->{api_client}->to_query_value($args{'rt_max'});
    }

    # query params
    if ( exists $args{'list_mz'}) {
        $query_params->{'list_mz'} = $self->{api_client}->to_query_value($args{'list_mz'});
    }

    # query params
    if ( exists $args{'precursor_mz'}) {
        $query_params->{'precursor_mz'} = $self->{api_client}->to_query_value($args{'precursor_mz'});
    }

    # query params
    if ( exists $args{'delta'}) {
        $query_params->{'delta'} = $self->{api_client}->to_query_value($args{'delta'});
    }

    # query params
    if ( exists $args{'list_ppm'}) {
        $query_params->{'list_ppm'} = $self->{api_client}->to_query_value($args{'list_ppm'});
    }

    # query params
    if ( exists $args{'list_ppm_f1'}) {
        $query_params->{'list_ppm_f1'} = $self->{api_client}->to_query_value($args{'list_ppm_f1'});
    }

    # query params
    if ( exists $args{'list_ppm_f2'}) {
        $query_params->{'list_ppm_f2'} = $self->{api_client}->to_query_value($args{'list_ppm_f2'});
    }

    # path params
    if ( exists $args{'spectra_type'}) {
        my $_base_variable = "{" . "spectraType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'spectra_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Spectrum]', $response);
    return $_response_object;
}

#
# get_spectrum
#
# Get a spectrum by its PeakForest ID
#
# @param string $id The PeakForest ID of the spectrum to get. (required)
{
    my $params = {
    'id' => {
        data_type => 'string',
        description => 'The PeakForest ID of the spectrum to get.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_spectrum' } = {
        summary => 'Get a spectrum by its PeakForest ID',
        params => $params,
        returns => 'Spectrum',
        };
}
# @return Spectrum
#
sub get_spectrum {
    my ($self, %args) = @_;

    # verify the required parameter 'id' is set
    unless (exists $args{'id'}) {
      croak("Missing the required parameter 'id' when calling get_spectrum");
    }

    # parse inputs
    my $_resource_path = '/spectrum/{id}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'id'}) {
        my $_base_variable = "{" . "id" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Spectrum', $response);
    return $_response_object;
}

#
# post_spectra
#
# Create a new spectra or spectrum with provided data
#
# @param NewSpectraDataToImport $new_spectra_data_to_import The project to add (required)
{
    my $params = {
    'new_spectra_data_to_import' => {
        data_type => 'NewSpectraDataToImport',
        description => 'The project to add',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_spectra' } = {
        summary => 'Create a new spectra or spectrum with provided data',
        params => $params,
        returns => 'ARRAY[string]',
        };
}
# @return ARRAY[string]
#
sub post_spectra {
    my ($self, %args) = @_;

    # verify the required parameter 'new_spectra_data_to_import' is set
    unless (exists $args{'new_spectra_data_to_import'}) {
      croak("Missing the required parameter 'new_spectra_data_to_import' when calling post_spectra");
    }

    # parse inputs
    my $_resource_path = '/spectrum';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    # body params
    if ( exists $args{'new_spectra_data_to_import'}) {
        $_body_data = $args{'new_spectra_data_to_import'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[string]', $response);
    return $_response_object;
}

1;
