package App::Manoc::Form::DeviceIface::Populate;
#ABSTRACT: Manoc Form for entering interface notes.

use HTML::FormHandler::Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

extends 'App::Manoc::Form::Base';

has '+name' => ( default => 'form-ifnotes' );

has 'schema' => ( is => 'rw' );

has 'device' => (
    is       => 'ro',
    isa      => 'Object',
    required => 1,
    trigger  => sub { shift->set_device(@_) }
);

sub set_device {
    my ( $self, $device ) = @_;
    $self->schema( $device->result_source->schema );
}

has_field 'prefix' => (
    label    => 'Prefix',
    type     => 'Text',
    required => 1,
);

has_field 'range_min' => (
    label    => 'Min',
    type     => 'Text',
    required => 1,
);

has_field 'range_max' => (
    label    => 'Max',
    type     => 'Text',
    required => 1,
);

has_field 'save' => (
    type           => 'Submit',
    widget         => 'ButtonTag',
    element_attr   => { class => [ 'btn', 'btn-primary' ] },
    widget_wrapper => 'None',
    value          => "Save"
);

sub update_model {
    my $self = shift;

    my $device = $self->device;

    my $prefix = $self->value->{prefix};
    my $min    = $self->value->{range_min};
    my $max    = $self->value->{range_max};

    $self->schema->txn_do(
        sub {
            for ( my $i = $min; $i <= $max; $i++ ) {
                $device->add_to_interfaces( { name => "$prefix$i" } );
            }
        }
    );
}
__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::DeviceIface::Populate - Manoc Form for entering interface notes.

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
