/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.RuntimeContext;
import com.javonet.sdk.internal.AbstractConfigRuntimeFactory;
import com.javonet.sdk.tools.JsonFileResolver;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.RuntimeNameHandler;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;
import java.io.File;
import java.net.UnknownHostException;
import java.nio.file.Paths;

public class ConfigRuntimeFactory
implements AbstractConfigRuntimeFactory {
    private final String path_;

    public ConfigRuntimeFactory(String path) {
        this.path_ = path;
        Transmitter.setConfigSource(path);
    }

    @Override
    public RuntimeContext clr(String configName) {
        return this.getRuntimeContext(RuntimeName.Clr, configName);
    }

    @Override
    public RuntimeContext jvm(String configName) {
        return this.getRuntimeContext(RuntimeName.Jvm, configName);
    }

    @Override
    public RuntimeContext netcore(String configName) {
        return this.getRuntimeContext(RuntimeName.Netcore, configName);
    }

    @Override
    public RuntimeContext perl(String configName) {
        return this.getRuntimeContext(RuntimeName.Perl, configName);
    }

    @Override
    public RuntimeContext ruby(String configName) {
        return this.getRuntimeContext(RuntimeName.Ruby, configName);
    }

    @Override
    public RuntimeContext nodejs(String configName) {
        return this.getRuntimeContext(RuntimeName.Nodejs, configName);
    }

    @Override
    public RuntimeContext python(String configName) {
        return this.getRuntimeContext(RuntimeName.Python, configName);
    }

    private RuntimeContext getRuntimeContext(RuntimeName runtime, String configName) {
        JsonFileResolver jfr = new JsonFileResolver(this.path_);
        try {
            String licenseKey = jfr.getLicenseKey();
            Transmitter.activate(licenseKey);
        }
        catch (Exception licenseKey) {
            // empty catch block
        }
        String connType = jfr.getChannelType(RuntimeNameHandler.getName(runtime), configName);
        IConnectionData connData = null;
        if ("inMemory".equals(connType)) {
            connData = new InMemoryConnectionData();
        } else if ("tcp".equals(connType)) {
            try {
                connData = new TcpConnectionData(jfr.getChannelHost(RuntimeNameHandler.getName(runtime), configName), jfr.getChannelPort(RuntimeNameHandler.getName(runtime), configName));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else if ("webSocket".equals(connType)) {
            connData = new WsConnectionData(jfr.getChannelHost(RuntimeNameHandler.getName(runtime), configName));
        } else {
            throw new RuntimeException("Invalid connection type");
        }
        RuntimeContext rtmCtx = RuntimeContext.getInstance(runtime, connData);
        this.loadModules(runtime, configName, jfr, rtmCtx);
        return rtmCtx;
    }

    private void loadModules(RuntimeName runtime, String configName, JsonFileResolver jfr, RuntimeContext rtmCtx) {
        String[] modules = jfr.getModules(RuntimeNameHandler.getName(runtime), configName).split(";");
        String configDirectoryAbsolutePath = Paths.get(this.path_, new String[0]).getParent().toAbsolutePath().toString();
        for (String module : modules) {
            if (module.isEmpty()) continue;
            if (Paths.get(module, new String[0]).isAbsolute()) {
                rtmCtx.loadLibrary(module);
                continue;
            }
            rtmCtx.loadLibrary(configDirectoryAbsolutePath + File.separator + module);
        }
    }
}

