/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.namespacecache;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NamespacesCache {
    private static NamespacesCache instance;
    private static final List<String> NAMESPACES_CACHE;
    private static final Object listLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamespacesCache getInstance() {
        Object object = listLock;
        synchronized (object) {
            if (instance == null) {
                instance = new NamespacesCache();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheNamespace(String namespaceRegex) {
        Object object = listLock;
        synchronized (object) {
            NAMESPACES_CACHE.add(namespaceRegex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheNamespace(String[] namespaceRegexes) {
        Object object = listLock;
        synchronized (object) {
            for (String namespaceRegex : namespaceRegexes) {
                NAMESPACES_CACHE.add(namespaceRegex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNamespaceCacheEmpty() {
        Object object = listLock;
        synchronized (object) {
            return NAMESPACES_CACHE.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTypeAllowed(Class<?> typeToCheck) {
        Object object = listLock;
        synchronized (object) {
            String typeNamespace = typeToCheck.getPackage().getName();
            for (String namespaceRegex : NAMESPACES_CACHE) {
                if (!Pattern.matches(namespaceRegex, typeNamespace)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCachedNamespaces() {
        Object object = listLock;
        synchronized (object) {
            return NAMESPACES_CACHE.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = listLock;
        synchronized (object) {
            NAMESPACES_CACHE.clear();
        }
    }

    static {
        NAMESPACES_CACHE = new ArrayList<String>();
        listLock = new Object();
    }
}

