# Generated by default/object.tt
package Paws::AppRunner::CodeConfigurationValues;
  use Moose;
  has BuildCommand => (is => 'ro', isa => 'Str');
  has Port => (is => 'ro', isa => 'Str');
  has Runtime => (is => 'ro', isa => 'Str', required => 1);
  has RuntimeEnvironmentVariables => (is => 'ro', isa => 'Paws::AppRunner::RuntimeEnvironmentVariables');
  has StartCommand => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::CodeConfigurationValues

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::CodeConfigurationValues object:

  $service_obj->Method(Att1 => { BuildCommand => $value, ..., StartCommand => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::CodeConfigurationValues object:

  $result = $service_obj->Method(...);
  $result->Att1->BuildCommand

=head1 DESCRIPTION

Describes the basic configuration needed for building and running an
AWS App Runner service. This type doesn't support the full set of
possible configuration options. Fur full configuration capabilities,
use a C<apprunner.yaml> file in the source code repository.

=head1 ATTRIBUTES


=head2 BuildCommand => Str

The command App Runner runs to build your application.


=head2 Port => Str

The port that your application listens to in the container.

Default: C<8080>


=head2 B<REQUIRED> Runtime => Str

A runtime environment type for building and running an App Runner
service. It represents a programming language runtime.


=head2 RuntimeEnvironmentVariables => L<Paws::AppRunner::RuntimeEnvironmentVariables>

The environment variables that are available to your running App Runner
service. An array of key-value pairs. Keys with a prefix of
C<AWSAPPRUNNER> are reserved for system use and aren't valid.


=head2 StartCommand => Str

The command App Runner runs to start your application.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

