# Generated by default/object.tt
package Paws::LexModels::OutputContext;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has TimeToLiveInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeToLiveInSeconds', traits => ['NameInRequest'], required => 1);
  has TurnsToLive => (is => 'ro', isa => 'Int', request_name => 'turnsToLive', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModels::OutputContext

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModels::OutputContext object:

  $service_obj->Method(Att1 => { Name => $value, ..., TurnsToLive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModels::OutputContext object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

The specification of an output context that is set when an intent is
fulfilled.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the context.


=head2 B<REQUIRED> TimeToLiveInSeconds => Int

The number of seconds that the context should be active after it is
first sent in a C<PostContent> or C<PostText> response. You can set the
value between 5 and 86,400 seconds (24 hours).


=head2 B<REQUIRED> TurnsToLive => Int

The number of conversation turns that the context should be active. A
conversation turn is one C<PostContent> or C<PostText> request and the
corresponding response from Amazon Lex.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModels>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

