package Clair::ChisqIndependent;

use Carp;
use Exporter;
use Statistics::ChisqIndep;
use Statistics::Distributions qw (chisqrprob);

$VERSION = 0.01;
@ISA=qw(Exporter Statistics::ChisqIndep);
@EXPORT = qw(recompute_chisq);

sub recompute_chisq {
	my $self = shift;
	my $df = $self->{df};
	my $chisq = $self->{chisq_statistic};

	if ($df < 0 || $chisq < 0) {
		croak "error: df = $df\tchisq = $chisq";
	}
	
	my $chiprob = chisqrprob($df, $chisq);
#	print "Generated by ChisqIndependt\n";
	$self->{p_value} = $chiprob;

	return 1;
}


=head1 NAME

Clair::ChisqIndependent - compute the Chi square for the CLAIR Library

head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

This module works for Gen to produce the Chi square for given data. It's subclassed from Statistics::ChisqIndep, and add one more method: recompute_chisq to compute the p-value of the data when degree of freedom changes

=head 1 METHODS

=cut

=head2 recompute_chisq() 

return the p-value when the degree of freedom is changed.


=head1 AUTHOR

Chen, Huang << <clair at umich.edu> >>

=head1 BUGS

Please report any bugs or feature requests to 
C<bug-clair-document at rt.cpan.org>, or through the web interface at

=head1 SUPPORT

You can find documentation for this module with the perldoc command.   

    perldoc Clair::ChisqIndependent

You can also look for information at:         

=over 4

=item * AnnoCPAN: Annotated CPAN documentation                                     

L<http://annocpan.org/dist/clairlib-dev>                                           

=item * CPAN Ratings                                                               

L<http://cpanratings.perl.org/d/clairlib-dev>                                      

=item * RT: CPAN's request tracker                                                 

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=clairlib-dev>                           

=item * Search CPAN                                                                

L<http://search.cpan.org/dist/clairlib-dev>                                        

=back                                              

=head1 COPYRIGHT & LICENSE                                                         

Copyright 2008 The University of Michigan, all rights reserved.                    

This program is free software; you can redistribute it and/or modify it            
under the same terms as Perl itself.                                               

=cut        
1;
