// This file is part of MorphoDiTa.
//
// Copyright 2013 by Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// MorphoDiTa is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of
// the License, or (at your option) any later version.
//
// MorphoDiTa is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with MorphoDiTa.  If not, see <http://www.gnu.org/licenses/>.

#include <cstring>
#include <unordered_set>

#include "generic_tokenizer.h"
#include "../unilib/unicode.h"
#include "../unilib/utf8.h"

namespace ufal {
namespace morphodita {


static const char _generic_tokenizer_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2
};

static const char _generic_tokenizer_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _generic_tokenizer_cond_keys[] = {
	43u, 43u, 45u, 45u, 0
};

static const char _generic_tokenizer_cond_spaces[] = {
	1, 0, 0
};

static const short _generic_tokenizer_key_offsets[] = {
	0, 0, 1, 2, 3, 5, 8, 9, 
	10, 45, 76, 77, 81, 113, 144, 175, 
	206, 236, 243, 247, 257, 278, 280, 296, 
	324, 356, 382, 384, 385, 387, 397, 399, 
	403, 404, 436, 464, 472, 480, 488, 496, 
	513, 519, 521, 522, 540, 541, 542, 545, 
	552, 558, 569, 572, 574, 586, 607, 617, 
	618, 619, 629, 634, 657, 671, 685, 713, 
	735, 740, 741, 748, 754, 758, 761, 764, 
	765, 767, 768, 784, 788, 792, 804, 806, 
	818, 825, 829, 831, 835, 839, 843, 846, 
	848, 850, 852, 853, 855, 865, 867, 884, 
	893, 896, 897, 908, 922, 934, 947, 956, 
	964, 971, 979, 985, 993, 1010, 1012, 1020, 
	1029, 1037, 1046, 1054, 1063, 1071, 1079, 1090, 
	1100, 1108, 1116, 1127, 1137, 1145, 1153, 1164, 
	1174, 1190, 1192, 1193, 1195, 1196, 1198, 1207, 
	1213, 1216, 1217, 1220, 1227, 1233, 1244, 1247, 
	1257, 1258, 1270, 1275, 1276, 1282, 1289, 1291, 
	1294, 1325, 1340, 1356, 1370, 1386, 1401, 1415, 
	1431, 1443, 1459, 1475, 1492, 1508, 1525, 1550, 
	1567, 1583, 1600, 1617, 1634, 1651, 1671, 1690, 
	1706, 1722, 1741, 1759, 1784, 1806, 1808, 1810, 
	1812, 1825, 1827, 1829, 1839, 1841, 1845, 1851, 
	1855, 1856, 1860, 1861, 1870, 1872, 1874, 1875, 
	1877, 1900, 1902, 1914, 1924, 1926, 1928, 1941, 
	1943, 1945, 1955, 1957, 1961, 1967, 1971, 1972, 
	1976, 1977, 1986, 1988, 1990, 1991, 1993, 2015, 
	2040, 2063, 2065, 2075, 2077, 2079, 2092, 2094, 
	2096, 2106, 2108, 2112, 2118, 2122, 2123, 2127, 
	2128, 2137, 2139, 2141, 2142, 2144, 2155, 2156, 
	2171, 2187, 2204, 2220, 2237, 2253, 2270, 2286, 
	2302, 2321, 2339, 2355, 2371, 2390, 2408, 2424, 
	2440, 2459, 2477, 2480, 2486, 2488, 2496, 2503, 
	2511, 2515, 2519, 2523, 2528, 2533, 2542, 2546, 
	2550, 2561, 2563, 2567, 2569, 2572, 2604, 2606, 
	2608, 2610, 2612, 2616, 2631, 2644, 2663, 2675, 
	2691, 2700, 2716, 2729, 2750, 2758, 2770, 2782, 
	2796, 2809, 2819, 2830, 2839, 2849, 2851, 2853, 
	2874, 2881, 2889, 2895, 2901, 2902, 2946, 2952, 
	2960, 2971, 2981, 2988, 2994, 2998, 3002, 3004, 
	3006, 3010, 3014, 3018, 3024, 3032, 3037, 3041, 
	3043, 3047, 3049, 3055, 3059, 3063, 3065, 3069, 
	3074, 3077, 3081, 3085, 3087, 3091, 3097, 3101, 
	3107, 3118, 3123, 3137, 3152, 3154, 3156, 3158, 
	3174, 3177, 3179, 3183, 3187, 3191, 3197, 3201, 
	3211, 3221, 3222, 3232, 3240, 3248, 3252, 3256, 
	3260, 3262, 3267, 3269, 3272, 3274, 3299, 3301, 
	3307, 3312, 3316, 3320, 3324, 3332, 3334, 3336, 
	3341, 3345, 3349, 3355, 3357, 3363, 3371, 3383, 
	3389, 3393, 3397, 3401, 3405, 3424, 3428, 3430, 
	3441, 3447, 3449, 3451, 3455, 3459, 3463, 3467, 
	3469, 3471, 3475, 3477, 3485, 3498, 3532, 3541, 
	3545, 3547, 3548, 3552, 3555, 3559, 3564, 3568, 
	3572, 3574, 3578, 3580, 3584, 3593, 3597, 3599, 
	3603, 3607, 3620, 3622, 3624, 3628, 3632, 3634, 
	3636, 3659, 3662, 3664, 3667, 3670, 3674, 3676, 
	3689, 3692, 3696, 3697, 3699, 3701, 3704, 3706, 
	3709, 3711, 3714, 3716, 3727, 3733, 3735, 3739, 
	3741, 3745, 3747, 3751, 3757, 3773, 3779, 3785, 
	3787, 3791, 3805, 3809, 3821, 3828, 3832, 3839, 
	3845, 3851, 3857, 3861, 3867, 3871, 3885, 3911, 
	3921, 3924, 3926, 3930, 3933, 3934, 3937, 3939, 
	3961, 3985, 4056, 4064, 4071, 4077, 4084, 4092, 
	4093, 4101, 4102, 4110, 4141, 4151, 4168, 4171, 
	4181, 4191, 4201, 4211, 4224, 4236, 4250, 4276, 
	4293, 4307, 4324, 4350, 4376, 4398, 4408, 4432, 
	4444, 4470, 4496, 4525, 4553, 4579, 4603, 4616, 
	4642, 4668, 4697, 4725, 4741, 4790, 4839, 4888, 
	4905, 4922, 4939, 4959, 4978, 5015, 5017, 5023, 
	5033, 5072, 5076, 5078, 5092, 5102, 5110, 5113, 
	5119, 5122, 5129, 5133, 5143, 5147, 5158, 5173, 
	5191, 5198, 5202, 5207, 5218, 5250, 5257, 5261, 
	5267, 5274, 5286, 5308, 5322, 5340, 5355, 5367, 
	5378, 5396, 5408, 5438, 5445, 5455, 5469, 5480, 
	5494, 5503, 5516, 5528, 5536, 5542, 5550, 5577, 
	5590, 5597, 5602, 5608, 5654, 5659, 5682, 5693, 
	5702, 5715, 5728, 5736, 5743, 5747, 5753, 5757, 
	5760, 5766, 5773, 5781, 5790, 5799, 5803, 5811, 
	5819, 5823, 5830, 5834, 5838, 5850, 5854, 5863, 
	5869, 5873, 5882, 5888, 5898, 5910, 5914, 5918, 
	5930, 5941, 5951, 5967, 5972, 5996, 6013, 6019, 
	6037, 6042, 6048, 6071, 6078, 6084, 6087, 6090, 
	6102, 6110, 6115, 6125, 6132, 6135, 6147, 6162, 
	6169, 6172, 6180, 6188, 6192, 6196, 6198, 6201, 
	6205, 6232, 6238, 6250, 6255, 6261, 6269, 6282, 
	6286, 6293, 6299, 6310, 6318, 6326, 6332, 6347, 
	6351, 6367, 6380, 6397, 6414, 6423, 6431, 6437, 
	6443, 6451, 6472, 6478, 6482, 6497, 6501, 6505, 
	6509, 6513, 6517, 6523, 6531, 6536, 6540, 6550, 
	6557, 6560, 6578, 6595, 6634, 6640, 6648, 6652, 
	6658, 6662, 6668, 6677, 6685, 6693, 6699, 6703, 
	6711, 6723, 6731, 6739, 6745, 6754, 6760, 6764, 
	6769, 6777, 6781, 6785, 6810, 6816, 6822, 6828, 
	6838, 6846, 6853, 6859, 6869, 6874, 6882, 6888, 
	6892, 6903, 6907, 6914, 6918, 6922, 6929, 6933, 
	6938, 6943, 6958, 6965, 6971, 6985, 6989, 6994, 
	7000, 7006, 7010, 7018, 7026, 7043, 7046, 7061, 
	7064, 7075, 7083, 7089, 7094, 7098, 7102, 7106, 
	7113, 7123, 7127, 7142, 7171, 7182, 7185, 7189, 
	7195, 7199, 7206, 7228, 7253
};

static const short _generic_tokenizer_trans_keys[] = {
	160u, 154u, 128u, 128u, 129u, 175u, 128u, 138u, 
	159u, 128u, 13u, 32u, 34u, 40u, 91u, 96u, 
	123u, 194u, 195u, 196u, 197u, 198u, 199u, 200u, 
	201u, 205u, 206u, 207u, 208u, 209u, 210u, 211u, 
	212u, 213u, 224u, 225u, 226u, 227u, 234u, 239u, 
	240u, 9u, 10u, 65u, 90u, 34u, 40u, 91u, 
	96u, 123u, 194u, 195u, 196u, 197u, 198u, 199u, 
	200u, 201u, 205u, 206u, 207u, 208u, 209u, 210u, 
	211u, 212u, 213u, 224u, 225u, 226u, 227u, 234u, 
	239u, 240u, 65u, 90u, 171u, 128u, 150u, 152u, 
	158u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 185u, 187u, 189u, 
	191u, 129u, 131u, 133u, 135u, 138u, 140u, 142u, 
	144u, 146u, 148u, 150u, 152u, 154u, 156u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 187u, 189u, 184u, 185u, 
	132u, 162u, 164u, 169u, 172u, 181u, 188u, 129u, 
	130u, 134u, 135u, 137u, 139u, 142u, 145u, 147u, 
	148u, 150u, 152u, 156u, 157u, 159u, 160u, 166u, 
	167u, 174u, 175u, 177u, 179u, 183u, 184u, 141u, 
	143u, 145u, 147u, 149u, 151u, 153u, 155u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	180u, 186u, 188u, 190u, 132u, 133u, 135u, 136u, 
	138u, 139u, 177u, 178u, 182u, 184u, 128u, 130u, 
	132u, 134u, 136u, 138u, 140u, 142u, 144u, 146u, 
	148u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 176u, 178u, 
	186u, 187u, 189u, 190u, 129u, 136u, 138u, 140u, 
	142u, 131u, 134u, 176u, 178u, 182u, 191u, 134u, 
	140u, 136u, 138u, 142u, 143u, 145u, 161u, 163u, 
	171u, 143u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 180u, 183u, 
	146u, 148u, 185u, 186u, 189u, 191u, 128u, 175u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 184u, 186u, 188u, 190u, 
	128u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 176u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 131u, 133u, 135u, 137u, 
	139u, 141u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 164u, 166u, 168u, 170u, 
	172u, 174u, 176u, 178u, 180u, 182u, 184u, 186u, 
	188u, 190u, 128u, 129u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 177u, 191u, 128u, 150u, 
	188u, 186u, 188u, 130u, 131u, 154u, 186u, 188u, 
	189u, 190u, 191u, 184u, 187u, 160u, 191u, 135u, 
	141u, 128u, 133u, 155u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 176u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 184u, 186u, 188u, 190u, 
	136u, 143u, 152u, 157u, 168u, 175u, 184u, 191u, 
	153u, 155u, 157u, 159u, 136u, 141u, 168u, 175u, 
	136u, 143u, 152u, 159u, 168u, 175u, 184u, 188u, 
	136u, 140u, 152u, 155u, 168u, 172u, 184u, 188u, 
	128u, 129u, 130u, 132u, 133u, 134u, 140u, 157u, 
	159u, 166u, 167u, 176u, 177u, 178u, 179u, 184u, 
	185u, 152u, 185u, 154u, 156u, 158u, 159u, 133u, 
	189u, 141u, 130u, 135u, 149u, 164u, 166u, 168u, 
	139u, 141u, 144u, 146u, 153u, 157u, 170u, 173u, 
	176u, 179u, 190u, 191u, 133u, 131u, 136u, 138u, 
	169u, 168u, 170u, 172u, 174u, 176u, 178u, 180u, 
	133u, 166u, 168u, 170u, 172u, 174u, 131u, 133u, 
	135u, 137u, 139u, 141u, 143u, 145u, 147u, 149u, 
	151u, 152u, 154u, 188u, 128u, 174u, 160u, 167u, 
	169u, 171u, 178u, 181u, 162u, 164u, 173u, 176u, 
	190u, 191u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 171u, 173u, 178u, 130u, 
	132u, 137u, 140u, 156u, 160u, 162u, 164u, 166u, 
	168u, 130u, 128u, 136u, 138u, 140u, 142u, 144u, 
	148u, 150u, 152u, 154u, 157u, 153u, 154u, 156u, 
	157u, 158u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 164u, 166u, 168u, 170u, 
	172u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 178u, 180u, 
	182u, 184u, 186u, 188u, 190u, 128u, 130u, 132u, 
	134u, 136u, 138u, 140u, 142u, 144u, 146u, 148u, 
	150u, 152u, 154u, 156u, 158u, 160u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 185u, 187u, 189u, 
	190u, 128u, 130u, 132u, 134u, 139u, 141u, 144u, 
	146u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 173u, 176u, 177u, 180u, 
	184u, 185u, 188u, 189u, 191u, 151u, 181u, 183u, 
	185u, 187u, 189u, 191u, 129u, 131u, 135u, 153u, 
	155u, 157u, 136u, 187u, 161u, 186u, 155u, 159u, 
	162u, 144u, 145u, 157u, 144u, 128u, 167u, 162u, 
	144u, 145u, 146u, 147u, 148u, 149u, 150u, 151u, 
	152u, 153u, 154u, 155u, 156u, 157u, 158u, 159u, 
	128u, 153u, 180u, 191u, 128u, 141u, 168u, 191u, 
	156u, 162u, 128u, 129u, 158u, 159u, 165u, 166u, 
	169u, 172u, 174u, 181u, 144u, 169u, 132u, 133u, 
	135u, 138u, 141u, 148u, 150u, 156u, 184u, 185u, 
	187u, 190u, 134u, 128u, 132u, 138u, 144u, 172u, 
	191u, 128u, 133u, 160u, 185u, 148u, 173u, 136u, 
	161u, 188u, 191u, 128u, 149u, 176u, 191u, 128u, 
	137u, 168u, 191u, 128u, 162u, 186u, 156u, 180u, 
	150u, 174u, 144u, 168u, 138u, 160u, 171u, 130u, 
	131u, 154u, 186u, 188u, 189u, 190u, 191u, 184u, 
	187u, 128u, 155u, 128u, 129u, 130u, 132u, 133u, 
	134u, 140u, 157u, 159u, 166u, 167u, 176u, 177u, 
	178u, 179u, 184u, 185u, 152u, 175u, 185u, 128u, 
	138u, 154u, 156u, 158u, 159u, 133u, 159u, 189u, 
	128u, 128u, 136u, 138u, 140u, 142u, 144u, 148u, 
	150u, 152u, 154u, 157u, 33u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 48u, 49u, 50u, 51u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 39u, 41u, 61u, 95u, 36u, 47u, 
	48u, 57u, 58u, 59u, 63u, 64u, 65u, 90u, 
	97u, 122u, 48u, 57u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 48u, 49u, 50u, 51u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 48u, 49u, 50u, 
	51u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 49u, 
	50u, 51u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 53u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 53u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 53u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 13u, 32u, 
	34u, 39u, 41u, 59u, 93u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 160u, 187u, 
	188u, 187u, 189u, 154u, 128u, 156u, 128u, 129u, 
	130u, 140u, 157u, 159u, 166u, 167u, 184u, 153u, 
	157u, 175u, 186u, 128u, 138u, 134u, 159u, 190u, 
	142u, 137u, 139u, 170u, 169u, 171u, 173u, 175u, 
	177u, 179u, 181u, 134u, 167u, 169u, 171u, 173u, 
	175u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 150u, 152u, 153u, 155u, 189u, 131u, 
	133u, 138u, 141u, 157u, 161u, 163u, 165u, 167u, 
	169u, 128u, 128u, 137u, 139u, 141u, 143u, 145u, 
	149u, 151u, 153u, 155u, 158u, 159u, 180u, 184u, 
	185u, 188u, 189u, 190u, 152u, 182u, 184u, 186u, 
	188u, 190u, 128u, 130u, 132u, 136u, 154u, 156u, 
	158u, 137u, 189u, 157u, 160u, 163u, 13u, 32u, 
	33u, 34u, 40u, 58u, 59u, 64u, 93u, 95u, 
	125u, 194u, 224u, 225u, 226u, 227u, 239u, 9u, 
	10u, 36u, 37u, 39u, 41u, 42u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 48u, 49u, 
	50u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	51u, 57u, 65u, 90u, 97u, 122u, 33u, 48u, 
	49u, 50u, 58u, 64u, 95u, 36u, 37u, 39u, 
	46u, 51u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	48u, 49u, 50u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 51u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 53u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 53u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	43u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 160u, 169u, 
	176u, 185u, 128u, 137u, 165u, 167u, 169u, 171u, 
	173u, 175u, 177u, 179u, 181u, 183u, 185u, 187u, 
	188u, 166u, 175u, 144u, 153u, 129u, 130u, 159u, 
	160u, 165u, 167u, 170u, 173u, 174u, 177u, 134u, 
	143u, 128u, 137u, 144u, 153u, 152u, 163u, 164u, 
	167u, 169u, 175u, 144u, 153u, 176u, 185u, 188u, 
	144u, 145u, 150u, 157u, 146u, 129u, 131u, 132u, 
	135u, 139u, 147u, 153u, 155u, 163u, 182u, 191u, 
	169u, 173u, 159u, 142u, 191u, 33u, 45u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 160u, 169u, 43u, 45u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 176u, 185u, 128u, 137u, 
	165u, 167u, 169u, 171u, 173u, 175u, 177u, 179u, 
	181u, 183u, 185u, 187u, 188u, 166u, 175u, 144u, 
	153u, 129u, 130u, 159u, 160u, 165u, 167u, 170u, 
	173u, 174u, 177u, 134u, 143u, 128u, 137u, 144u, 
	153u, 152u, 163u, 164u, 167u, 169u, 175u, 144u, 
	153u, 176u, 185u, 188u, 144u, 145u, 150u, 157u, 
	146u, 129u, 131u, 132u, 135u, 139u, 147u, 153u, 
	155u, 163u, 182u, 191u, 169u, 173u, 159u, 142u, 
	191u, 33u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	43u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 160u, 
	169u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 176u, 185u, 128u, 137u, 165u, 
	167u, 169u, 171u, 173u, 175u, 177u, 179u, 181u, 
	183u, 185u, 187u, 188u, 166u, 175u, 144u, 153u, 
	129u, 130u, 159u, 160u, 165u, 167u, 170u, 173u, 
	174u, 177u, 134u, 143u, 128u, 137u, 144u, 153u, 
	152u, 163u, 164u, 167u, 169u, 175u, 144u, 153u, 
	176u, 185u, 188u, 144u, 145u, 150u, 157u, 146u, 
	129u, 131u, 132u, 135u, 139u, 147u, 153u, 155u, 
	163u, 182u, 191u, 169u, 173u, 159u, 142u, 191u, 
	33u, 47u, 95u, 36u, 37u, 39u, 57u, 65u, 
	90u, 97u, 122u, 47u, 33u, 48u, 49u, 50u, 
	95u, 36u, 37u, 39u, 46u, 51u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 48u, 49u, 50u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 51u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 48u, 49u, 50u, 
	58u, 64u, 95u, 36u, 37u, 39u, 46u, 51u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 48u, 49u, 
	50u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	51u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 53u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 53u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 52u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 170u, 181u, 186u, 
	128u, 150u, 152u, 182u, 184u, 191u, 128u, 191u, 
	172u, 174u, 128u, 129u, 134u, 145u, 160u, 164u, 
	191u, 128u, 180u, 182u, 183u, 186u, 189u, 134u, 
	140u, 136u, 138u, 142u, 161u, 163u, 191u, 128u, 
	181u, 183u, 191u, 128u, 129u, 131u, 191u, 128u, 
	175u, 177u, 191u, 153u, 128u, 150u, 161u, 191u, 
	191u, 128u, 135u, 145u, 189u, 135u, 129u, 130u, 
	132u, 133u, 144u, 170u, 176u, 178u, 144u, 154u, 
	160u, 191u, 128u, 159u, 174u, 191u, 191u, 128u, 
	147u, 149u, 156u, 159u, 168u, 170u, 175u, 186u, 
	188u, 144u, 191u, 128u, 138u, 141u, 191u, 128u, 
	177u, 186u, 138u, 181u, 160u, 161u, 162u, 163u, 
	164u, 165u, 166u, 167u, 168u, 169u, 170u, 171u, 
	172u, 173u, 174u, 175u, 176u, 177u, 178u, 179u, 
	180u, 181u, 182u, 183u, 184u, 185u, 186u, 187u, 
	188u, 189u, 190u, 191u, 128u, 173u, 128u, 155u, 
	160u, 178u, 164u, 191u, 128u, 163u, 177u, 191u, 
	178u, 128u, 131u, 133u, 140u, 143u, 144u, 147u, 
	168u, 170u, 176u, 182u, 185u, 188u, 191u, 151u, 
	128u, 132u, 135u, 136u, 139u, 142u, 156u, 157u, 
	159u, 163u, 176u, 177u, 188u, 129u, 131u, 133u, 
	138u, 143u, 144u, 147u, 168u, 170u, 176u, 178u, 
	179u, 181u, 182u, 184u, 185u, 190u, 191u, 145u, 
	158u, 128u, 130u, 135u, 136u, 139u, 141u, 153u, 
	156u, 176u, 181u, 129u, 131u, 133u, 141u, 143u, 
	145u, 147u, 168u, 170u, 176u, 178u, 179u, 181u, 
	185u, 188u, 191u, 144u, 128u, 133u, 135u, 137u, 
	139u, 141u, 160u, 163u, 129u, 131u, 133u, 140u, 
	143u, 144u, 147u, 168u, 170u, 176u, 178u, 179u, 
	181u, 185u, 188u, 191u, 177u, 128u, 132u, 135u, 
	136u, 139u, 141u, 150u, 151u, 156u, 157u, 159u, 
	163u, 156u, 130u, 131u, 133u, 138u, 142u, 144u, 
	146u, 149u, 153u, 154u, 158u, 159u, 163u, 164u, 
	168u, 170u, 174u, 185u, 190u, 191u, 144u, 151u, 
	128u, 130u, 134u, 136u, 138u, 141u, 128u, 131u, 
	133u, 140u, 142u, 144u, 146u, 168u, 170u, 185u, 
	189u, 191u, 128u, 132u, 134u, 136u, 138u, 141u, 
	149u, 150u, 152u, 153u, 160u, 163u, 129u, 131u, 
	133u, 140u, 142u, 144u, 146u, 168u, 170u, 179u, 
	181u, 185u, 188u, 191u, 158u, 128u, 132u, 134u, 
	136u, 138u, 141u, 149u, 150u, 160u, 163u, 177u, 
	178u, 129u, 131u, 133u, 140u, 142u, 144u, 146u, 
	186u, 189u, 191u, 151u, 128u, 132u, 134u, 136u, 
	138u, 142u, 160u, 163u, 186u, 191u, 189u, 130u, 
	131u, 133u, 150u, 154u, 177u, 179u, 187u, 138u, 
	150u, 128u, 134u, 143u, 148u, 152u, 159u, 178u, 
	179u, 129u, 186u, 128u, 142u, 132u, 138u, 141u, 
	165u, 167u, 129u, 130u, 135u, 136u, 148u, 151u, 
	153u, 159u, 161u, 163u, 170u, 171u, 173u, 185u, 
	187u, 189u, 134u, 128u, 132u, 136u, 141u, 156u, 
	159u, 128u, 181u, 183u, 185u, 152u, 153u, 190u, 
	191u, 128u, 135u, 137u, 172u, 177u, 191u, 128u, 
	132u, 134u, 151u, 153u, 188u, 134u, 129u, 130u, 
	131u, 137u, 138u, 139u, 140u, 141u, 142u, 143u, 
	144u, 153u, 154u, 155u, 156u, 157u, 159u, 160u, 
	161u, 162u, 163u, 164u, 165u, 166u, 167u, 168u, 
	169u, 170u, 172u, 173u, 174u, 175u, 176u, 177u, 
	179u, 183u, 188u, 189u, 190u, 191u, 128u, 158u, 
	180u, 187u, 128u, 143u, 154u, 157u, 160u, 191u, 
	135u, 141u, 128u, 133u, 144u, 186u, 188u, 191u, 
	152u, 128u, 136u, 138u, 141u, 144u, 150u, 154u, 
	157u, 160u, 191u, 128u, 136u, 138u, 141u, 144u, 
	176u, 178u, 181u, 184u, 190u, 128u, 130u, 133u, 
	136u, 150u, 152u, 191u, 128u, 144u, 146u, 149u, 
	152u, 191u, 128u, 154u, 157u, 159u, 128u, 143u, 
	160u, 191u, 128u, 180u, 129u, 191u, 128u, 172u, 
	175u, 191u, 129u, 154u, 160u, 191u, 128u, 170u, 
	177u, 184u, 128u, 140u, 142u, 148u, 160u, 180u, 
	128u, 147u, 160u, 172u, 174u, 176u, 178u, 179u, 
	151u, 128u, 147u, 156u, 157u, 139u, 141u, 160u, 
	191u, 128u, 183u, 128u, 170u, 176u, 191u, 128u, 
	181u, 128u, 158u, 160u, 171u, 176u, 187u, 144u, 
	173u, 176u, 180u, 128u, 171u, 176u, 191u, 128u, 
	137u, 128u, 155u, 160u, 191u, 191u, 128u, 158u, 
	160u, 188u, 167u, 176u, 190u, 128u, 139u, 171u, 
	179u, 128u, 175u, 186u, 191u, 128u, 179u, 141u, 
	143u, 154u, 189u, 144u, 146u, 148u, 182u, 184u, 
	185u, 128u, 181u, 188u, 191u, 128u, 149u, 152u, 
	157u, 160u, 191u, 153u, 155u, 157u, 128u, 133u, 
	136u, 141u, 144u, 151u, 159u, 189u, 190u, 128u, 
	180u, 182u, 188u, 130u, 132u, 134u, 140u, 144u, 
	147u, 150u, 155u, 160u, 172u, 178u, 180u, 182u, 
	188u, 129u, 130u, 131u, 132u, 133u, 134u, 176u, 
	177u, 178u, 179u, 180u, 181u, 182u, 183u, 184u, 
	177u, 191u, 144u, 156u, 144u, 176u, 130u, 135u, 
	149u, 164u, 166u, 168u, 138u, 147u, 153u, 157u, 
	170u, 173u, 175u, 185u, 188u, 191u, 142u, 133u, 
	137u, 131u, 132u, 128u, 174u, 176u, 191u, 128u, 
	158u, 160u, 191u, 128u, 164u, 171u, 179u, 167u, 
	173u, 128u, 165u, 176u, 191u, 175u, 191u, 128u, 
	167u, 128u, 150u, 160u, 166u, 168u, 174u, 176u, 
	182u, 184u, 190u, 128u, 134u, 136u, 142u, 144u, 
	150u, 152u, 158u, 160u, 191u, 175u, 128u, 129u, 
	130u, 131u, 132u, 133u, 134u, 135u, 144u, 191u, 
	133u, 134u, 170u, 175u, 177u, 181u, 187u, 188u, 
	128u, 150u, 153u, 154u, 157u, 159u, 161u, 191u, 
	128u, 186u, 188u, 191u, 133u, 173u, 177u, 191u, 
	128u, 142u, 160u, 186u, 176u, 191u, 182u, 128u, 
	181u, 184u, 191u, 128u, 191u, 191u, 128u, 190u, 
	128u, 140u, 146u, 147u, 152u, 153u, 154u, 155u, 
	156u, 158u, 159u, 160u, 161u, 163u, 164u, 165u, 
	167u, 168u, 169u, 171u, 172u, 173u, 175u, 128u, 
	170u, 176u, 191u, 144u, 189u, 128u, 140u, 144u, 
	159u, 170u, 171u, 191u, 128u, 178u, 180u, 189u, 
	128u, 157u, 159u, 191u, 128u, 165u, 176u, 177u, 
	151u, 159u, 162u, 191u, 128u, 136u, 139u, 142u, 
	144u, 173u, 176u, 177u, 183u, 191u, 128u, 167u, 
	187u, 128u, 132u, 160u, 183u, 138u, 173u, 176u, 
	191u, 128u, 147u, 160u, 188u, 128u, 143u, 160u, 
	175u, 186u, 190u, 128u, 182u, 128u, 141u, 160u, 
	182u, 186u, 191u, 128u, 130u, 155u, 157u, 160u, 
	175u, 178u, 182u, 129u, 134u, 137u, 142u, 145u, 
	150u, 160u, 166u, 168u, 174u, 176u, 191u, 128u, 
	154u, 156u, 159u, 164u, 165u, 128u, 170u, 172u, 
	173u, 158u, 159u, 128u, 157u, 128u, 163u, 176u, 
	191u, 128u, 134u, 139u, 187u, 169u, 171u, 172u, 
	173u, 174u, 175u, 180u, 181u, 182u, 183u, 184u, 
	185u, 187u, 188u, 189u, 190u, 191u, 164u, 186u, 
	128u, 173u, 176u, 191u, 128u, 153u, 190u, 128u, 
	134u, 147u, 151u, 157u, 168u, 170u, 182u, 184u, 
	188u, 128u, 129u, 131u, 132u, 134u, 191u, 147u, 
	191u, 128u, 189u, 128u, 143u, 146u, 191u, 128u, 
	135u, 176u, 187u, 128u, 143u, 160u, 173u, 176u, 
	180u, 182u, 191u, 128u, 188u, 161u, 186u, 129u, 
	154u, 166u, 191u, 128u, 190u, 130u, 135u, 138u, 
	143u, 146u, 151u, 154u, 156u, 144u, 145u, 146u, 
	147u, 150u, 155u, 157u, 158u, 170u, 171u, 175u, 
	160u, 169u, 128u, 129u, 130u, 131u, 135u, 138u, 
	139u, 140u, 141u, 142u, 143u, 146u, 148u, 149u, 
	156u, 157u, 160u, 161u, 162u, 164u, 166u, 168u, 
	169u, 170u, 171u, 172u, 173u, 174u, 176u, 177u, 
	144u, 145u, 152u, 155u, 191u, 128u, 139u, 141u, 
	166u, 168u, 186u, 188u, 189u, 128u, 141u, 144u, 
	157u, 128u, 186u, 189u, 128u, 156u, 160u, 191u, 
	160u, 128u, 144u, 128u, 159u, 176u, 191u, 128u, 
	130u, 137u, 144u, 186u, 128u, 157u, 160u, 191u, 
	128u, 131u, 136u, 143u, 128u, 157u, 128u, 167u, 
	176u, 191u, 128u, 163u, 128u, 149u, 160u, 167u, 
	136u, 188u, 191u, 128u, 133u, 138u, 181u, 183u, 
	184u, 128u, 149u, 160u, 182u, 128u, 158u, 128u, 
	149u, 160u, 185u, 128u, 183u, 190u, 191u, 191u, 
	128u, 131u, 133u, 134u, 140u, 147u, 149u, 151u, 
	153u, 179u, 184u, 186u, 160u, 188u, 128u, 156u, 
	128u, 135u, 137u, 166u, 128u, 149u, 160u, 178u, 
	128u, 145u, 128u, 136u, 129u, 130u, 131u, 132u, 
	133u, 135u, 136u, 138u, 139u, 140u, 141u, 146u, 
	147u, 150u, 151u, 152u, 153u, 154u, 162u, 163u, 
	171u, 128u, 134u, 191u, 128u, 134u, 144u, 168u, 
	182u, 144u, 179u, 154u, 128u, 132u, 128u, 145u, 
	147u, 183u, 128u, 170u, 151u, 128u, 132u, 135u, 
	136u, 139u, 141u, 157u, 163u, 166u, 172u, 176u, 
	180u, 135u, 128u, 133u, 128u, 181u, 184u, 191u, 
	128u, 128u, 132u, 160u, 191u, 191u, 128u, 159u, 
	128u, 184u, 142u, 128u, 141u, 128u, 152u, 144u, 
	128u, 143u, 128u, 174u, 168u, 169u, 171u, 172u, 
	173u, 174u, 188u, 189u, 190u, 160u, 167u, 128u, 
	131u, 163u, 183u, 189u, 191u, 128u, 143u, 128u, 
	132u, 144u, 190u, 143u, 159u, 128u, 176u, 177u, 
	178u, 128u, 129u, 128u, 170u, 176u, 188u, 128u, 
	136u, 144u, 153u, 157u, 158u, 133u, 134u, 137u, 
	145u, 146u, 147u, 148u, 149u, 154u, 155u, 156u, 
	157u, 158u, 159u, 144u, 153u, 165u, 169u, 173u, 
	178u, 187u, 191u, 128u, 130u, 133u, 139u, 170u, 
	173u, 130u, 132u, 128u, 148u, 150u, 191u, 162u, 
	187u, 128u, 156u, 158u, 159u, 165u, 166u, 169u, 
	172u, 174u, 185u, 189u, 191u, 128u, 131u, 133u, 
	191u, 128u, 133u, 135u, 138u, 141u, 148u, 150u, 
	156u, 158u, 185u, 187u, 190u, 134u, 128u, 132u, 
	138u, 144u, 146u, 191u, 128u, 165u, 168u, 191u, 
	128u, 130u, 154u, 156u, 186u, 188u, 191u, 128u, 
	148u, 150u, 180u, 182u, 191u, 128u, 142u, 144u, 
	174u, 176u, 191u, 128u, 136u, 138u, 168u, 170u, 
	191u, 128u, 130u, 132u, 139u, 163u, 184u, 185u, 
	186u, 160u, 162u, 128u, 132u, 144u, 150u, 164u, 
	167u, 185u, 187u, 128u, 131u, 133u, 159u, 161u, 
	162u, 169u, 178u, 180u, 183u, 130u, 135u, 137u, 
	139u, 148u, 151u, 153u, 155u, 157u, 159u, 164u, 
	190u, 141u, 143u, 145u, 146u, 161u, 162u, 167u, 
	170u, 172u, 178u, 180u, 183u, 185u, 188u, 128u, 
	137u, 139u, 155u, 161u, 163u, 165u, 169u, 171u, 
	187u, 155u, 128u, 191u, 128u, 150u, 156u, 160u, 
	128u, 159u, 168u, 160u, 167u, 160u, 135u, 132u, 
	134u, 128u, 175u, 33u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 43u, 45u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 9u, 10u, 13u, 32u, 33u, 38u, 44u, 
	46u, 47u, 48u, 49u, 50u, 63u, 95u, 194u, 
	195u, 203u, 204u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 301u, 557u, 811u, 1067u, 
	0u, 35u, 36u, 42u, 51u, 57u, 58u, 64u, 
	65u, 90u, 91u, 96u, 97u, 122u, 123u, 127u, 
	128u, 193u, 196u, 218u, 229u, 236u, 238u, 255u, 
	9u, 10u, 13u, 32u, 194u, 225u, 226u, 227u, 
	9u, 13u, 32u, 194u, 225u, 226u, 227u, 9u, 
	32u, 194u, 225u, 226u, 227u, 9u, 10u, 32u, 
	194u, 225u, 226u, 227u, 9u, 10u, 13u, 32u, 
	194u, 225u, 226u, 227u, 13u, 9u, 10u, 13u, 
	32u, 194u, 225u, 226u, 227u, 10u, 9u, 10u, 
	13u, 32u, 194u, 225u, 226u, 227u, 13u, 32u, 
	33u, 34u, 40u, 58u, 59u, 64u, 93u, 95u, 
	125u, 194u, 224u, 225u, 226u, 227u, 239u, 9u, 
	10u, 36u, 37u, 39u, 41u, 42u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 47u, 
	58u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	39u, 41u, 61u, 95u, 36u, 47u, 48u, 57u, 
	58u, 59u, 63u, 64u, 65u, 90u, 97u, 122u, 
	47u, 48u, 57u, 45u, 46u, 47u, 58u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 47u, 
	58u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 47u, 58u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 47u, 58u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 47u, 53u, 58u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	45u, 46u, 47u, 58u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 47u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 48u, 57u, 
	33u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	69u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 48u, 57u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	44u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 46u, 69u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 48u, 57u, 
	33u, 45u, 46u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 53u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 13u, 32u, 34u, 
	39u, 41u, 59u, 93u, 125u, 194u, 224u, 225u, 
	226u, 227u, 239u, 9u, 10u, 33u, 45u, 46u, 
	58u, 64u, 95u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 45u, 
	46u, 58u, 64u, 95u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	45u, 46u, 58u, 64u, 95u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 45u, 46u, 47u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 53u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 128u, 
	191u, 160u, 170u, 181u, 186u, 128u, 191u, 9u, 
	10u, 13u, 32u, 194u, 225u, 226u, 227u, 128u, 
	191u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 128u, 191u, 196u, 218u, 229u, 236u, 
	151u, 183u, 128u, 191u, 128u, 191u, 172u, 174u, 
	128u, 129u, 130u, 133u, 134u, 145u, 146u, 159u, 
	160u, 164u, 165u, 191u, 181u, 190u, 128u, 175u, 
	176u, 183u, 184u, 185u, 186u, 191u, 134u, 139u, 
	141u, 162u, 128u, 135u, 136u, 191u, 182u, 128u, 
	191u, 128u, 129u, 130u, 137u, 138u, 191u, 176u, 
	128u, 191u, 153u, 128u, 150u, 151u, 160u, 161u, 
	191u, 128u, 135u, 136u, 191u, 128u, 143u, 144u, 
	170u, 171u, 175u, 176u, 178u, 179u, 191u, 128u, 
	159u, 160u, 191u, 176u, 128u, 138u, 139u, 159u, 
	160u, 169u, 170u, 173u, 174u, 191u, 46u, 69u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 128u, 191u, 148u, 191u, 128u, 
	149u, 150u, 164u, 165u, 166u, 167u, 173u, 174u, 
	175u, 176u, 185u, 186u, 188u, 189u, 190u, 144u, 
	128u, 145u, 146u, 175u, 176u, 191u, 128u, 140u, 
	141u, 191u, 177u, 128u, 165u, 166u, 191u, 186u, 
	128u, 137u, 138u, 170u, 171u, 179u, 180u, 181u, 
	182u, 191u, 160u, 161u, 162u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 171u, 172u, 173u, 174u, 
	175u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 185u, 186u, 187u, 188u, 189u, 190u, 
	128u, 191u, 154u, 164u, 168u, 128u, 149u, 150u, 
	191u, 128u, 152u, 153u, 191u, 128u, 159u, 160u, 
	178u, 179u, 191u, 189u, 128u, 131u, 132u, 185u, 
	186u, 191u, 144u, 176u, 128u, 151u, 152u, 161u, 
	162u, 165u, 166u, 175u, 177u, 191u, 128u, 169u, 
	177u, 189u, 129u, 132u, 133u, 140u, 141u, 142u, 
	143u, 144u, 145u, 146u, 147u, 178u, 179u, 181u, 
	182u, 185u, 186u, 191u, 142u, 158u, 128u, 155u, 
	156u, 161u, 162u, 165u, 166u, 175u, 176u, 177u, 
	178u, 191u, 169u, 177u, 180u, 183u, 128u, 132u, 
	133u, 138u, 139u, 142u, 143u, 144u, 145u, 146u, 
	147u, 185u, 186u, 191u, 157u, 128u, 152u, 153u, 
	158u, 159u, 165u, 166u, 175u, 176u, 177u, 178u, 
	180u, 181u, 191u, 142u, 146u, 169u, 177u, 180u, 
	189u, 128u, 132u, 133u, 185u, 186u, 191u, 144u, 
	128u, 159u, 160u, 161u, 162u, 165u, 166u, 175u, 
	176u, 191u, 169u, 177u, 180u, 189u, 128u, 132u, 
	133u, 140u, 141u, 142u, 143u, 144u, 145u, 146u, 
	147u, 185u, 186u, 191u, 158u, 177u, 128u, 155u, 
	156u, 161u, 162u, 165u, 166u, 175u, 176u, 191u, 
	131u, 145u, 155u, 157u, 128u, 132u, 133u, 138u, 
	139u, 141u, 142u, 149u, 150u, 152u, 153u, 159u, 
	160u, 162u, 163u, 164u, 165u, 167u, 168u, 170u, 
	171u, 173u, 174u, 185u, 186u, 191u, 144u, 128u, 
	165u, 166u, 175u, 176u, 191u, 141u, 145u, 169u, 
	189u, 128u, 132u, 133u, 185u, 186u, 191u, 128u, 
	151u, 152u, 153u, 154u, 159u, 160u, 161u, 162u, 
	165u, 166u, 175u, 176u, 191u, 141u, 145u, 169u, 
	180u, 189u, 128u, 132u, 133u, 185u, 186u, 191u, 
	158u, 176u, 128u, 159u, 160u, 161u, 162u, 165u, 
	166u, 175u, 177u, 178u, 179u, 191u, 141u, 145u, 
	189u, 128u, 132u, 133u, 186u, 187u, 191u, 142u, 
	128u, 159u, 160u, 161u, 162u, 165u, 166u, 175u, 
	176u, 185u, 186u, 191u, 178u, 188u, 128u, 132u, 
	133u, 150u, 151u, 153u, 154u, 189u, 190u, 191u, 
	128u, 134u, 135u, 165u, 166u, 175u, 176u, 191u, 
	128u, 177u, 129u, 179u, 180u, 191u, 128u, 134u, 
	135u, 143u, 144u, 153u, 154u, 191u, 128u, 131u, 
	137u, 141u, 152u, 160u, 164u, 166u, 172u, 177u, 
	189u, 129u, 132u, 133u, 134u, 135u, 138u, 139u, 
	147u, 148u, 167u, 168u, 169u, 170u, 179u, 180u, 
	191u, 133u, 128u, 134u, 135u, 143u, 144u, 153u, 
	154u, 155u, 156u, 159u, 160u, 191u, 128u, 129u, 
	159u, 160u, 169u, 170u, 191u, 136u, 128u, 172u, 
	173u, 191u, 128u, 135u, 136u, 140u, 141u, 191u, 
	128u, 129u, 130u, 131u, 137u, 138u, 139u, 140u, 
	141u, 142u, 143u, 144u, 153u, 154u, 155u, 156u, 
	157u, 158u, 159u, 160u, 161u, 162u, 163u, 164u, 
	165u, 166u, 167u, 168u, 169u, 170u, 171u, 172u, 
	173u, 174u, 175u, 176u, 177u, 178u, 179u, 183u, 
	188u, 189u, 190u, 191u, 132u, 187u, 191u, 128u, 
	170u, 171u, 190u, 161u, 128u, 137u, 138u, 143u, 
	144u, 149u, 150u, 153u, 154u, 157u, 158u, 164u, 
	165u, 166u, 167u, 173u, 174u, 176u, 177u, 180u, 
	181u, 191u, 142u, 128u, 129u, 130u, 143u, 144u, 
	153u, 154u, 159u, 160u, 191u, 134u, 141u, 187u, 
	128u, 135u, 136u, 143u, 144u, 191u, 137u, 151u, 
	153u, 128u, 141u, 142u, 143u, 144u, 157u, 158u, 
	159u, 160u, 191u, 137u, 177u, 191u, 128u, 141u, 
	142u, 143u, 144u, 181u, 182u, 183u, 184u, 190u, 
	129u, 151u, 128u, 133u, 134u, 135u, 136u, 191u, 
	145u, 128u, 149u, 150u, 151u, 152u, 191u, 128u, 
	154u, 155u, 191u, 128u, 143u, 144u, 159u, 160u, 
	191u, 128u, 180u, 181u, 191u, 128u, 129u, 191u, 
	128u, 172u, 173u, 174u, 175u, 191u, 128u, 129u, 
	154u, 155u, 159u, 160u, 191u, 128u, 170u, 171u, 
	176u, 177u, 184u, 185u, 191u, 141u, 128u, 145u, 
	146u, 159u, 160u, 177u, 178u, 191u, 173u, 128u, 
	145u, 146u, 159u, 160u, 176u, 177u, 191u, 128u, 
	179u, 180u, 191u, 151u, 156u, 128u, 159u, 160u, 
	169u, 170u, 191u, 128u, 143u, 144u, 153u, 154u, 
	159u, 160u, 191u, 128u, 183u, 184u, 191u, 169u, 
	128u, 170u, 171u, 175u, 176u, 191u, 128u, 181u, 
	182u, 191u, 128u, 158u, 159u, 191u, 128u, 133u, 
	134u, 143u, 144u, 173u, 174u, 175u, 176u, 180u, 
	181u, 191u, 128u, 171u, 172u, 191u, 128u, 129u, 
	135u, 136u, 143u, 144u, 153u, 154u, 191u, 128u, 
	150u, 151u, 159u, 160u, 191u, 128u, 148u, 149u, 
	191u, 167u, 128u, 137u, 138u, 143u, 144u, 153u, 
	154u, 191u, 128u, 132u, 133u, 179u, 180u, 191u, 
	128u, 132u, 133u, 139u, 140u, 143u, 144u, 153u, 
	154u, 191u, 128u, 130u, 131u, 160u, 161u, 173u, 
	174u, 175u, 176u, 185u, 186u, 191u, 128u, 165u, 
	166u, 191u, 128u, 163u, 164u, 191u, 128u, 137u, 
	138u, 140u, 141u, 143u, 144u, 153u, 154u, 189u, 
	190u, 191u, 173u, 128u, 168u, 169u, 177u, 178u, 
	180u, 181u, 182u, 183u, 191u, 128u, 149u, 150u, 
	151u, 152u, 157u, 158u, 159u, 160u, 191u, 152u, 
	154u, 156u, 158u, 128u, 133u, 134u, 135u, 136u, 
	141u, 142u, 143u, 144u, 189u, 190u, 191u, 181u, 
	189u, 191u, 128u, 190u, 133u, 181u, 128u, 129u, 
	130u, 140u, 141u, 143u, 144u, 147u, 148u, 149u, 
	150u, 155u, 156u, 159u, 160u, 172u, 173u, 177u, 
	178u, 188u, 189u, 191u, 128u, 129u, 130u, 132u, 
	133u, 134u, 176u, 177u, 178u, 179u, 180u, 181u, 
	182u, 183u, 184u, 131u, 191u, 166u, 175u, 128u, 
	138u, 139u, 191u, 13u, 32u, 34u, 39u, 41u, 
	59u, 93u, 125u, 194u, 224u, 225u, 226u, 227u, 
	239u, 9u, 10u, 128u, 191u, 159u, 177u, 191u, 
	128u, 190u, 128u, 143u, 144u, 156u, 157u, 191u, 
	130u, 135u, 148u, 164u, 166u, 168u, 174u, 128u, 
	137u, 138u, 149u, 150u, 152u, 153u, 157u, 158u, 
	169u, 170u, 185u, 186u, 187u, 188u, 191u, 142u, 
	128u, 132u, 133u, 137u, 138u, 191u, 128u, 130u, 
	131u, 132u, 133u, 191u, 175u, 128u, 191u, 159u, 
	128u, 191u, 128u, 164u, 165u, 170u, 171u, 174u, 
	175u, 177u, 178u, 179u, 180u, 191u, 166u, 173u, 
	128u, 167u, 168u, 175u, 176u, 191u, 175u, 128u, 
	167u, 168u, 191u, 167u, 175u, 183u, 191u, 128u, 
	150u, 151u, 159u, 160u, 190u, 135u, 143u, 151u, 
	128u, 158u, 159u, 191u, 175u, 128u, 191u, 128u, 
	129u, 130u, 131u, 132u, 133u, 134u, 135u, 136u, 
	143u, 144u, 191u, 128u, 129u, 132u, 133u, 134u, 
	135u, 176u, 177u, 181u, 182u, 186u, 187u, 188u, 
	189u, 191u, 160u, 128u, 150u, 151u, 156u, 157u, 
	191u, 187u, 128u, 191u, 128u, 132u, 133u, 173u, 
	174u, 176u, 177u, 191u, 128u, 142u, 143u, 159u, 
	160u, 186u, 187u, 191u, 128u, 175u, 176u, 191u, 
	182u, 183u, 128u, 191u, 128u, 191u, 191u, 128u, 
	190u, 128u, 140u, 141u, 191u, 146u, 147u, 152u, 
	153u, 154u, 155u, 156u, 158u, 159u, 160u, 161u, 
	162u, 163u, 164u, 165u, 166u, 167u, 168u, 169u, 
	170u, 171u, 172u, 173u, 174u, 175u, 128u, 191u, 
	128u, 143u, 144u, 189u, 190u, 191u, 128u, 140u, 
	141u, 143u, 144u, 159u, 160u, 169u, 170u, 171u, 
	172u, 191u, 191u, 128u, 174u, 175u, 190u, 128u, 
	157u, 158u, 159u, 160u, 191u, 128u, 150u, 151u, 
	159u, 160u, 161u, 162u, 191u, 143u, 128u, 136u, 
	137u, 138u, 139u, 173u, 174u, 175u, 176u, 177u, 
	178u, 191u, 128u, 182u, 183u, 191u, 130u, 134u, 
	139u, 128u, 162u, 163u, 191u, 128u, 129u, 130u, 
	179u, 180u, 191u, 187u, 128u, 143u, 144u, 153u, 
	154u, 177u, 178u, 183u, 184u, 191u, 128u, 137u, 
	138u, 165u, 166u, 175u, 176u, 191u, 128u, 134u, 
	135u, 159u, 160u, 188u, 189u, 191u, 128u, 131u, 
	132u, 178u, 179u, 191u, 143u, 165u, 191u, 128u, 
	142u, 144u, 153u, 154u, 159u, 160u, 175u, 176u, 
	185u, 186u, 190u, 128u, 168u, 169u, 191u, 131u, 
	186u, 128u, 139u, 140u, 143u, 144u, 153u, 154u, 
	159u, 160u, 182u, 183u, 189u, 190u, 191u, 176u, 
	128u, 177u, 178u, 180u, 181u, 182u, 183u, 184u, 
	185u, 189u, 190u, 191u, 129u, 128u, 130u, 131u, 
	154u, 155u, 157u, 158u, 159u, 160u, 170u, 171u, 
	177u, 178u, 180u, 181u, 191u, 128u, 167u, 175u, 
	129u, 134u, 135u, 136u, 137u, 142u, 143u, 144u, 
	145u, 150u, 151u, 159u, 160u, 191u, 155u, 128u, 
	159u, 160u, 163u, 164u, 165u, 166u, 191u, 128u, 
	162u, 163u, 175u, 176u, 185u, 186u, 191u, 158u, 
	159u, 128u, 157u, 160u, 191u, 128u, 163u, 164u, 
	175u, 176u, 191u, 128u, 134u, 135u, 138u, 139u, 
	187u, 188u, 191u, 169u, 171u, 172u, 173u, 174u, 
	175u, 180u, 181u, 182u, 183u, 184u, 185u, 187u, 
	188u, 189u, 190u, 191u, 128u, 163u, 164u, 186u, 
	128u, 173u, 174u, 175u, 176u, 191u, 128u, 153u, 
	154u, 191u, 157u, 169u, 183u, 189u, 191u, 128u, 
	134u, 135u, 146u, 147u, 151u, 152u, 158u, 159u, 
	190u, 130u, 133u, 128u, 191u, 128u, 177u, 178u, 
	191u, 128u, 146u, 147u, 191u, 128u, 189u, 190u, 
	191u, 128u, 143u, 144u, 191u, 128u, 143u, 144u, 
	145u, 146u, 191u, 128u, 135u, 136u, 175u, 176u, 
	187u, 188u, 191u, 181u, 128u, 175u, 176u, 191u, 
	128u, 188u, 189u, 191u, 128u, 143u, 144u, 153u, 
	154u, 160u, 161u, 186u, 187u, 191u, 128u, 129u, 
	154u, 155u, 165u, 166u, 191u, 191u, 128u, 190u, 
	128u, 129u, 130u, 135u, 136u, 137u, 138u, 143u, 
	144u, 145u, 146u, 151u, 152u, 153u, 154u, 156u, 
	157u, 191u, 144u, 145u, 146u, 147u, 150u, 155u, 
	157u, 158u, 170u, 171u, 175u, 128u, 159u, 160u, 
	169u, 172u, 191u, 128u, 129u, 130u, 131u, 138u, 
	139u, 140u, 141u, 142u, 143u, 146u, 148u, 149u, 
	156u, 157u, 160u, 161u, 162u, 164u, 166u, 168u, 
	169u, 170u, 171u, 172u, 173u, 174u, 176u, 177u, 
	132u, 137u, 144u, 145u, 147u, 151u, 152u, 155u, 
	158u, 191u, 140u, 167u, 187u, 190u, 128u, 191u, 
	128u, 141u, 142u, 143u, 144u, 157u, 158u, 191u, 
	128u, 186u, 187u, 191u, 128u, 156u, 157u, 159u, 
	160u, 191u, 128u, 144u, 145u, 191u, 128u, 159u, 
	160u, 175u, 176u, 191u, 129u, 128u, 137u, 138u, 
	143u, 144u, 181u, 182u, 191u, 128u, 131u, 132u, 
	135u, 136u, 143u, 144u, 191u, 128u, 157u, 158u, 
	159u, 160u, 169u, 170u, 191u, 128u, 167u, 168u, 
	175u, 176u, 191u, 128u, 182u, 183u, 191u, 128u, 
	149u, 150u, 159u, 160u, 167u, 168u, 191u, 136u, 
	182u, 188u, 191u, 128u, 133u, 134u, 137u, 138u, 
	184u, 185u, 190u, 128u, 149u, 150u, 159u, 160u, 
	182u, 183u, 191u, 128u, 149u, 150u, 159u, 160u, 
	185u, 186u, 191u, 128u, 183u, 184u, 189u, 190u, 
	191u, 128u, 148u, 152u, 129u, 143u, 144u, 179u, 
	180u, 191u, 128u, 159u, 160u, 188u, 189u, 191u, 
	128u, 156u, 157u, 191u, 136u, 128u, 164u, 165u, 
	191u, 128u, 149u, 150u, 159u, 160u, 178u, 179u, 
	191u, 128u, 145u, 146u, 191u, 128u, 136u, 137u, 
	191u, 128u, 129u, 130u, 131u, 132u, 133u, 134u, 
	135u, 136u, 138u, 139u, 140u, 141u, 146u, 147u, 
	150u, 152u, 153u, 154u, 155u, 162u, 163u, 171u, 
	137u, 191u, 128u, 130u, 131u, 183u, 184u, 191u, 
	128u, 165u, 166u, 175u, 176u, 191u, 128u, 130u, 
	131u, 175u, 176u, 191u, 128u, 143u, 144u, 168u, 
	169u, 175u, 176u, 185u, 186u, 191u, 128u, 130u, 
	131u, 166u, 167u, 181u, 182u, 191u, 182u, 128u, 
	143u, 144u, 178u, 179u, 191u, 128u, 130u, 131u, 
	178u, 179u, 191u, 128u, 154u, 129u, 132u, 133u, 
	143u, 144u, 153u, 155u, 191u, 146u, 128u, 171u, 
	172u, 191u, 128u, 158u, 159u, 175u, 176u, 185u, 
	186u, 191u, 128u, 156u, 157u, 161u, 162u, 191u, 
	128u, 175u, 176u, 191u, 134u, 128u, 131u, 132u, 
	135u, 136u, 143u, 144u, 153u, 154u, 191u, 128u, 
	174u, 175u, 191u, 132u, 128u, 143u, 144u, 153u, 
	154u, 191u, 128u, 170u, 171u, 191u, 128u, 137u, 
	138u, 191u, 191u, 128u, 159u, 160u, 169u, 170u, 
	190u, 128u, 184u, 185u, 191u, 142u, 128u, 141u, 
	143u, 191u, 144u, 128u, 143u, 145u, 191u, 168u, 
	169u, 171u, 172u, 173u, 174u, 188u, 189u, 190u, 
	128u, 159u, 160u, 167u, 170u, 191u, 159u, 128u, 
	158u, 160u, 169u, 170u, 191u, 128u, 143u, 144u, 
	173u, 174u, 191u, 128u, 131u, 132u, 143u, 144u, 
	153u, 154u, 162u, 163u, 183u, 184u, 188u, 189u, 
	191u, 128u, 143u, 144u, 191u, 144u, 128u, 132u, 
	133u, 191u, 128u, 146u, 147u, 159u, 160u, 191u, 
	128u, 176u, 177u, 178u, 129u, 191u, 128u, 129u, 
	130u, 191u, 128u, 170u, 171u, 175u, 176u, 188u, 
	189u, 191u, 128u, 136u, 137u, 143u, 144u, 153u, 
	154u, 191u, 145u, 146u, 147u, 148u, 149u, 154u, 
	155u, 156u, 157u, 158u, 159u, 128u, 143u, 144u, 
	153u, 160u, 191u, 149u, 128u, 191u, 157u, 162u, 
	173u, 186u, 188u, 128u, 159u, 160u, 164u, 165u, 
	166u, 167u, 168u, 169u, 191u, 132u, 128u, 191u, 
	134u, 149u, 157u, 186u, 191u, 128u, 138u, 139u, 
	140u, 141u, 190u, 133u, 145u, 128u, 134u, 135u, 
	137u, 138u, 191u, 128u, 165u, 166u, 167u, 168u, 
	191u, 129u, 155u, 187u, 128u, 191u, 149u, 181u, 
	128u, 191u, 143u, 175u, 128u, 191u, 137u, 169u, 
	128u, 191u, 131u, 128u, 139u, 140u, 141u, 142u, 
	191u, 163u, 184u, 185u, 186u, 128u, 159u, 160u, 
	162u, 164u, 191u, 128u, 132u, 133u, 191u, 132u, 
	160u, 163u, 167u, 179u, 184u, 186u, 128u, 164u, 
	165u, 168u, 169u, 187u, 188u, 191u, 130u, 135u, 
	137u, 139u, 144u, 147u, 151u, 153u, 155u, 157u, 
	159u, 163u, 171u, 179u, 184u, 189u, 191u, 128u, 
	140u, 141u, 148u, 149u, 160u, 161u, 164u, 165u, 
	166u, 167u, 190u, 138u, 164u, 170u, 128u, 155u, 
	156u, 160u, 161u, 187u, 188u, 191u, 155u, 128u, 
	191u, 128u, 150u, 151u, 191u, 156u, 160u, 128u, 
	159u, 161u, 191u, 128u, 157u, 158u, 191u, 168u, 
	128u, 159u, 160u, 167u, 169u, 191u, 33u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 45u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 0
};

static const char _generic_tokenizer_single_lengths[] = {
	0, 1, 1, 1, 2, 1, 1, 1, 
	31, 29, 1, 0, 32, 29, 7, 21, 
	26, 5, 4, 2, 15, 0, 16, 28, 
	30, 24, 0, 1, 2, 8, 0, 2, 
	1, 32, 28, 0, 4, 0, 0, 17, 
	2, 2, 1, 6, 1, 1, 3, 7, 
	6, 11, 3, 0, 6, 21, 10, 1, 
	1, 10, 5, 23, 14, 14, 26, 18, 
	5, 1, 7, 6, 2, 3, 3, 1, 
	0, 1, 16, 0, 0, 2, 0, 0, 
	1, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 1, 2, 8, 2, 17, 3, 
	3, 1, 11, 4, 2, 3, 3, 2, 
	1, 2, 0, 2, 5, 0, 2, 3, 
	2, 3, 2, 3, 2, 2, 3, 2, 
	2, 2, 3, 2, 2, 2, 3, 2, 
	14, 2, 1, 2, 1, 2, 9, 4, 
	3, 1, 3, 7, 6, 11, 3, 10, 
	1, 10, 5, 1, 6, 7, 2, 3, 
	17, 5, 6, 4, 6, 5, 4, 6, 
	2, 6, 6, 7, 6, 7, 15, 7, 
	6, 7, 7, 7, 7, 8, 7, 6, 
	6, 7, 6, 15, 12, 0, 0, 0, 
	13, 0, 0, 10, 0, 0, 6, 0, 
	1, 4, 1, 9, 0, 2, 1, 0, 
	13, 0, 10, 8, 0, 0, 13, 0, 
	0, 10, 0, 0, 6, 0, 1, 4, 
	1, 9, 0, 2, 1, 0, 12, 15, 
	13, 0, 8, 0, 0, 13, 0, 0, 
	10, 0, 0, 6, 0, 1, 4, 1, 
	9, 0, 2, 1, 0, 3, 1, 5, 
	6, 7, 6, 7, 6, 7, 6, 6, 
	7, 6, 6, 6, 7, 6, 6, 6, 
	7, 6, 3, 0, 0, 2, 1, 2, 
	0, 0, 0, 1, 1, 1, 0, 0, 
	1, 0, 0, 0, 1, 32, 0, 0, 
	0, 0, 0, 1, 1, 1, 2, 0, 
	1, 0, 1, 1, 2, 0, 0, 0, 
	1, 0, 1, 1, 2, 0, 0, 5, 
	1, 4, 0, 0, 1, 40, 0, 2, 
	1, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	3, 1, 0, 15, 2, 0, 0, 6, 
	1, 0, 0, 0, 0, 2, 2, 0, 
	0, 1, 8, 0, 0, 0, 0, 0, 
	0, 1, 0, 1, 0, 21, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 2, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 17, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 11, 30, 1, 0, 
	0, 1, 0, 1, 0, 1, 0, 0, 
	0, 0, 0, 0, 3, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	21, 1, 0, 1, 1, 0, 0, 1, 
	1, 0, 1, 2, 0, 1, 0, 1, 
	0, 1, 0, 9, 0, 0, 0, 0, 
	4, 0, 0, 0, 14, 0, 0, 0, 
	0, 2, 0, 0, 1, 0, 1, 0, 
	0, 0, 0, 4, 0, 4, 12, 0, 
	1, 0, 2, 1, 1, 1, 0, 12, 
	14, 47, 8, 7, 6, 7, 8, 1, 
	8, 1, 8, 17, 4, 5, 1, 4, 
	4, 4, 4, 5, 4, 4, 16, 7, 
	4, 7, 16, 16, 12, 8, 14, 10, 
	16, 16, 17, 16, 16, 14, 11, 16, 
	16, 17, 16, 14, 35, 35, 35, 7, 
	7, 7, 8, 7, 29, 0, 4, 8, 
	29, 2, 0, 2, 2, 4, 1, 0, 
	1, 1, 0, 0, 0, 1, 11, 2, 
	1, 0, 1, 1, 30, 3, 0, 0, 
	1, 2, 4, 2, 4, 1, 6, 1, 
	4, 2, 4, 1, 4, 0, 5, 2, 
	3, 1, 2, 0, 2, 0, 11, 1, 
	1, 1, 0, 44, 1, 1, 1, 3, 
	3, 3, 2, 1, 0, 0, 0, 1, 
	0, 1, 0, 1, 1, 0, 2, 0, 
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	1, 0, 4, 3, 2, 15, 2, 14, 
	3, 0, 7, 1, 0, 1, 1, 0, 
	2, 1, 4, 3, 1, 8, 1, 1, 
	1, 0, 0, 0, 2, 0, 1, 0, 
	25, 0, 0, 1, 0, 0, 1, 0, 
	3, 0, 1, 0, 0, 0, 3, 0, 
	2, 1, 1, 3, 1, 0, 2, 0, 
	0, 17, 0, 0, 5, 2, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 1, 
	1, 0, 11, 29, 4, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	4, 0, 0, 0, 3, 0, 0, 1, 
	0, 0, 0, 23, 0, 0, 0, 0, 
	0, 1, 0, 2, 1, 0, 0, 0, 
	1, 0, 1, 0, 0, 1, 0, 1, 
	1, 9, 1, 0, 0, 0, 1, 0, 
	4, 0, 0, 0, 11, 1, 5, 1, 
	5, 2, 0, 3, 2, 2, 2, 1, 
	4, 0, 7, 17, 3, 1, 0, 2, 
	0, 1, 12, 15, 14
};

static const char _generic_tokenizer_range_lengths[] = {
	0, 0, 0, 0, 0, 1, 0, 0, 
	2, 1, 0, 2, 0, 1, 12, 5, 
	2, 1, 0, 4, 3, 1, 0, 0, 
	1, 1, 1, 0, 0, 1, 1, 1, 
	0, 0, 0, 4, 2, 4, 4, 0, 
	2, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 1, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 2, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	1, 0, 0, 2, 2, 5, 1, 6, 
	3, 2, 1, 2, 2, 2, 1, 1, 
	1, 1, 0, 0, 1, 0, 0, 3, 
	0, 0, 0, 5, 5, 5, 3, 3, 
	3, 3, 3, 3, 6, 1, 3, 3, 
	3, 3, 3, 3, 3, 3, 4, 4, 
	3, 3, 4, 4, 3, 3, 4, 4, 
	1, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	7, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 6, 6, 5, 
	5, 6, 6, 5, 5, 1, 1, 1, 
	0, 1, 1, 0, 1, 2, 0, 2, 
	0, 0, 0, 0, 1, 0, 0, 1, 
	5, 1, 1, 1, 1, 1, 0, 1, 
	1, 0, 1, 2, 0, 2, 0, 0, 
	0, 0, 1, 0, 0, 1, 5, 5, 
	5, 1, 1, 1, 1, 0, 1, 1, 
	0, 1, 2, 0, 2, 0, 0, 0, 
	0, 1, 0, 0, 1, 4, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	6, 6, 5, 5, 6, 6, 5, 5, 
	6, 6, 0, 3, 1, 3, 3, 3, 
	2, 2, 2, 2, 2, 4, 2, 2, 
	5, 1, 2, 1, 1, 0, 1, 1, 
	1, 1, 2, 7, 6, 9, 5, 8, 
	4, 8, 6, 10, 3, 6, 6, 7, 
	6, 5, 5, 4, 4, 1, 1, 8, 
	3, 2, 3, 3, 0, 2, 3, 3, 
	5, 5, 3, 3, 2, 2, 1, 1, 
	2, 2, 2, 3, 4, 2, 2, 1, 
	2, 1, 3, 2, 2, 1, 2, 2, 
	1, 2, 2, 1, 2, 3, 2, 3, 
	4, 2, 7, 0, 0, 1, 1, 5, 
	1, 1, 2, 2, 2, 2, 1, 5, 
	5, 0, 1, 4, 4, 2, 2, 2, 
	1, 2, 1, 1, 1, 2, 1, 3, 
	2, 2, 2, 2, 4, 1, 1, 2, 
	2, 2, 2, 1, 3, 4, 6, 3, 
	2, 1, 2, 2, 1, 2, 1, 5, 
	3, 1, 1, 2, 2, 2, 2, 1, 
	1, 2, 1, 4, 1, 2, 4, 2, 
	1, 0, 2, 1, 2, 2, 2, 2, 
	1, 2, 1, 2, 3, 2, 1, 2, 
	2, 6, 1, 1, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 6, 
	1, 2, 0, 0, 1, 1, 1, 1, 
	1, 1, 1, 1, 3, 1, 2, 1, 
	0, 1, 2, 3, 1, 3, 3, 1, 
	2, 6, 2, 6, 3, 2, 3, 3, 
	3, 3, 2, 1, 2, 5, 7, 5, 
	1, 1, 1, 1, 0, 1, 1, 5, 
	5, 12, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 7, 3, 6, 1, 3, 
	3, 3, 3, 4, 4, 5, 5, 5, 
	5, 5, 5, 5, 5, 1, 5, 1, 
	5, 5, 6, 6, 5, 5, 1, 5, 
	5, 6, 6, 1, 7, 7, 7, 5, 
	5, 5, 6, 6, 4, 1, 1, 1, 
	5, 1, 1, 6, 4, 2, 1, 3, 
	1, 3, 2, 5, 2, 5, 2, 8, 
	3, 2, 2, 5, 1, 2, 2, 3, 
	3, 5, 9, 6, 7, 7, 3, 5, 
	7, 5, 13, 3, 3, 7, 3, 6, 
	3, 6, 5, 4, 2, 4, 8, 6, 
	3, 2, 3, 1, 2, 11, 5, 3, 
	5, 5, 3, 3, 2, 3, 2, 1, 
	3, 3, 4, 4, 4, 2, 3, 4, 
	2, 3, 2, 2, 6, 2, 4, 3, 
	2, 4, 3, 5, 6, 2, 2, 6, 
	5, 5, 6, 1, 11, 1, 2, 2, 
	1, 3, 8, 3, 3, 1, 1, 6, 
	3, 2, 3, 2, 1, 2, 7, 3, 
	1, 4, 4, 2, 1, 1, 1, 2, 
	1, 3, 6, 2, 3, 4, 6, 2, 
	2, 3, 5, 4, 4, 3, 6, 2, 
	7, 6, 8, 7, 4, 4, 2, 3, 
	4, 2, 3, 2, 5, 1, 2, 2, 
	2, 2, 3, 4, 2, 2, 5, 3, 
	1, 9, 3, 5, 1, 4, 2, 3, 
	2, 3, 4, 4, 4, 3, 2, 4, 
	4, 4, 4, 3, 3, 3, 2, 2, 
	4, 2, 2, 1, 3, 3, 3, 5, 
	4, 3, 3, 4, 2, 4, 3, 2, 
	5, 2, 3, 2, 2, 3, 2, 2, 
	2, 3, 3, 3, 7, 2, 2, 3, 
	1, 2, 4, 4, 3, 1, 5, 1, 
	3, 3, 3, 1, 1, 1, 1, 3, 
	3, 2, 4, 6, 4, 1, 2, 2, 
	2, 3, 5, 5, 5
};

static const short _generic_tokenizer_index_offsets[] = {
	0, 0, 2, 4, 6, 9, 12, 14, 
	16, 50, 81, 83, 86, 119, 150, 170, 
	197, 226, 233, 238, 245, 264, 266, 283, 
	312, 344, 370, 372, 374, 377, 387, 389, 
	393, 395, 428, 457, 462, 469, 474, 479, 
	497, 502, 505, 507, 520, 522, 524, 528, 
	536, 543, 555, 559, 561, 571, 593, 604, 
	606, 608, 619, 625, 649, 664, 679, 707, 
	728, 734, 736, 744, 751, 755, 759, 763, 
	765, 767, 769, 786, 789, 792, 800, 802, 
	809, 814, 817, 819, 822, 825, 828, 831, 
	833, 835, 837, 839, 842, 852, 855, 873, 
	880, 884, 886, 898, 908, 916, 925, 932, 
	938, 943, 949, 953, 959, 971, 973, 979, 
	986, 992, 999, 1005, 1012, 1018, 1024, 1032, 
	1039, 1045, 1051, 1059, 1066, 1072, 1078, 1086, 
	1093, 1109, 1112, 1114, 1117, 1119, 1122, 1132, 
	1138, 1142, 1144, 1148, 1156, 1163, 1175, 1179, 
	1190, 1192, 1204, 1210, 1212, 1219, 1227, 1230, 
	1234, 1259, 1270, 1282, 1292, 1304, 1315, 1325, 
	1337, 1345, 1357, 1369, 1382, 1394, 1407, 1428, 
	1441, 1453, 1466, 1479, 1492, 1505, 1520, 1534, 
	1546, 1558, 1572, 1585, 1606, 1624, 1626, 1628, 
	1630, 1644, 1646, 1648, 1659, 1661, 1664, 1671, 
	1674, 1676, 1681, 1683, 1693, 1695, 1698, 1700, 
	1702, 1721, 1723, 1735, 1745, 1747, 1749, 1763, 
	1765, 1767, 1778, 1780, 1783, 1790, 1793, 1795, 
	1800, 1802, 1812, 1814, 1817, 1819, 1821, 1839, 
	1860, 1879, 1881, 1891, 1893, 1895, 1909, 1911, 
	1913, 1924, 1926, 1929, 1936, 1939, 1941, 1946, 
	1948, 1958, 1960, 1963, 1965, 1967, 1975, 1977, 
	1988, 2000, 2013, 2025, 2038, 2050, 2063, 2075, 
	2087, 2101, 2114, 2126, 2138, 2152, 2165, 2177, 
	2189, 2203, 2216, 2220, 2224, 2226, 2232, 2237, 
	2243, 2246, 2249, 2252, 2256, 2260, 2266, 2269, 
	2272, 2279, 2281, 2284, 2286, 2289, 2322, 2324, 
	2326, 2328, 2330, 2333, 2342, 2350, 2361, 2369, 
	2378, 2384, 2393, 2401, 2413, 2419, 2426, 2433, 
	2441, 2449, 2455, 2462, 2468, 2475, 2477, 2479, 
	2493, 2498, 2505, 2509, 2513, 2515, 2558, 2562, 
	2568, 2575, 2581, 2586, 2590, 2593, 2596, 2598, 
	2600, 2603, 2606, 2609, 2613, 2618, 2622, 2625, 
	2627, 2630, 2632, 2636, 2639, 2642, 2644, 2647, 
	2651, 2654, 2657, 2660, 2662, 2665, 2669, 2672, 
	2676, 2684, 2688, 2696, 2712, 2715, 2717, 2719, 
	2731, 2734, 2736, 2739, 2742, 2745, 2750, 2754, 
	2760, 2766, 2768, 2778, 2783, 2788, 2791, 2794, 
	2797, 2799, 2803, 2805, 2808, 2810, 2834, 2836, 
	2840, 2844, 2847, 2850, 2853, 2858, 2860, 2862, 
	2866, 2869, 2872, 2877, 2879, 2883, 2888, 2895, 
	2899, 2902, 2906, 2909, 2912, 2931, 2934, 2936, 
	2943, 2947, 2949, 2951, 2954, 2957, 2960, 2963, 
	2965, 2967, 2970, 2972, 2977, 2990, 3023, 3029, 
	3032, 3034, 3036, 3039, 3042, 3045, 3049, 3052, 
	3055, 3057, 3060, 3062, 3065, 3072, 3075, 3077, 
	3080, 3083, 3091, 3093, 3095, 3098, 3101, 3103, 
	3105, 3128, 3131, 3133, 3136, 3139, 3142, 3144, 
	3152, 3155, 3158, 3160, 3163, 3165, 3168, 3170, 
	3173, 3175, 3178, 3180, 3191, 3195, 3197, 3200, 
	3202, 3207, 3209, 3212, 3216, 3232, 3236, 3240, 
	3242, 3245, 3254, 3257, 3264, 3269, 3272, 3277, 
	3281, 3285, 3289, 3292, 3298, 3301, 3311, 3331, 
	3337, 3340, 3342, 3346, 3349, 3351, 3354, 3356, 
	3374, 3394, 3454, 3463, 3471, 3478, 3486, 3495, 
	3497, 3506, 3508, 3517, 3542, 3550, 3562, 3565, 
	3573, 3581, 3589, 3597, 3607, 3616, 3626, 3648, 
	3661, 3671, 3684, 3706, 3728, 3746, 3756, 3776, 
	3788, 3810, 3832, 3856, 3879, 3901, 3921, 3934, 
	3956, 3978, 4002, 4025, 4041, 4084, 4127, 4170, 
	4183, 4196, 4209, 4224, 4238, 4272, 4274, 4280, 
	4290, 4325, 4329, 4331, 4340, 4347, 4354, 4357, 
	4361, 4364, 4369, 4372, 4378, 4381, 4388, 4402, 
	4413, 4418, 4421, 4425, 4432, 4464, 4470, 4473, 
	4477, 4482, 4490, 4504, 4513, 4525, 4534, 4544, 
	4551, 4563, 4571, 4589, 4594, 4602, 4610, 4619, 
	4628, 4635, 4643, 4651, 4656, 4661, 4666, 4686, 
	4694, 4699, 4703, 4707, 4753, 4757, 4770, 4777, 
	4784, 4793, 4802, 4808, 4813, 4816, 4820, 4823, 
	4826, 4830, 4835, 4840, 4846, 4852, 4855, 4861, 
	4866, 4869, 4874, 4877, 4880, 4887, 4890, 4896, 
	4900, 4903, 4909, 4913, 4919, 4926, 4929, 4932, 
	4939, 4946, 4952, 4963, 4968, 4982, 4999, 5004, 
	5021, 5026, 5030, 5046, 5051, 5055, 5058, 5061, 
	5068, 5074, 5078, 5086, 5092, 5095, 5106, 5115, 
	5120, 5123, 5128, 5133, 5136, 5140, 5142, 5145, 
	5148, 5175, 5179, 5186, 5190, 5194, 5199, 5207, 
	5210, 5216, 5220, 5227, 5232, 5237, 5241, 5251, 
	5254, 5264, 5272, 5282, 5293, 5299, 5304, 5309, 
	5313, 5318, 5338, 5342, 5345, 5356, 5360, 5363, 
	5366, 5369, 5372, 5376, 5381, 5385, 5388, 5394, 
	5399, 5402, 5412, 5427, 5462, 5468, 5473, 5476, 
	5480, 5483, 5487, 5493, 5498, 5503, 5507, 5510, 
	5515, 5524, 5529, 5534, 5538, 5545, 5549, 5552, 
	5556, 5561, 5564, 5567, 5592, 5596, 5600, 5604, 
	5610, 5615, 5620, 5624, 5631, 5635, 5640, 5644, 
	5647, 5654, 5657, 5662, 5665, 5668, 5673, 5676, 
	5680, 5684, 5697, 5702, 5706, 5714, 5717, 5721, 
	5725, 5731, 5734, 5739, 5744, 5759, 5762, 5773, 
	5776, 5785, 5791, 5795, 5800, 5804, 5808, 5812, 
	5817, 5825, 5828, 5840, 5864, 5872, 5875, 5878, 
	5883, 5886, 5891, 5909, 5930
};

static const short _generic_tokenizer_indicies[] = {
	1, 0, 2, 0, 1, 0, 3, 4, 
	0, 1, 1, 0, 1, 0, 2, 0, 
	6, 6, 7, 7, 7, 7, 7, 9, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 6, 
	8, 5, 7, 7, 7, 7, 7, 33, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 34, 35, 36, 30, 31, 32, 8, 
	5, 7, 5, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 5, 37, 5, 7, 7, 
	5, 38, 39, 40, 42, 43, 44, 45, 
	46, 41, 5, 8, 5, 8, 8, 8, 
	5, 7, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 5, 47, 
	48, 49, 50, 51, 52, 53, 54, 55, 
	56, 57, 58, 59, 41, 60, 61, 62, 
	5, 7, 7, 7, 7, 5, 7, 7, 
	5, 7, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 5, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 7, 7, 7, 5, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 5, 7, 5, 63, 5, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 64, 65, 66, 67, 68, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	69, 70, 71, 72, 73, 5, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 8, 5, 7, 7, 7, 5, 74, 
	75, 76, 5, 77, 5, 8, 5, 38, 
	5, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 5, 8, 8, 5, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	5, 8, 5, 8, 8, 5, 8, 8, 
	5, 8, 8, 5, 8, 8, 5, 8, 
	5, 8, 5, 8, 5, 8, 5, 6, 
	7, 5, 38, 39, 94, 42, 43, 44, 
	45, 46, 41, 5, 6, 7, 5, 95, 
	96, 49, 50, 51, 52, 53, 54, 55, 
	56, 57, 58, 59, 41, 60, 61, 62, 
	5, 7, 6, 7, 6, 7, 7, 5, 
	7, 6, 7, 5, 97, 5, 6, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 5, 98, 99, 100, 98, 98, 98, 
	98, 98, 98, 5, 101, 101, 101, 101, 
	101, 101, 101, 5, 101, 100, 101, 101, 
	101, 101, 101, 101, 5, 102, 103, 104, 
	105, 106, 106, 5, 107, 108, 106, 106, 
	106, 5, 107, 106, 106, 106, 5, 107, 
	109, 106, 106, 106, 5, 106, 110, 111, 
	5, 107, 109, 106, 112, 106, 5, 113, 
	114, 114, 113, 113, 113, 114, 113, 113, 
	114, 114, 5, 115, 5, 107, 109, 106, 
	106, 116, 5, 117, 118, 119, 120, 110, 
	111, 5, 107, 121, 106, 106, 106, 5, 
	122, 123, 124, 125, 110, 111, 5, 107, 
	126, 106, 106, 106, 5, 127, 128, 129, 
	130, 110, 111, 5, 107, 126, 125, 106, 
	106, 5, 107, 126, 122, 106, 106, 5, 
	107, 126, 131, 125, 122, 106, 106, 5, 
	107, 126, 122, 106, 106, 106, 5, 107, 
	121, 120, 106, 106, 5, 107, 121, 117, 
	106, 106, 5, 107, 121, 132, 120, 117, 
	106, 106, 5, 107, 121, 117, 106, 106, 
	106, 5, 107, 108, 105, 106, 106, 5, 
	107, 108, 102, 106, 106, 5, 107, 108, 
	133, 105, 102, 106, 106, 5, 107, 108, 
	102, 106, 106, 106, 5, 134, 134, 135, 
	135, 135, 135, 135, 135, 136, 137, 138, 
	139, 140, 141, 134, 5, 6, 135, 5, 
	142, 5, 135, 135, 5, 143, 5, 6, 
	135, 5, 144, 145, 146, 147, 148, 149, 
	150, 151, 152, 5, 135, 135, 6, 135, 
	6, 5, 135, 6, 135, 5, 135, 5, 
	135, 135, 135, 5, 135, 135, 135, 135, 
	135, 135, 135, 5, 135, 135, 135, 135, 
	135, 135, 5, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 5, 135, 
	135, 135, 5, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 5, 153, 5, 
	6, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 5, 154, 155, 156, 157, 
	158, 5, 135, 5, 135, 135, 135, 135, 
	135, 135, 5, 135, 135, 135, 135, 135, 
	135, 135, 5, 135, 135, 5, 135, 135, 
	135, 5, 134, 134, 98, 135, 98, 99, 
	135, 100, 135, 98, 135, 136, 137, 138, 
	139, 140, 141, 134, 98, 159, 98, 98, 
	98, 98, 5, 98, 160, 99, 100, 98, 
	98, 98, 161, 161, 161, 5, 98, 160, 
	162, 99, 100, 98, 98, 98, 161, 161, 
	161, 5, 98, 99, 100, 98, 98, 98, 
	163, 164, 165, 5, 98, 166, 167, 99, 
	100, 98, 98, 98, 163, 163, 163, 5, 
	98, 166, 99, 100, 98, 98, 98, 163, 
	163, 163, 5, 98, 99, 100, 98, 98, 
	98, 163, 168, 169, 5, 98, 166, 167, 
	99, 100, 98, 98, 98, 163, 170, 163, 
	5, 101, 101, 101, 101, 171, 101, 101, 
	5, 98, 166, 167, 99, 100, 98, 98, 
	98, 163, 163, 172, 5, 98, 166, 167, 
	99, 100, 98, 98, 98, 163, 173, 163, 
	5, 98, 166, 167, 114, 174, 100, 98, 
	98, 98, 163, 173, 163, 5, 98, 166, 
	167, 99, 100, 98, 98, 98, 163, 163, 
	175, 5, 98, 166, 167, 114, 174, 100, 
	98, 98, 98, 163, 163, 175, 5, 98, 
	176, 177, 178, 99, 100, 98, 180, 181, 
	182, 183, 184, 185, 186, 187, 98, 98, 
	179, 164, 165, 5, 98, 188, 189, 190, 
	99, 100, 98, 98, 98, 191, 168, 169, 
	5, 98, 166, 192, 99, 100, 98, 98, 
	98, 163, 163, 163, 5, 98, 193, 194, 
	195, 99, 100, 98, 98, 98, 196, 168, 
	169, 5, 98, 166, 167, 114, 174, 100, 
	98, 98, 98, 163, 163, 163, 5, 98, 
	166, 167, 114, 174, 100, 98, 98, 98, 
	196, 163, 163, 5, 98, 166, 167, 114, 
	174, 100, 98, 98, 98, 193, 163, 163, 
	5, 98, 166, 167, 114, 197, 174, 100, 
	98, 98, 98, 196, 193, 163, 163, 5, 
	98, 166, 167, 114, 174, 100, 98, 98, 
	98, 193, 163, 163, 163, 5, 98, 166, 
	192, 99, 100, 98, 98, 98, 191, 163, 
	163, 5, 98, 166, 192, 99, 100, 98, 
	98, 98, 188, 163, 163, 5, 98, 166, 
	192, 198, 99, 100, 98, 98, 98, 191, 
	188, 163, 163, 5, 98, 166, 192, 99, 
	100, 98, 98, 98, 188, 163, 163, 163, 
	5, 98, 199, 200, 167, 99, 100, 98, 
	202, 203, 204, 205, 206, 207, 208, 209, 
	98, 98, 201, 163, 163, 5, 98, 99, 
	100, 98, 202, 203, 204, 205, 206, 207, 
	208, 209, 98, 98, 210, 98, 98, 5, 
	211, 5, 211, 5, 211, 5, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	213, 213, 202, 5, 211, 5, 211, 5, 
	204, 213, 202, 213, 214, 213, 215, 213, 
	203, 215, 5, 211, 5, 211, 211, 5, 
	202, 213, 204, 216, 213, 203, 5, 211, 
	211, 5, 213, 5, 217, 218, 219, 220, 
	5, 202, 5, 212, 203, 221, 213, 203, 
	213, 213, 204, 202, 5, 211, 5, 202, 
	213, 5, 222, 5, 211, 5, 98, 166, 
	99, 100, 98, 202, 203, 204, 205, 206, 
	207, 208, 209, 98, 98, 201, 163, 163, 
	5, 223, 5, 224, 224, 202, 203, 204, 
	205, 206, 207, 208, 209, 211, 5, 202, 
	203, 204, 205, 206, 207, 208, 209, 211, 
	5, 223, 5, 223, 5, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 226, 
	226, 180, 5, 223, 5, 223, 5, 182, 
	226, 180, 226, 227, 226, 228, 226, 181, 
	228, 5, 223, 5, 223, 223, 5, 180, 
	226, 182, 229, 226, 181, 5, 223, 223, 
	5, 226, 5, 230, 231, 232, 233, 5, 
	180, 5, 225, 181, 234, 226, 181, 226, 
	226, 182, 180, 5, 223, 5, 180, 226, 
	5, 235, 5, 223, 5, 98, 99, 100, 
	98, 180, 181, 182, 183, 184, 185, 186, 
	187, 98, 98, 236, 164, 165, 5, 98, 
	199, 237, 162, 99, 100, 98, 202, 203, 
	204, 205, 206, 207, 208, 209, 98, 98, 
	238, 161, 161, 5, 98, 160, 99, 100, 
	98, 202, 203, 204, 205, 206, 207, 208, 
	209, 98, 98, 238, 161, 161, 5, 239, 
	5, 180, 181, 182, 183, 184, 185, 186, 
	187, 223, 5, 239, 5, 239, 5, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 241, 241, 242, 5, 239, 5, 239, 
	5, 243, 241, 242, 241, 244, 241, 245, 
	241, 246, 245, 5, 239, 5, 239, 239, 
	5, 242, 241, 243, 247, 241, 246, 5, 
	239, 239, 5, 241, 5, 248, 249, 250, 
	251, 5, 242, 5, 240, 246, 252, 241, 
	246, 241, 241, 243, 242, 5, 239, 5, 
	242, 241, 5, 253, 5, 239, 5, 101, 
	254, 101, 101, 101, 101, 101, 5, 255, 
	5, 98, 256, 257, 258, 98, 98, 98, 
	259, 163, 163, 5, 98, 166, 260, 99, 
	100, 98, 98, 98, 163, 163, 163, 5, 
	98, 261, 262, 263, 99, 100, 98, 98, 
	98, 264, 168, 169, 5, 98, 166, 265, 
	99, 100, 98, 98, 98, 163, 163, 163, 
	5, 98, 266, 267, 268, 99, 100, 98, 
	98, 98, 269, 168, 169, 5, 98, 166, 
	270, 99, 100, 98, 98, 98, 163, 163, 
	163, 5, 98, 271, 272, 273, 99, 100, 
	98, 98, 98, 274, 168, 169, 5, 98, 
	166, 270, 99, 100, 98, 98, 98, 269, 
	163, 163, 5, 98, 166, 270, 99, 100, 
	98, 98, 98, 266, 163, 163, 5, 98, 
	166, 270, 275, 99, 100, 98, 98, 98, 
	269, 266, 163, 163, 5, 98, 166, 270, 
	99, 100, 98, 98, 98, 266, 163, 163, 
	163, 5, 98, 166, 265, 99, 100, 98, 
	98, 98, 264, 163, 163, 5, 98, 166, 
	265, 99, 100, 98, 98, 98, 261, 163, 
	163, 5, 98, 166, 265, 276, 99, 100, 
	98, 98, 98, 264, 261, 163, 163, 5, 
	98, 166, 265, 99, 100, 98, 98, 98, 
	261, 163, 163, 163, 5, 98, 166, 260, 
	99, 100, 98, 98, 98, 259, 163, 163, 
	5, 98, 166, 260, 99, 100, 98, 98, 
	98, 256, 163, 163, 5, 98, 166, 260, 
	277, 99, 100, 98, 98, 98, 259, 256, 
	163, 163, 5, 98, 166, 260, 99, 100, 
	98, 98, 98, 256, 163, 163, 163, 5, 
	278, 278, 278, 5, 278, 278, 278, 5, 
	278, 5, 278, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 5, 278, 278, 278, 
	278, 278, 5, 278, 278, 5, 278, 278, 
	5, 278, 278, 5, 278, 278, 278, 5, 
	278, 278, 278, 5, 278, 278, 278, 278, 
	278, 5, 278, 278, 5, 278, 278, 5, 
	278, 278, 278, 278, 278, 278, 5, 278, 
	5, 278, 278, 5, 278, 5, 278, 278, 
	5, 279, 280, 281, 282, 283, 284, 285, 
	286, 287, 288, 289, 290, 291, 292, 293, 
	294, 295, 296, 297, 298, 299, 300, 301, 
	302, 303, 304, 305, 306, 307, 308, 309, 
	310, 5, 278, 5, 278, 5, 278, 5, 
	278, 5, 278, 278, 5, 278, 278, 278, 
	278, 278, 278, 278, 278, 5, 278, 278, 
	278, 278, 278, 278, 278, 5, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	278, 5, 278, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 5, 278, 278, 278, 
	278, 278, 5, 278, 278, 278, 278, 278, 
	278, 5, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 278, 278, 5, 278, 
	278, 278, 278, 278, 278, 5, 278, 278, 
	278, 278, 278, 5, 278, 278, 278, 278, 
	278, 278, 5, 278, 5, 278, 5, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 5, 278, 278, 278, 
	278, 5, 278, 278, 278, 278, 278, 278, 
	5, 278, 278, 278, 5, 278, 278, 278, 
	5, 278, 5, 311, 312, 313, 314, 315, 
	316, 317, 318, 319, 320, 321, 322, 323, 
	324, 325, 326, 327, 328, 329, 330, 331, 
	332, 333, 334, 335, 336, 337, 338, 283, 
	339, 340, 341, 329, 342, 343, 344, 345, 
	346, 347, 348, 283, 283, 5, 278, 278, 
	278, 5, 278, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 278, 278, 5, 278, 
	278, 278, 278, 278, 5, 278, 278, 278, 
	278, 5, 278, 278, 278, 5, 278, 278, 
	5, 278, 278, 5, 278, 5, 278, 5, 
	278, 278, 5, 278, 278, 5, 278, 278, 
	5, 278, 278, 278, 5, 278, 278, 278, 
	278, 5, 278, 278, 278, 5, 278, 278, 
	5, 278, 5, 278, 278, 5, 278, 5, 
	278, 278, 278, 5, 278, 278, 5, 278, 
	278, 5, 278, 5, 278, 278, 5, 278, 
	278, 278, 5, 278, 278, 5, 278, 278, 
	5, 278, 278, 5, 278, 5, 278, 278, 
	5, 278, 278, 278, 5, 278, 278, 5, 
	278, 278, 278, 5, 278, 278, 278, 278, 
	278, 278, 278, 5, 278, 278, 278, 5, 
	278, 278, 278, 278, 278, 278, 278, 5, 
	349, 350, 351, 352, 353, 354, 355, 356, 
	283, 357, 358, 359, 360, 361, 362, 5, 
	278, 278, 5, 278, 5, 278, 5, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 5, 278, 278, 5, 278, 5, 
	278, 278, 5, 278, 278, 5, 278, 278, 
	5, 278, 278, 278, 278, 5, 278, 278, 
	278, 5, 278, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 278, 5, 278, 5, 
	363, 321, 364, 365, 366, 283, 367, 368, 
	283, 5, 278, 278, 278, 278, 5, 278, 
	278, 278, 278, 5, 278, 278, 5, 278, 
	278, 5, 278, 278, 5, 278, 5, 331, 
	283, 283, 5, 283, 5, 369, 283, 5, 
	278, 5, 369, 370, 371, 372, 373, 374, 
	375, 376, 377, 378, 341, 379, 380, 381, 
	382, 383, 384, 385, 386, 387, 388, 283, 
	283, 5, 278, 5, 278, 278, 278, 5, 
	278, 278, 278, 5, 278, 278, 5, 278, 
	278, 5, 278, 278, 5, 278, 278, 278, 
	278, 5, 278, 5, 278, 5, 278, 278, 
	278, 5, 278, 278, 5, 278, 278, 5, 
	278, 278, 278, 278, 5, 278, 5, 278, 
	278, 278, 5, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 278, 278, 5, 278, 
	278, 278, 5, 278, 278, 5, 389, 390, 
	283, 5, 278, 278, 5, 278, 278, 5, 
	391, 392, 393, 394, 395, 396, 397, 311, 
	398, 399, 400, 401, 402, 403, 404, 405, 
	406, 283, 5, 278, 278, 5, 278, 5, 
	278, 278, 278, 278, 278, 278, 5, 278, 
	278, 278, 5, 278, 5, 278, 5, 278, 
	278, 5, 278, 278, 5, 278, 278, 5, 
	278, 278, 5, 278, 5, 278, 5, 278, 
	278, 5, 278, 5, 278, 278, 278, 278, 
	5, 407, 408, 409, 410, 411, 412, 413, 
	414, 416, 417, 418, 415, 5, 419, 420, 
	283, 421, 422, 423, 424, 425, 426, 427, 
	428, 429, 430, 431, 383, 432, 433, 434, 
	435, 436, 437, 438, 439, 440, 441, 331, 
	442, 443, 283, 444, 283, 283, 5, 278, 
	278, 278, 278, 278, 5, 278, 278, 5, 
	278, 5, 278, 5, 278, 278, 5, 278, 
	278, 5, 278, 278, 5, 278, 278, 278, 
	5, 278, 278, 5, 278, 278, 5, 278, 
	5, 278, 278, 5, 278, 5, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 5, 
	278, 278, 5, 278, 5, 278, 278, 5, 
	278, 278, 5, 278, 278, 278, 278, 278, 
	278, 278, 5, 278, 5, 278, 5, 278, 
	278, 5, 278, 278, 5, 278, 5, 278, 
	5, 445, 421, 446, 320, 447, 448, 449, 
	368, 450, 291, 451, 283, 452, 453, 454, 
	283, 455, 329, 456, 457, 458, 283, 5, 
	278, 278, 5, 278, 5, 278, 278, 5, 
	278, 278, 5, 278, 278, 5, 278, 5, 
	278, 278, 278, 278, 278, 278, 278, 5, 
	278, 278, 5, 278, 278, 5, 278, 5, 
	278, 278, 5, 278, 5, 278, 278, 5, 
	278, 5, 459, 283, 5, 278, 5, 460, 
	283, 5, 278, 5, 458, 435, 333, 383, 
	461, 462, 283, 463, 464, 283, 5, 278, 
	278, 278, 5, 278, 5, 278, 278, 5, 
	278, 5, 465, 283, 466, 467, 5, 278, 
	5, 278, 278, 5, 278, 278, 278, 5, 
	468, 469, 470, 471, 472, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 283, 5, 
	278, 278, 278, 5, 278, 278, 278, 5, 
	278, 5, 278, 278, 5, 278, 278, 278, 
	278, 278, 278, 278, 278, 5, 278, 278, 
	5, 278, 278, 278, 278, 278, 278, 5, 
	278, 278, 278, 278, 5, 278, 278, 5, 
	278, 278, 278, 278, 5, 278, 278, 278, 
	5, 278, 278, 278, 5, 278, 278, 278, 
	5, 278, 278, 5, 482, 483, 484, 485, 
	283, 5, 278, 278, 5, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 5, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 5, 278, 278, 278, 278, 278, 
	5, 486, 283, 5, 278, 5, 320, 429, 
	283, 5, 429, 283, 5, 487, 5, 488, 
	283, 5, 278, 5, 98, 99, 100, 98, 
	180, 181, 182, 183, 184, 185, 186, 187, 
	98, 98, 489, 98, 98, 5, 98, 199, 
	199, 99, 100, 98, 202, 203, 204, 205, 
	206, 207, 208, 209, 98, 98, 210, 98, 
	98, 5, 1, 491, 492, 1, 493, 490, 
	494, 493, 490, 496, 497, 498, 500, 494, 
	503, 504, 506, 502, 507, 508, 509, 510, 
	511, 512, 513, 514, 515, 516, 517, 518, 
	519, 520, 521, 522, 523, 524, 525, 526, 
	528, 529, 530, 531, 532, 494, 533, 494, 
	533, 490, 494, 499, 490, 501, 490, 501, 
	490, 502, 505, 527, 502, 495, 1, 535, 
	536, 1, 537, 538, 539, 540, 534, 1, 
	541, 1, 537, 538, 539, 540, 534, 1, 
	1, 537, 538, 539, 540, 534, 1, 541, 
	1, 537, 538, 539, 540, 534, 1, 542, 
	543, 1, 537, 538, 539, 540, 534, 545, 
	544, 1, 542, 546, 1, 537, 538, 539, 
	540, 534, 545, 544, 1, 543, 546, 1, 
	537, 538, 539, 540, 534, 134, 134, 98, 
	135, 98, 99, 135, 100, 135, 98, 135, 
	136, 137, 138, 139, 140, 141, 134, 98, 
	159, 98, 98, 98, 98, 547, 107, 109, 
	114, 548, 106, 112, 106, 547, 113, 114, 
	114, 113, 113, 113, 114, 113, 113, 114, 
	114, 547, 114, 115, 547, 107, 109, 114, 
	548, 106, 106, 116, 547, 107, 109, 114, 
	548, 106, 106, 106, 547, 107, 109, 114, 
	548, 130, 106, 106, 547, 107, 109, 114, 
	548, 127, 106, 106, 547, 107, 109, 114, 
	549, 548, 130, 127, 106, 106, 547, 107, 
	109, 114, 548, 127, 106, 106, 106, 547, 
	98, 99, 100, 98, 98, 98, 98, 98, 
	98, 547, 98, 160, 550, 99, 100, 552, 
	98, 552, 242, 246, 243, 553, 554, 555, 
	556, 557, 98, 98, 551, 161, 161, 547, 
	98, 166, 167, 114, 174, 100, 98, 98, 
	98, 163, 170, 163, 547, 101, 114, 100, 
	101, 101, 101, 171, 101, 101, 547, 98, 
	166, 167, 114, 174, 100, 98, 98, 98, 
	163, 163, 172, 547, 98, 166, 558, 99, 
	100, 559, 98, 559, 180, 181, 182, 183, 
	184, 185, 186, 187, 98, 98, 236, 163, 
	163, 547, 98, 166, 167, 99, 100, 559, 
	98, 559, 180, 181, 182, 183, 184, 185, 
	186, 187, 98, 98, 236, 163, 163, 547, 
	98, 99, 100, 98, 202, 203, 204, 205, 
	206, 207, 208, 209, 98, 98, 210, 98, 
	98, 547, 202, 203, 204, 205, 206, 207, 
	208, 209, 211, 547, 98, 166, 167, 99, 
	100, 98, 202, 203, 204, 205, 206, 207, 
	208, 209, 98, 98, 201, 163, 163, 547, 
	560, 560, 180, 181, 182, 183, 184, 185, 
	186, 187, 223, 547, 98, 166, 558, 99, 
	100, 559, 98, 559, 180, 181, 182, 183, 
	184, 185, 186, 187, 98, 98, 179, 163, 
	163, 547, 98, 166, 558, 99, 100, 559, 
	98, 559, 180, 181, 182, 183, 184, 185, 
	186, 187, 98, 98, 176, 163, 163, 547, 
	98, 166, 558, 561, 99, 100, 559, 98, 
	559, 180, 181, 182, 183, 184, 185, 186, 
	187, 98, 98, 179, 176, 163, 163, 547, 
	98, 166, 558, 99, 100, 559, 98, 559, 
	180, 181, 182, 183, 184, 185, 186, 187, 
	98, 98, 176, 236, 163, 163, 547, 98, 
	160, 562, 99, 100, 552, 98, 552, 242, 
	246, 243, 553, 554, 555, 556, 557, 98, 
	98, 551, 161, 161, 547, 98, 160, 162, 
	99, 100, 98, 202, 203, 204, 205, 206, 
	207, 208, 209, 98, 98, 238, 161, 161, 
	547, 563, 560, 560, 242, 246, 243, 553, 
	554, 555, 556, 557, 239, 547, 98, 160, 
	550, 99, 100, 552, 98, 552, 242, 246, 
	243, 553, 554, 555, 556, 557, 98, 98, 
	499, 161, 161, 547, 98, 160, 550, 99, 
	100, 552, 98, 552, 242, 246, 243, 553, 
	554, 555, 556, 557, 98, 98, 496, 161, 
	161, 547, 98, 160, 550, 564, 99, 100, 
	552, 98, 552, 242, 246, 243, 553, 554, 
	555, 556, 557, 98, 98, 499, 496, 161, 
	161, 547, 98, 160, 550, 99, 100, 552, 
	98, 552, 242, 246, 243, 553, 554, 555, 
	556, 557, 98, 98, 496, 551, 161, 161, 
	547, 134, 134, 135, 135, 135, 135, 135, 
	135, 136, 137, 138, 139, 140, 141, 134, 
	547, 98, 160, 162, 99, 100, 98, 566, 
	567, 568, 569, 570, 571, 572, 573, 574, 
	575, 576, 577, 578, 579, 311, 580, 395, 
	581, 582, 583, 584, 585, 586, 587, 588, 
	589, 590, 591, 592, 98, 98, 161, 565, 
	565, 283, 415, 547, 98, 160, 162, 99, 
	100, 98, 566, 567, 568, 569, 570, 571, 
	572, 573, 574, 575, 576, 577, 578, 579, 
	311, 580, 395, 581, 582, 583, 584, 585, 
	586, 587, 588, 589, 590, 591, 592, 98, 
	98, 161, 593, 593, 283, 415, 547, 98, 
	160, 162, 594, 100, 98, 566, 567, 568, 
	569, 570, 571, 572, 573, 574, 575, 576, 
	577, 578, 579, 311, 580, 395, 581, 582, 
	583, 584, 585, 586, 587, 588, 589, 590, 
	591, 592, 98, 98, 161, 593, 593, 283, 
	415, 547, 98, 166, 167, 114, 174, 100, 
	98, 98, 98, 163, 163, 163, 547, 98, 
	166, 167, 114, 174, 100, 98, 98, 98, 
	274, 163, 163, 547, 98, 166, 167, 114, 
	174, 100, 98, 98, 98, 271, 163, 163, 
	547, 98, 166, 167, 114, 595, 174, 100, 
	98, 98, 98, 274, 271, 163, 163, 547, 
	98, 166, 167, 114, 174, 100, 98, 98, 
	98, 271, 163, 163, 163, 547, 566, 567, 
	568, 569, 570, 571, 572, 573, 574, 575, 
	576, 577, 578, 579, 311, 580, 395, 581, 
	582, 583, 584, 585, 586, 587, 588, 589, 
	590, 591, 592, 278, 278, 283, 415, 547, 
	502, 547, 596, 597, 597, 597, 502, 547, 
	1, 535, 536, 1, 537, 538, 539, 540, 
	502, 534, 566, 567, 568, 569, 570, 571, 
	572, 573, 574, 575, 576, 577, 578, 579, 
	311, 580, 395, 581, 582, 583, 584, 585, 
	586, 587, 588, 589, 590, 591, 592, 278, 
	278, 502, 283, 415, 547, 502, 502, 597, 
	547, 597, 547, 597, 597, 597, 502, 597, 
	502, 597, 502, 547, 502, 502, 502, 597, 
	502, 597, 547, 597, 502, 502, 502, 502, 
	597, 547, 502, 597, 547, 597, 502, 597, 
	547, 502, 597, 547, 597, 597, 502, 597, 
	547, 597, 502, 547, 502, 597, 502, 597, 
	502, 547, 502, 597, 547, 502, 597, 502, 
	598, 502, 597, 547, 563, 560, 560, 242, 
	246, 243, 553, 554, 555, 556, 557, 239, 
	502, 547, 502, 597, 597, 502, 597, 502, 
	597, 598, 597, 502, 547, 597, 502, 597, 
	502, 547, 502, 597, 547, 597, 597, 502, 
	547, 597, 598, 597, 502, 597, 502, 547, 
	599, 600, 601, 602, 603, 604, 605, 606, 
	607, 608, 609, 610, 611, 612, 613, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 626, 627, 628, 502, 547, 
	597, 597, 597, 597, 502, 547, 597, 502, 
	547, 502, 597, 502, 547, 597, 502, 597, 
	502, 547, 597, 502, 502, 597, 502, 598, 
	597, 547, 597, 502, 502, 597, 502, 597, 
	502, 597, 502, 597, 502, 597, 502, 547, 
	597, 502, 502, 597, 502, 598, 597, 502, 
	547, 502, 502, 502, 502, 502, 597, 502, 
	597, 502, 597, 502, 547, 502, 502, 597, 
	502, 598, 502, 597, 502, 547, 502, 502, 
	502, 502, 502, 597, 502, 597, 502, 547, 
	597, 502, 597, 502, 598, 502, 547, 502, 
	502, 502, 597, 502, 597, 502, 597, 502, 
	597, 502, 547, 502, 597, 502, 597, 502, 
	598, 502, 547, 597, 502, 502, 502, 502, 
	597, 502, 597, 502, 597, 502, 597, 502, 
	597, 502, 597, 502, 547, 597, 502, 598, 
	502, 547, 502, 502, 502, 597, 502, 597, 
	502, 547, 502, 597, 502, 597, 502, 598, 
	502, 547, 502, 502, 502, 502, 597, 502, 
	597, 502, 547, 597, 502, 502, 597, 502, 
	598, 597, 502, 547, 502, 502, 597, 502, 
	597, 502, 547, 597, 502, 597, 502, 598, 
	502, 597, 547, 502, 502, 502, 597, 502, 
	597, 502, 547, 597, 502, 598, 502, 547, 
	502, 502, 597, 502, 547, 597, 502, 598, 
	502, 547, 502, 502, 502, 597, 502, 502, 
	502, 502, 502, 502, 597, 597, 502, 597, 
	502, 597, 502, 597, 502, 547, 502, 597, 
	502, 598, 502, 597, 502, 547, 597, 502, 
	598, 502, 547, 502, 597, 502, 547, 502, 
	597, 502, 547, 629, 630, 631, 632, 633, 
	634, 635, 636, 637, 638, 639, 640, 641, 
	642, 643, 644, 645, 646, 647, 648, 649, 
	650, 651, 652, 653, 654, 655, 656, 657, 
	658, 502, 659, 660, 661, 662, 663, 664, 
	502, 665, 502, 666, 667, 668, 669, 505, 
	547, 597, 597, 502, 547, 597, 598, 502, 
	597, 502, 597, 502, 597, 502, 597, 502, 
	597, 547, 597, 597, 502, 598, 502, 597, 
	547, 502, 597, 502, 597, 502, 597, 547, 
	502, 502, 502, 597, 502, 597, 502, 597, 
	547, 502, 502, 502, 597, 502, 597, 502, 
	597, 547, 502, 502, 597, 502, 597, 547, 
	502, 597, 502, 597, 547, 597, 502, 547, 
	597, 502, 597, 547, 597, 502, 547, 502, 
	597, 547, 597, 502, 597, 547, 596, 597, 
	502, 597, 547, 597, 502, 597, 502, 547, 
	502, 597, 502, 597, 502, 547, 502, 597, 
	502, 597, 502, 547, 597, 502, 547, 597, 
	597, 502, 598, 502, 547, 502, 598, 502, 
	597, 547, 597, 502, 547, 502, 597, 502, 
	597, 547, 597, 502, 547, 597, 502, 547, 
	502, 598, 597, 502, 597, 502, 547, 597, 
	502, 547, 502, 597, 502, 598, 502, 547, 
	597, 502, 597, 547, 597, 502, 547, 597, 
	598, 502, 598, 502, 547, 502, 597, 502, 
	547, 502, 597, 502, 598, 502, 547, 502, 
	597, 502, 597, 598, 597, 547, 597, 502, 
	547, 597, 502, 547, 598, 502, 597, 598, 
	597, 502, 547, 502, 502, 597, 502, 597, 
	502, 547, 597, 502, 597, 502, 597, 547, 
	502, 502, 502, 502, 597, 502, 597, 502, 
	597, 502, 547, 502, 502, 502, 597, 547, 
	502, 502, 502, 597, 502, 597, 502, 597, 
	502, 597, 502, 597, 502, 547, 670, 671, 
	672, 673, 674, 675, 676, 677, 505, 678, 
	679, 680, 681, 682, 683, 502, 547, 684, 
	596, 596, 502, 547, 134, 134, 135, 135, 
	135, 135, 135, 135, 136, 137, 138, 139, 
	140, 141, 134, 502, 547, 596, 597, 597, 
	502, 547, 502, 597, 502, 547, 597, 597, 
	502, 597, 597, 597, 502, 502, 597, 502, 
	597, 502, 597, 502, 597, 547, 597, 502, 
	597, 502, 547, 502, 597, 502, 547, 502, 
	597, 547, 502, 597, 547, 597, 502, 597, 
	502, 597, 502, 547, 502, 597, 597, 502, 
	597, 547, 597, 597, 502, 547, 502, 502, 
	502, 502, 597, 502, 597, 547, 502, 502, 
	502, 597, 502, 547, 597, 502, 547, 685, 
	640, 686, 687, 688, 505, 689, 690, 502, 
	505, 547, 596, 502, 597, 502, 597, 502, 
	597, 502, 547, 502, 597, 502, 597, 547, 
	502, 597, 547, 502, 597, 502, 597, 547, 
	597, 502, 597, 502, 547, 502, 597, 547, 
	651, 502, 505, 547, 505, 547, 691, 505, 
	547, 597, 502, 547, 691, 692, 693, 694, 
	695, 662, 696, 697, 698, 699, 646, 700, 
	701, 702, 703, 704, 705, 706, 707, 708, 
	709, 710, 711, 502, 712, 505, 547, 502, 
	597, 502, 547, 597, 502, 597, 598, 597, 
	502, 547, 597, 597, 502, 547, 597, 502, 
	597, 547, 502, 597, 502, 597, 547, 502, 
	597, 502, 597, 502, 597, 502, 547, 502, 
	597, 547, 502, 502, 502, 597, 502, 547, 
	502, 597, 502, 547, 597, 502, 598, 502, 
	597, 502, 547, 598, 597, 502, 597, 547, 
	597, 502, 597, 502, 547, 502, 597, 502, 
	547, 597, 502, 502, 502, 598, 502, 597, 
	598, 597, 547, 597, 502, 547, 502, 597, 
	597, 502, 598, 502, 597, 502, 597, 547, 
	502, 597, 502, 597, 502, 597, 502, 547, 
	502, 597, 502, 597, 502, 597, 502, 597, 
	502, 547, 502, 502, 502, 597, 502, 597, 
	502, 597, 502, 597, 547, 502, 597, 502, 
	597, 502, 547, 597, 502, 598, 502, 547, 
	713, 714, 505, 502, 547, 597, 502, 597, 
	547, 597, 502, 597, 502, 547, 715, 716, 
	717, 718, 719, 720, 721, 722, 723, 724, 
	502, 725, 726, 727, 728, 729, 730, 502, 
	505, 547, 597, 502, 597, 547, 597, 502, 
	547, 597, 502, 502, 502, 502, 597, 502, 
	597, 502, 597, 547, 502, 502, 597, 547, 
	597, 502, 547, 502, 597, 547, 597, 502, 
	547, 502, 597, 547, 597, 502, 597, 547, 
	597, 502, 597, 502, 547, 502, 502, 597, 
	547, 597, 502, 547, 502, 598, 502, 597, 
	502, 547, 502, 597, 502, 597, 547, 502, 
	597, 547, 502, 597, 502, 597, 502, 597, 
	502, 597, 502, 547, 731, 732, 733, 734, 
	735, 736, 737, 738, 739, 740, 741, 502, 
	527, 502, 547, 742, 743, 505, 744, 745, 
	746, 747, 748, 695, 749, 750, 751, 663, 
	752, 753, 754, 755, 652, 756, 757, 758, 
	759, 760, 761, 651, 762, 763, 505, 764, 
	502, 505, 502, 505, 502, 547, 502, 502, 
	502, 502, 597, 547, 597, 502, 597, 502, 
	547, 597, 502, 547, 597, 502, 597, 547, 
	597, 502, 547, 597, 502, 597, 547, 502, 
	597, 502, 597, 502, 547, 597, 502, 597, 
	502, 547, 597, 502, 598, 502, 547, 597, 
	502, 597, 547, 597, 502, 547, 597, 502, 
	597, 502, 547, 597, 502, 597, 597, 597, 
	502, 597, 502, 547, 597, 502, 597, 502, 
	547, 597, 502, 597, 502, 547, 597, 502, 
	597, 547, 597, 502, 502, 502, 597, 502, 
	547, 502, 597, 502, 547, 597, 502, 547, 
	502, 597, 502, 547, 597, 502, 597, 502, 
	547, 597, 502, 547, 597, 502, 547, 765, 
	766, 767, 768, 769, 770, 771, 772, 773, 
	690, 774, 610, 775, 776, 777, 778, 776, 
	779, 780, 781, 515, 782, 783, 502, 547, 
	502, 597, 502, 547, 502, 598, 502, 547, 
	502, 597, 502, 547, 502, 597, 502, 598, 
	502, 547, 502, 597, 502, 598, 547, 597, 
	502, 597, 502, 547, 502, 597, 502, 547, 
	502, 597, 597, 502, 598, 502, 547, 502, 
	597, 502, 547, 597, 502, 598, 502, 547, 
	502, 597, 502, 547, 597, 502, 547, 502, 
	502, 597, 502, 598, 502, 547, 597, 502, 
	547, 597, 502, 598, 502, 547, 597, 502, 
	547, 598, 502, 547, 597, 597, 598, 502, 
	547, 597, 502, 547, 600, 505, 502, 547, 
	778, 505, 502, 547, 783, 784, 785, 776, 
	786, 787, 505, 788, 789, 502, 505, 502, 
	547, 502, 597, 598, 502, 547, 502, 597, 
	502, 547, 597, 502, 598, 502, 597, 502, 
	597, 547, 597, 502, 547, 597, 597, 502, 
	547, 502, 597, 502, 547, 790, 505, 791, 
	792, 502, 547, 597, 502, 547, 597, 502, 
	597, 502, 547, 597, 502, 597, 502, 547, 
	793, 794, 795, 796, 797, 798, 799, 800, 
	801, 802, 803, 502, 505, 502, 547, 502, 
	597, 547, 502, 597, 502, 502, 502, 597, 
	502, 597, 502, 597, 547, 502, 597, 547, 
	502, 502, 502, 502, 502, 597, 502, 597, 
	547, 502, 502, 597, 502, 597, 547, 597, 
	502, 597, 547, 502, 502, 502, 597, 547, 
	502, 502, 597, 547, 502, 502, 597, 547, 
	502, 502, 597, 547, 502, 597, 502, 598, 
	547, 804, 805, 806, 807, 502, 505, 502, 
	547, 597, 502, 547, 502, 502, 502, 597, 
	502, 502, 502, 597, 502, 597, 502, 547, 
	597, 597, 597, 597, 502, 502, 597, 597, 
	597, 597, 597, 502, 502, 502, 502, 502, 
	502, 502, 597, 502, 597, 502, 597, 547, 
	502, 502, 502, 597, 502, 597, 502, 547, 
	808, 505, 547, 597, 502, 547, 639, 809, 
	505, 502, 547, 597, 502, 547, 809, 502, 
	505, 502, 547, 98, 99, 100, 98, 242, 
	246, 243, 553, 554, 555, 556, 557, 98, 
	98, 810, 98, 98, 547, 98, 811, 99, 
	100, 812, 98, 812, 242, 246, 243, 553, 
	554, 555, 556, 557, 98, 98, 810, 98, 
	98, 547, 98, 99, 100, 812, 98, 812, 
	180, 181, 182, 183, 184, 185, 186, 187, 
	98, 98, 489, 98, 98, 547, 0
};

static const short _generic_tokenizer_trans_targs[] = {
	505, 506, 3, 5, 6, 505, 8, 9, 
	505, 91, 11, 12, 13, 14, 15, 16, 
	17, 18, 19, 20, 21, 22, 23, 24, 
	25, 26, 27, 92, 94, 97, 58, 64, 
	70, 10, 29, 39, 56, 28, 30, 31, 
	32, 33, 34, 35, 36, 37, 38, 40, 
	41, 42, 43, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 55, 57, 
	59, 60, 61, 62, 63, 65, 66, 67, 
	68, 69, 71, 73, 74, 72, 75, 76, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 93, 95, 
	96, 98, 99, 100, 102, 101, 103, 124, 
	126, 125, 105, 104, 111, 106, 107, 110, 
	516, 108, 517, 518, 519, 112, 120, 122, 
	121, 113, 114, 116, 118, 117, 115, 520, 
	521, 523, 522, 119, 123, 127, 8, 128, 
	129, 130, 132, 134, 144, 146, 131, 133, 
	135, 136, 137, 138, 139, 140, 141, 142, 
	143, 145, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 162, 164, 157, 158, 
	159, 161, 527, 528, 529, 163, 160, 165, 
	530, 536, 538, 537, 201, 204, 205, 206, 
	209, 212, 214, 215, 168, 175, 177, 176, 
	169, 170, 171, 173, 172, 174, 178, 180, 
	200, 534, 181, 182, 183, 184, 187, 190, 
	192, 193, 532, 533, 185, 186, 188, 189, 
	191, 194, 195, 197, 198, 196, 199, 535, 
	203, 207, 208, 210, 211, 213, 216, 217, 
	219, 220, 218, 221, 531, 224, 541, 542, 
	230, 231, 225, 228, 233, 234, 227, 236, 
	239, 240, 242, 243, 241, 244, 246, 247, 
	248, 262, 264, 263, 249, 250, 258, 260, 
	259, 251, 252, 254, 256, 255, 253, 551, 
	552, 554, 553, 257, 261, 265, 556, 286, 
	287, 288, 289, 268, 290, 291, 292, 293, 
	294, 295, 296, 297, 298, 299, 300, 301, 
	302, 303, 304, 305, 306, 307, 308, 309, 
	310, 311, 312, 313, 314, 315, 316, 281, 
	318, 319, 320, 321, 322, 323, 324, 325, 
	326, 327, 328, 329, 330, 331, 332, 333, 
	334, 335, 336, 337, 338, 339, 340, 341, 
	342, 343, 344, 345, 346, 347, 348, 349, 
	350, 351, 352, 353, 354, 356, 357, 358, 
	359, 360, 361, 362, 363, 364, 365, 366, 
	367, 368, 369, 371, 372, 373, 374, 375, 
	376, 380, 382, 383, 384, 385, 386, 387, 
	388, 389, 390, 391, 392, 393, 394, 395, 
	396, 397, 398, 399, 400, 402, 403, 405, 
	406, 407, 408, 283, 409, 410, 411, 412, 
	413, 414, 415, 416, 417, 418, 419, 421, 
	448, 463, 465, 467, 472, 476, 491, 378, 
	496, 498, 499, 422, 423, 424, 425, 426, 
	427, 428, 429, 430, 431, 432, 433, 434, 
	435, 436, 437, 438, 439, 440, 441, 442, 
	443, 444, 445, 446, 447, 449, 450, 451, 
	452, 453, 454, 455, 456, 457, 458, 459, 
	460, 461, 462, 464, 466, 468, 469, 470, 
	471, 473, 474, 475, 477, 478, 479, 480, 
	481, 482, 483, 484, 485, 486, 487, 488, 
	489, 490, 492, 493, 494, 495, 497, 501, 
	502, 804, 505, 510, 514, 515, 525, 0, 
	526, 543, 545, 544, 547, 548, 557, 558, 
	561, 562, 563, 564, 565, 566, 567, 568, 
	569, 570, 571, 572, 573, 575, 576, 577, 
	578, 579, 580, 611, 653, 669, 676, 677, 
	678, 680, 702, 705, 722, 802, 505, 507, 
	509, 1, 2, 4, 7, 508, 511, 512, 
	505, 505, 513, 505, 109, 524, 166, 540, 
	223, 229, 232, 235, 237, 238, 167, 179, 
	202, 539, 222, 226, 546, 549, 266, 267, 
	269, 270, 271, 272, 273, 274, 275, 276, 
	277, 278, 279, 280, 282, 284, 285, 317, 
	355, 370, 377, 379, 381, 401, 404, 420, 
	500, 550, 245, 555, 559, 560, 574, 581, 
	582, 583, 584, 585, 586, 587, 588, 589, 
	590, 591, 592, 593, 594, 595, 596, 597, 
	598, 599, 600, 601, 602, 603, 604, 605, 
	606, 607, 608, 609, 610, 612, 613, 614, 
	615, 616, 617, 618, 619, 620, 621, 622, 
	623, 624, 625, 626, 627, 628, 629, 630, 
	631, 632, 633, 634, 635, 636, 637, 638, 
	639, 640, 641, 642, 643, 644, 645, 646, 
	647, 648, 649, 650, 651, 652, 654, 656, 
	657, 658, 659, 660, 661, 662, 663, 664, 
	665, 666, 667, 668, 655, 670, 671, 672, 
	673, 674, 675, 679, 681, 682, 683, 684, 
	685, 686, 687, 688, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 703, 704, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 715, 716, 717, 718, 
	719, 720, 721, 723, 747, 767, 768, 769, 
	776, 780, 792, 797, 799, 801, 724, 725, 
	726, 727, 728, 729, 730, 731, 732, 733, 
	734, 735, 736, 737, 738, 739, 740, 741, 
	742, 743, 744, 745, 746, 748, 749, 750, 
	751, 752, 753, 754, 755, 756, 757, 758, 
	759, 760, 761, 762, 763, 764, 765, 766, 
	770, 771, 772, 773, 774, 775, 777, 778, 
	779, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 793, 794, 795, 796, 
	798, 800, 803, 503, 504
};

static const char _generic_tokenizer_trans_actions[] = {
	1, 2, 0, 0, 0, 3, 0, 0, 
	4, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	2, 2, 2, 0, 0, 0, 5, 0, 
	5, 0, 5, 5, 5, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 2, 2, 0, 0, 0, 
	2, 2, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 2, 0, 2, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	2, 2, 2, 0, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 8, 2, 2, 2, 2, 0, 
	2, 2, 2, 2, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 9, 2, 
	2, 0, 0, 0, 0, 2, 0, 2, 
	10, 11, 0, 12, 0, 2, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 0, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 2, 2, 2, 2, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 2, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 0, 0
};

static const char _generic_tokenizer_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const char _generic_tokenizer_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _generic_tokenizer_eof_trans[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 0, 535, 535, 535, 535, 535, 545, 
	535, 545, 535, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 535, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548
};

static const int generic_tokenizer_start = 505;





bool generic_tokenizer::next_sentence(vector<string_piece>& forms) {
  int cs, act;
  const char* ts, *te;
  const char* text_start = text;

  const char* unary_text;
  const char* whitespace = nullptr; // Suppress "may be uninitialized" warning
  
	{
	cs = generic_tokenizer_start;
	ts = 0;
	te = 0;
	act = 0;
	}

	{
	int _klen;
	const short *_keys;
	int _trans;
	short _widec;

	if ( ( text) == ( text_end) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	switch ( _generic_tokenizer_from_state_actions[cs] ) {
	case 7:
	{ts = ( text);}
	break;
	}

	_widec = ( (unsigned char)*text);
	_klen = _generic_tokenizer_cond_lengths[cs];
	_keys = _generic_tokenizer_cond_keys + (_generic_tokenizer_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _generic_tokenizer_cond_spaces[_generic_tokenizer_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unicode::category(utf8::first(unary_text, text - unary_text)) & ~(unicode::L | unicode::M | unicode::N | unicode::Pd))  ) _widec += 256;
		break;
	}
	case 1: {
		_widec = (short)(768u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unicode::category(utf8::first(unary_text, text - unary_text)) & ~(unicode::L | unicode::M | unicode::N) && *unary_text != '+')  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _generic_tokenizer_trans_keys + _generic_tokenizer_key_offsets[cs];
	_trans = _generic_tokenizer_index_offsets[cs];

	_klen = _generic_tokenizer_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _generic_tokenizer_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _generic_tokenizer_indicies[_trans];
_eof_trans:
	cs = _generic_tokenizer_trans_targs[_trans];

	if ( _generic_tokenizer_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _generic_tokenizer_trans_actions[_trans] ) {
	case 5:
	{ whitespace = text; }
	break;
	case 2:
	{te = ( text)+1;}
	break;
	case 8:
	{te = ( text)+1;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 4:
	{te = ( text)+1;{
          // Does this eos character marks end of sentence?
          bool eos_exception = false;
          if (!forms.empty()) {
            // Is it single Lut?
            string_piece form = forms.back();
            eos_exception = unicode::category(utf8::decode(form.str, form.len)) & unicode::Lut && !form.len;
          }

          // Add all characters until first space to forms and break if eos.
          for (text = ts; text < whitespace; forms.emplace_back(ts, text - ts), ts = text) utf8_advance(text, whitespace);
          {( text) = (( whitespace))-1;}
          if (!eos_exception) {( text)++; goto _out; }
        }}
	break;
	case 11:
	{te = ( text)+1;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 12:
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 9:
	{te = ( text);( text)--;}
	break;
	case 10:
	{te = ( text);( text)--;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 3:
	{{( text) = ((te))-1;}{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 1:
	{{( text) = ((te))-1;}}
	break;
	}

_again:
	switch ( _generic_tokenizer_to_state_actions[cs] ) {
	case 6:
	{ts = 0;}
	break;
	}

	if ( cs == 0 )
		goto _out;
	if ( ++( text) != ( text_end) )
		goto _resume;
	_test_eof: {}
	if ( ( text) == ( text_end) )
	{
	if ( _generic_tokenizer_eof_trans[cs] > 0 ) {
		_trans = _generic_tokenizer_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}


  (void)act; // Suppress unused variable warning

  return !forms.empty();
}

} // namespace morphodita
} // namespace ufal
