#!/bin/echo This is a perl module and should not be run

package Meta::Lang::Perl::Pod::Docbook;

use strict qw(vars refs subs);
use Pod::Parser qw();
use Meta::Utils::Output qw();
use Meta::Class::MethodMaker qw();

our($VERSION,@ISA);
$VERSION="0.17";
@ISA=qw(Pod::Parser);

#sub BEGIN();
#sub new($);
#sub begin_pod($);
#sub end_pod($);
#sub command($$$$$);
#sub verbatim($$$$);
#sub textblock($$$$);
#sub interior_sequence($$$$);
#sub TEST($);

#__DATA__

sub BEGIN() {
	Meta::Class::MethodMaker->get_set(
		-java=>"_in_section",
		-java=>"_emit_xml_version",
		-java=>"_emit_doctype",
		-java=>"_emit_generated_comment",
		-java=>"_xml_ver",
		-java=>"_xml_enc",
		-java=>"_docbook_type",
		-java=>"_docbook_version",
	);
}

sub new($) {
	my($class)=@_;
	my($self)=Pod::Parser->new();
	bless($self,$class);
	$self->set_in_section(0);
	$self->set_emit_xml_version(1);
	$self->set_emit_doctype(1);
	$self->set_emit_generated_comment(1);
	$self->set_xml_ver("1.0");
	$self->set_xml_enc("ISO-8859-1");
	$self->set_docbook_type("section");
	$self->set_docbook_version("4.1");
	return($self);
}

sub begin_pod($) {
	my($self)=@_;
	my($out_fh)=$self->output_handle();
	if($self->get_emit_xml_version()) {
		print $out_fh "<?xml version=\"".$self->get_xml_ver()."\" encoding=\"".$self->get_xml_enc()."\"?>\n";
	}
	if($self->get_emit_doctype()) {
		print $out_fh "<!DOCTYPE ".$self->get_docbook_type()." PUBLIC \"-//OASIS//DTD DocBook V".$self->get_docbook_version()."//EN\" []>\n";
	}
	if($self->get_emit_generated_comment()) {
		print $out_fh "<!--Auto generated by ".__PACKAGE__."-->\n";
	}
	print $out_fh "<".$self->get_docbook_type().">\n";
}

sub end_pod($) {
	my($self)=@_;
	my($out_fh)=$self->output_handle();
	if($self->get_in_section()) {
		print $out_fh "</para>\n";
		print $out_fh "</section>\n";
	}
	print $out_fh "</".$self->get_docbook_type().">\n";
}

sub command($$$$$) {
	my($self,$command,$paragraph,$line_num,$pod_para)=@_;
	my($text)=$self->interpolate($paragraph);
#	Meta::Utils::Output::print("in command with:\n");
#	Meta::Utils::Output::print("command [".$command."]\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
#	Meta::Utils::Output::print("text [".$text."]\n");
	my($out_fh)=$self->output_handle();
	if($command eq "head1") {
		if($self->get_in_section()) {
			print $out_fh "</para>\n";
			print $out_fh "</section>\n";
		}
		chop($text);
#		chop($text);
		print $out_fh "<section>\n";
		print $out_fh "<title>".$text."</title>\n";
		print $out_fh "<para>\n";
		$self->set_in_section(1);
	}
	if($command eq "item") {
		print $out_fh $text;
	}
	if($command eq "over") {
	}
	if($command eq "back") {
	}
}

sub verbatim($$$$) {
	my($self,$paragraph,$line_num,$pod_para)=@_;
#	Meta::Utils::Output::print("in verbatim with:\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
	my($out_fh)=$self->output_handle();
	chop($paragraph);
#	chop($paragraph);
	print $out_fh "<code>\n";
	print $out_fh $paragraph;
	print $out_fh "</code>\n";
}

sub textblock($$$$) {
	my($self,$paragraph,$line_num,$pod_para)=@_;
	my($text)=$self->interpolate($paragraph);
#	Meta::Utils::Output::print("in textblock with:\n");
#	Meta::Utils::Output::print("paragraph [".$paragraph."]\n");
#	Meta::Utils::Output::print("line_num [".$line_num."]\n");
#	Meta::Utils::Output::print("text [".$text."]\n");
	my($out_fh)=$self->output_handle();
	chop($text);
#	chop($text);
#	print $out_fh "<para>\n";
	print $out_fh $text;
#	print $out_fh "</para>\n";
}

sub interior_sequence($$$$) {
	my($self,$seq_cmd,$seq_arg,$pod_seq)=@_;
#	Meta::Utils::Output::print("in interior_sequence with:\n");
#	Meta::Utils::Output::print("seq_cmd [".$seq_cmd."]\n");
#	Meta::Utils::Output::print("seq_arg [".$seq_arg."]\n");
#	Meta::Utils::Output::print("pod_seq [".$pod_seq."]\n");
	if($seq_cmd eq 'B') {#emphasis
		return("<emphasis role=bold>".$seq_arg."</emphasis>");
	}
	if($seq_cmd eq 'C') {#code
		return("<code>".$seq_arg."</code>");
	}
	if($seq_cmd eq 'I') {#emphasis
		return("<emphasis>".$seq_arg."</emphasis>");
	}
	if($seq_cmd eq 'L') {#hyper link
		return("<link linkend=0>".$seq_arg."</link>");
	}
	if($seq_cmd eq 'F') {#filename
		return("<filename>".$seq_arg."</filename>");
	}
	if($seq_cmd eq 'X') {#index term
		return("<indexterm><primary>".$seq_arg."</primary></indexterm>");
	}
	if($seq_cmd eq 'S') {#non breaking spaces text
		return($seq_arg);
	}
	if($seq_cmd eq 'Z') {#zero character ?
		return($seq_arg);
	}
	if($seq_cmd eq 'E') {#escape codes (not handled)
		return($seq_arg);
	}
	throw Meta::Error::Simple("what kind of escape sequence is [".$seq_cmd."]");
	return(undef);
}

sub TEST($) {
	my($context)=@_;
	return(1);
}

1;

__END__

=head1 NAME

Meta::Lang::Perl::Pod::Docbook - Translate pod into DocBook.

=head1 COPYRIGHT

Copyright (C) 2001, 2002 Mark Veltzer;
All rights reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

=head1 DETAILS

	MANIFEST: Docbook.pm
	PROJECT: meta
	VERSION: 0.17

=head1 SYNOPSIS

	package foo;
	use Meta::Lang::Perl::Pod::Docbook qw();
	my($object)=Meta::Lang::Perl::Pod::Docbook->new();
	my($result)=$object->parse_from_file($infile,$outfile);

=head1 DESCRIPTION

This class translates pod documentation to DocBook format (only a section
mind you).

=head1 FUNCTIONS

	BEGIN()
	new($)
	begin_pod($)
	end_pod($)
	command($$$$$)
	verbatim($$$$)
	textblock($$$$)
	interior_sequence($$$$)
	TEST($)

=head1 FUNCTION DOCUMENTATION

=over 4

=item B<BEGIN()>

Performs initialization of various global stuff.

=item B<new($)>

Constructor for this class which initializes in_section to 0.

=item B<begin_pod($)>

This method overrides the base classes begin_pod method to handle begining
of the process.

=item B<end_pod($)>

This method overrides the base classes end_pod method to handle end of
the process.

=item B<command($$$$$)>

This method overrides the base classes command method to handle commands.

=item B<verbatim($$$$)>

This method overrides the base classes verbatim method to handle verbatims.

=item B<textblock($$$$)>

This method overrides the base classes textblock method to handle textblocks.

=item B<interior_sequence($$$$)>

This method overrides the base classes interior_sequence method ot handle
interior sequences.

=item B<TEST($)>

Test suite for this module.
Currently does nothing.

=back

=head1 SUPER CLASSES

Pod::Parser(3)

=head1 BUGS

None.

=head1 AUTHOR

	Name: Mark Veltzer
	Email: mailto:veltzer@cpan.org
	WWW: http://www.veltzer.org
	CPAN id: VELTZER

=head1 HISTORY

	0.00 MV perl documentation
	0.01 MV more perl quality
	0.02 MV perl qulity code
	0.03 MV more perl code quality
	0.04 MV revision change
	0.05 MV pictures in docbooks
	0.06 MV languages.pl test online
	0.07 MV perl packaging
	0.08 MV md5 project
	0.09 MV database
	0.10 MV perl module versions in files
	0.11 MV movies and small fixes
	0.12 MV thumbnail user interface
	0.13 MV more thumbnail issues
	0.14 MV website construction
	0.15 MV web site automation
	0.16 MV SEE ALSO section fix
	0.17 MV md5 issues

=head1 SEE ALSO

Meta::Class::MethodMaker(3), Meta::Utils::Output(3), Pod::Parser(3), strict(3)

=head1 TODO

-handle S/Z/E tags in sequences.

-handle id's in hyper links.
