# -*- cperl -*-
# ABSTRACT: LaTeX arrow object


package SpeL::Object::Arrow;

use parent 'Exporter';
use Carp;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ], [ 'self' ] );
  $self->{Op} =~ /^\\Rightarrow$/ and 
      return ' ' . $SpeL::I18n::lh->maketext( '==>' ) . ' ';
  $self->{Op} =~ /^\\Leftarrow$/ and 
      return ' ' . $SpeL::I18n::lh->maketext( '<==' ) . ' ';
  $self->{Op} =~ /^\\Leftrightarrow$/ and 
    return ' ' . $SpeL::I18n::lh->maketext( '<=>' ) . ' ';
  return "Error: don't know how to read this arrow";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Arrow - LaTeX arrow object

=head1 VERSION

version 20240619.0646

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX arrow

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
