# NAME

Sisimai - Mail Analyzing Interface for bounce mails.

# SYNOPSIS

    use Sisimai;

# DESCRIPTION

Sisimai is the system formerly known as `bounceHammer` 4, is a Pelr module for
analyzing bounce mails and generate structured data in a JSON format (YAML is 
also available if "YAML" module is installed on your system) from parsed bounce
messages. `Sisimai` is a coined word: Sisi (the number 4 is pronounced "Si" in
Japanese) and MAI (acronym of "Mail Analyzing Interface").

# BASIC USAGE

`make` method provides feature for getting parsed data from bounced email 
messages like following.

    use Sisimai;
    my $v = Sisimai->make( '/path/to/mbox' );   # or Path to Maildir

    if( defined $v ) {
        for my $e ( @$v ) {
            print ref $e;                   # Sisimai::Data
            print ref $e->recipient;        # Sisimai::Address
            print ref $e->timestamp;        # Sisimai::Time

            print $e->addresser->address;   # shironeko@example.org # From
            print $e->recipient->address;   # kijitora@example.jp   # To
            print $e->recipient->host;      # example.jp
            print $e->deliverystatus;       # 5.1.1
            print $e->reason;               # userunknown

            my $h = $e->damn;               # Convert to HASH reference
            my $j = $e->dump('json');       # Convert to JSON string
            my $y = $e->dump('yaml');       # Convert to YAML string
        }

        # Dump entire list as a JSON 
        use JSON '-convert_blessed_universally';
        my $json = JSON->new->allow_blessed->convert_blessed;

        printf "%s\n", $json->encode( $v );
    }

# SEE ALSO

[Sisimai::Mail](https://metacpan.org/pod/Sisimai::Mail) - Mailbox or Maildir object
[Sisimai::Data](https://metacpan.org/pod/Sisimai::Data) - Parsed data object

# REPOSITORY

[https://github.com/azumakuniyuki/p5-Sisimai](https://github.com/azumakuniyuki/p5-Sisimai) - Sisimai on GitHub

# AUTHOR

azumakuniyuki

# COPYRIGHT

Copyright (C) 2014-2015 azumakuniyuki <perl.org@azumakuniyuki.org>,
All Rights Reserved.

# LICENSE

This software is distributed under The BSD 2-Clause License.
