/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.Serializable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.ItemType;

public class RoleLocator
implements Serializable {
    private int kind;
    private Object operation;
    private int operand;
    private String errorCode = "XPTY0004";
    public static final int FUNCTION = 0;
    public static final int BINARY_EXPR = 1;
    public static final int TYPE_OP = 2;
    public static final int VARIABLE = 3;
    public static final int INSTRUCTION = 4;
    public static final int FUNCTION_RESULT = 5;
    public static final int ORDER_BY = 6;
    public static final int TEMPLATE_RESULT = 7;
    public static final int PARAM = 8;
    public static final int UNARY_EXPR = 9;
    public static final int UPDATING_EXPR = 10;
    public static final int GROUPING_KEY = 11;
    public static final int EVALUATE_RESULT = 12;
    public static final int CONTEXT_ITEM = 13;

    public RoleLocator(int kind, Object operation, int operand) {
        if (!(operation instanceof String) && !(operation instanceof StructuredQName)) {
            throw new IllegalArgumentException("operation");
        }
        this.kind = kind;
        this.operation = operation;
        this.operand = operand;
    }

    public void setErrorCode(String code) {
        if (code != null) {
            this.errorCode = code;
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        String name = this.operation instanceof String ? (String)this.operation : ((StructuredQName)this.operation).getDisplayName();
        switch (this.kind) {
            case 0: {
                if (name.equals("saxon:call")) {
                    if (this.operand == 0) {
                        return "target of dynamic function call";
                    }
                    return RoleLocator.ordinal(this.operand) + " argument of dynamic function call";
                }
                return RoleLocator.ordinal(this.operand + 1) + " argument of " + (name.length() == 0 ? "anonymous function" : name + "()");
            }
            case 1: {
                return RoleLocator.ordinal(this.operand + 1) + " operand of '" + name + '\'';
            }
            case 9: {
                return "operand of '-'";
            }
            case 2: {
                return "value in '" + name + "' expression";
            }
            case 3: {
                return "value of variable $" + name;
            }
            case 4: {
                int slash = name.indexOf(47);
                String attributeName = "";
                if (slash >= 0) {
                    attributeName = name.substring(slash + 1);
                    name = name.substring(0, slash);
                }
                return '@' + attributeName + " attribute of " + name;
            }
            case 5: {
                if (name.length() == 0) {
                    return "result of anonymous function";
                }
                return "result of function " + name + "()";
            }
            case 7: {
                return "result of template " + name;
            }
            case 6: {
                return RoleLocator.ordinal(this.operand + 1) + " sort key";
            }
            case 8: {
                return "value of parameter $" + name;
            }
            case 10: {
                return "value of " + RoleLocator.ordinal(this.operand + 1) + " operand of " + name + " expression";
            }
            case 11: {
                return "value of the grouping key";
            }
            case 12: {
                return "result of the expression {" + name + "} evaluated by xsl:evaluate";
            }
            case 13: {
                return "the context item";
            }
        }
        return "";
    }

    public String composeRequiredMessage(ItemType requiredItemType, NamePool pool) {
        return "Required item type of " + this.getMessage() + " is " + requiredItemType.toString(pool);
    }

    public String composeErrorMessage(ItemType requiredItemType, ItemType suppliedItemType, NamePool pool) {
        return "Required item type of " + this.getMessage() + " is " + requiredItemType.toString(pool) + "; supplied value has item type " + suppliedItemType.toString(pool);
    }

    public static String ordinal(int n) {
        switch (n) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
        }
        return n + "th";
    }
}

