# Generated by default/object.tt
package Paws::SageMaker::S3StorageConfig;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has ResolvedOutputS3Uri => (is => 'ro', isa => 'Str');
  has S3Uri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::S3StorageConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::S3StorageConfig object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., S3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::S3StorageConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

The Amazon Simple Storage (Amazon S3) location and and security
configuration for C<OfflineStore>.

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

The Amazon Web Services Key Management Service (KMS) key ID of the key
used to encrypt any objects written into the C<OfflineStore> S3
location.

The IAM C<roleARN> that is passed as a parameter to
C<CreateFeatureGroup> must have below permissions to the C<KmsKeyId>:

=over

=item *

C<"kms:GenerateDataKey">

=back



=head2 ResolvedOutputS3Uri => Str

The S3 path where offline records are written.


=head2 B<REQUIRED> S3Uri => Str

The S3 URI, or location in Amazon S3, of C<OfflineStore>.

S3 URIs have a format similar to the following:
C<s3://example-bucket/prefix/>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

