use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale::Object');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 16;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	ok( $obj = String::Locale::Object->new(),
		q{$obj = String::Locale::Object->new()}
	);
	isa_ok( $obj, 'String::Locale::Object' );
	ok( $obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => 'aporia',
				fb      => 'algea'
			}
		),
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => { 'test' => 'test' } }, locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => [] },
				locale  => 'aporia',
				fb      => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => [] }, locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => 'hypnos' },
				locale  => 'aporia',
				fb      => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => 'hypnos' }, locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => undef },
				locale  => 'aporia',
				fb      => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => undef }, locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locales => [], locale => 'aporia', fb => 'algea' } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => [], locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locales => 'gaudia', locale => 'aporia', fb => 'algea' } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => 'gaudia', locale => 'aporia', fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => [],
				fb      => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => { 'test' => 'test' } }, locale => [], fb => 'algea' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => \1,
				fb      => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => { 'test' => 'test' } }, locale => \1, fb => 'algea' })}
	);
	ok( $obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => 'aporia'
			}
		),
		q{$obj = String::Locale::Object->new({locales => { 'gaudia' => { 'test' => 'test' } }, locale => 'aporia'})}
	);
	ok( $obj = String::Locale::Object->new(
			locales => { 'gaudia' => { 'test' => 'test' } },
			locale  => 'aporia'
		),
		q{$obj = String::Locale::Object->new(locales => { 'gaudia' => { 'test' => 'test' } }, locale => 'aporia')}
	);
	is_deeply( $obj->fb, 'en', q{$obj->fb} );
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => 'aporia',
				fb      => []
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => { 'test' => 'test' } }, locale => 'aporia', fb => [] })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locales => { 'gaudia' => { 'test' => 'test' } },
				locale  => 'aporia',
				fb      => \1
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locales => { 'gaudia' => { 'test' => 'test' } }, locale => 'aporia', fb => \1 })}
	);
};
subtest 'has fb' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'fb' );
	is_deeply( $obj->fb('nosoi'), 'nosoi', q{$obj->fb('nosoi')} );
	eval { $obj->fb( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb([])} );
	eval { $obj->fb( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb(\1)} );
	is_deeply( $obj->fb, 'nosoi', q{$obj->fb} );
};
subtest 'has locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locale' );
	is_deeply( $obj->locale('nosoi'), 'nosoi', q{$obj->locale('nosoi')} );
	eval { $obj->locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale([])} );
	eval { $obj->locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale(\1)} );
	is_deeply( $obj->locale, 'nosoi', q{$obj->locale} );
};
subtest '_build_locale' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locale' );
	eval { $obj->_build_locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale([])} );
	eval { $obj->_build_locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale(\1)} );
};
subtest '_set_language_from_locale' => sub {
	plan tests => 5;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_set_language_from_locale' );
	eval { $obj->_set_language_from_locale( [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale([])}
	);
	eval { $obj->_set_language_from_locale( \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale(\1)}
	);
	eval { $obj->_set_language_from_locale() };
	like( $@, qr/undef/, q{$obj->_set_language_from_locale()} );
};
subtest 'has language' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'language' );
	eval { $obj->language( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language([])} );
	eval { $obj->language( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language(\1)} );
};
subtest 'has_language' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'has_language' );
	ok( do { delete $obj->{language}; 1; },
		q{do{ delete $obj->{language}; 1;}}
	);
	is( $obj->has_language, '', q{$obj->has_language} );
	is_deeply( $obj->language('nosoi'), 'nosoi', q{$obj->language('nosoi')} );
	is( $obj->has_language, 1, q{$obj->has_language} );
};
subtest 'has locales' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locales' );
	is_deeply(
		$obj->locales( { 'penthos' => { 'test' => 'test' } } ),
		{ 'penthos' => { 'test' => 'test' } },
		q{$obj->locales({ 'penthos' => { 'test' => 'test' } })}
	);
	eval { $obj->locales( { 'penthos' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => [] })}
	);
	eval { $obj->locales( { 'penthos' => 'curae' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => 'curae' })}
	);
	eval { $obj->locales( { 'penthos' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => undef })}
	);
	eval { $obj->locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales([])} );
	eval { $obj->locales('nosoi') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales('nosoi')} );
	is_deeply( $obj->locales, { 'penthos' => { 'test' => 'test' } },
		q{$obj->locales} );
};
subtest '_build_locales' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locales' );
	eval { $obj->_build_locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales([])} );
	eval { $obj->_build_locales('hypnos') };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales('hypnos')}
	);
};
subtest 'convert_locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'convert_locale' );
	eval { $obj->convert_locale( [], 'phobos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale([], 'phobos')}
	);
	eval { $obj->convert_locale( \1, 'phobos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale(\1, 'phobos')}
	);
	eval { $obj->convert_locale( 'geras', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('geras', [])}
	);
	eval { $obj->convert_locale( 'geras', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('geras', \1)}
	);
};
subtest 'add' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'add' );
	eval { $obj->add( [], { 'curae' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add([], { 'curae' => { 'test' => 'test' } })}
	);
	eval { $obj->add( \1, { 'curae' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add(\1, { 'curae' => { 'test' => 'test' } })}
	);
	eval { $obj->add( 'aporia', { 'curae' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('aporia', { 'curae' => [] })}
	);
	eval { $obj->add( 'aporia', { 'curae' => 'geras' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('aporia', { 'curae' => 'geras' })}
	);
	eval { $obj->add( 'aporia', { 'curae' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('aporia', { 'curae' => undef })}
	);
	eval { $obj->add( 'aporia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('aporia', [])}
	);
	eval { $obj->add( 'aporia', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('aporia', 'limos')}
	);
};
subtest 'string' => sub {
	plan tests => 10;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'string' );
	eval { $obj->string( [], 'limos', 'curae', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string([], 'limos', 'curae', 'hypnos')}
	);
	eval { $obj->string( \1, 'limos', 'curae', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string(\1, 'limos', 'curae', 'hypnos')}
	);
	eval { $obj->string( 'curae', [], 'curae', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', [], 'curae', 'hypnos')}
	);
	eval { $obj->string( 'curae', \1, 'curae', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', \1, 'curae', 'hypnos')}
	);
	eval { $obj->string( 'curae', 'limos', [], 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'limos', [], 'hypnos')}
	);
	eval { $obj->string( 'curae', 'limos', \1, 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'limos', \1, 'hypnos')}
	);
	eval { $obj->string( 'curae', 'limos', 'curae', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'limos', 'curae', [])}
	);
	eval { $obj->string( 'curae', 'limos', 'curae', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'limos', 'curae', \1)}
	);
};
subtest 'DESTROY' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'DESTROY' );
};
subtest 'AUTOLOAD' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'AUTOLOAD' );
};
done_testing();
