/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.z.IntPredicate;

final class DescendantIterator
extends AxisIteratorImpl {
    private final TinyTree tree;
    private final TinyNodeImpl startNode;
    private int nextNodeNr;
    private final int startDepth;
    private final NodeTest test;
    private final IntPredicate matcher;

    DescendantIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.tree = doc;
        this.startNode = node;
        this.test = nodeTest;
        this.nextNodeNr = node.nodeNr;
        this.startDepth = doc.depth[this.nextNodeNr];
        this.matcher = nodeTest.getMatcher(doc);
    }

    public NodeInfo next() {
        do {
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] <= this.startDepth) {
                    this.nextNodeNr = -1;
                    return null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextNodeNr = -1;
                return null;
            }
        } while (!this.matcher.matches(this.nextNodeNr));
        return this.tree.getNode(this.nextNodeNr);
    }
}

