#!perl

use 5.006;

use strict;
use warnings;

our $VERSION='0.06';

use Test::More;
use Benchmark qw/timethese cmpthese :hireswallclock/;

use GCC::Builtins qw/clz/;

my $num_repeats = 50000000;

print "$0 : benchmarks...\n";

# shamelessly ripped off App::Benchmark
cmpthese(
  timethese($num_repeats, {
	' clz/xs' => \&clz_xs,
	'clz/pp-ugly' => \&clz_pp_ugly,
  }),
);
print "KEY:\n"
 ." clz/xs : calling GCC builtin clz() via XS from Perl\n"
 ." clz/pp-ugly : as suggested by coldr3ality (see https://perlmonks.org/?node_id=11158279)\n"
;

plan tests => 1;
pass('benchmark : '.__FILE__);

sub clz_xs {
	my $m = clz(time-10);
}
sub clz_pp_ugly {
	my $z = time+10;
	my $m=-4294967296&$z? -281474976710656&$z? -72057594037927936&$z?
   -1152921504606846976&$z? -4611686018427387904&$z? -9223372036854775808&$z?
                  4611686018427387904:   2305843009213693952
    : -2305843009213693952&$z?
                  1152921504606846976:   576460752303423488
   : -288230376151711744&$z? -576460752303423488&$z?
                  288230376151711744:    144115188075855872
    : -144115188075855872&$z?
                  72057594037927936:     36028797018963968
  : -4503599627370496&$z? -18014398509481984&$z?   -36028797018963968&$z?
                  18014398509481984:     9007199254740992
    : -9007199254740992&$z?
                  4503599627370496:      2251799813685248
   : -1125899906842624&$z? -2251799813685248&$z?
                  1125899906842624:      562949953421312
    : -562949953421312&$z?
                  281474976710656:       140737488355328
 : -1099511627776&$z? -17592186044416&$z? -70368744177664&$z? -140737488355328&$z?
                  70368744177664:        35184372088832
    : -35184372088832&$z?
                  17592186044416:        8796093022208
   : -4398046511104&$z? -8796093022208&$z?
                  4398046511104:         2199023255552
    : -2199023255552&$z?
                  1099511627776:         549755813888
  : -68719476736&$z? -274877906944&$z? -549755813888&$z?
                  274877906944:          137438953472
    : -137438953472&$z?
                  68719476736:           34359738368
   : -17179869184&$z? -34359738368&$z?
                  17179869184:           8589934592
    : -8589934592&$z?
                  4294967296:            2147483648
: -65536&$z? -16777216&$z? -268435456&$z? -1073741824&$z? -2147483648&$z?
                  1073741824:            536870912
    : -536870912&$z?
                  268435456:             134217728
   : -67108864&$z? -134217728&$z?
                  67108864:              33554432
    : -33554432&$z?
                  16777216:              8388608
  : -1048576&$z? -4194304&$z? -8388608&$z?
                  4194304:               2097152
    : -2097152&$z?
                  1048576:               524288
   : -262144&$z? -524288&$z?
                  262144:                131072
    : -131072&$z?
                  65536:                 32768
 : -256&$z? -4096&$z? -16384&$z? -32768&$z?
                  16384:                 8192
    : -8192&$z?   4096:                  2048
   : -1024&$z? -2048&$z?
                  1024:                  512
    : -512&$z?    256:                   128
  : -16&$z? -64&$z? -128&$z?
                  64:                    32
    : -32&$z?     16:                    8
   : -4&$z? -8&$z?
                  4:                     2
    :             2                      ;
}

1;
__END__
