# WARNING: This file is autogenerated from Makefile.PL
# do not edit it, as all changes will be lost

local $| = 1;

use Test;

plan tests => 7;

ok 1;

use strict;
#use ExtUtils::testlib;

require GTop;

my $gtop = GTop->new;

ok $gtop;


my $cpu = $gtop->cpu();
print "# cpu\n";
for (qw(flags total user nice sys idle frequency)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $cpu->$x();
}


my $fsusage = $gtop->fsusage('/');
print "# fsusage\n";
for (qw(flags blocks bfree bavail files ffree)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $fsusage->$x();
}


my $loadavg = $gtop->loadavg();
print "# loadavg\n";
for (qw(flags nr_running nr_tasks last_pid)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $loadavg->$x();
}


my $mem = $gtop->mem();
print "# mem\n";
for (qw(flags total used free shared buffer cached user locked)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $mem->$x();
}


my $mountlist = $gtop->mountlist(1);
print "# mountlist\n";
for (qw(flags number total size)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $mountlist->$x();
}


my $netload = $gtop->netload('eth0');
print "# netload\n";
for (qw(flags if_flags mtu subnet address packets_in packets_out packets_total bytes_in bytes_out bytes_total errors_in errors_out errors_total collisions)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $netload->$x();
}


my $proc_args = $gtop->proc_args($$);
print "# proc_args\n";
for (qw(flags size)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_args->$x();
}


my $proc_map = $gtop->proc_map($$);
print "# proc_map\n";
for (qw(flags number total size)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_map->$x();
}


my $proc_mem = $gtop->proc_mem($$);
print "# proc_mem\n";
for (qw(flags size vsize resident share rss rss_rlim)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_mem->$x();
}


my $proc_segment = $gtop->proc_segment($$);
print "# proc_segment\n";
for (qw(flags text_rss shlib_rss data_rss stack_rss dirty_size start_code end_code start_stack)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_segment->$x();
}


my $proc_state = $gtop->proc_state($$);
print "# proc_state\n";
for (qw(flags)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_state->$x();
}


my $proc_time = $gtop->proc_time($$);
print "# proc_time\n";
for (qw(flags start_time rtime utime stime cutime cstime timeout it_real_value frequency)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_time->$x();
}


my $proc_uid = $gtop->proc_uid($$);
print "# proc_uid\n";
for (qw(flags uid:int euid:int gid:int egid:int pid:int ppid:int pgrp:int session:int tty:int tpgid:int priority:int nice:int)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proc_uid->$x();
}


my $proclist = $gtop->proclist();
print "# proclist\n";
for (qw(flags number total size)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $proclist->$x();
}


my $swap = $gtop->swap();
print "# swap\n";
for (qw(flags total used free pagein pageout)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $swap->$x();
}


my $uptime = $gtop->uptime();
print "# uptime\n";
for (qw(flags)) {
    (my $x = $_) =~ s/:\w+$//;
    printf "#   %s => %d\n", $x, $uptime->$x();
}

# XXX: need to do some real testing

# size_string testing
ok GTop::size_string(1_024),       "   1k";
ok GTop::size_string(1_924),       "   2k";
ok GTop::size_string(8_192),       "   8k";
ok GTop::size_string(1_148_576),   " 1.1M";
ok GTop::size_string(133_809_024), " 128M";

