/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;

public class PoolsHandler
implements HttpHandler {
    private final CouchbaseMock mock;

    public PoolsHandler(CouchbaseMock mock) {
        this.mock = mock;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getPath();
        OutputStream body = exchange.getResponseBody();
        String bucketName = exchange.getPrincipal().getName();
        boolean chunked = false;
        if (path.matches("^/pools/?$")) {
            byte[] payload = this.getPoolsJSON().getBytes();
            exchange.sendResponseHeaders(200, payload.length);
            body.write(payload);
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "$/?")) {
            StringWriter sw = new StringWriter();
            sw.append("{\"buckets\":{\"uri\":\"/pools/" + this.mock.getPoolName() + "/buckets\"}}");
            byte[] payload = sw.toString().getBytes();
            exchange.sendResponseHeaders(200, payload.length);
            body.write(payload);
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/buckets/?$")) {
            JSONArray buckets = new JSONArray();
            for (Bucket bucket : this.mock.getBuckets().values()) {
                if (!this.mock.getAuthenticator().getAdminName().equals(bucketName) && (!bucketName.isEmpty() || !bucket.getPassword().isEmpty()) && !bucket.getName().equals(bucketName)) continue;
                buckets.add(JSONObject.fromObject(bucket.getJSON()));
            }
            byte[] payload = buckets.toString().getBytes();
            exchange.sendResponseHeaders(200, payload.length);
            body.write(payload);
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/buckets/[^/]+/?$")) {
            String[] tokens = path.split("/");
            Bucket bucket = this.mock.getBuckets().get(tokens[tokens.length - 1]);
            byte[] payload = bucket.getJSON().getBytes();
            exchange.sendResponseHeaders(200, payload.length);
            body.write(payload);
        } else if (path.matches("^/pools/" + this.mock.getPoolName() + "/bucketsStreaming/[^/]+/?$")) {
            String[] tokens = path.split("/");
            Bucket bucket = this.mock.getBuckets().get(tokens[tokens.length - 1]);
            if (bucket != null) {
                exchange.sendResponseHeaders(200, 0L);
                chunked = true;
                byte[] data = bucket.getJSON().getBytes();
                body.write(data);
                body.write("\n\n\n\n".getBytes());
                body.flush();
                CountDownLatch completed = new CountDownLatch(1);
                CouchbaseMock.HarakiriMonitor monitor = this.mock.getMonitor();
                if (monitor != null) {
                    ConfigObserver observer = new ConfigObserver(bucket, body, completed);
                    monitor.addObserver(observer);
                }
                try {
                    completed.await();
                }
                catch (InterruptedException ex) {
                    exchange.sendResponseHeaders(500, -1L);
                }
            } else {
                exchange.sendResponseHeaders(404, -1L);
            }
        } else {
            exchange.sendResponseHeaders(404, -1L);
        }
        if (!chunked) {
            body.close();
        }
    }

    protected String getPoolsJSON() {
        HashMap<String, String> pools = new HashMap<String, String>();
        pools.put("name", this.mock.getPoolName());
        pools.put("uri", "/pools/" + this.mock.getPoolName());
        pools.put("streamingUri", "/poolsStreaming/" + this.mock.getPoolName());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("pools", pools);
        map.put("isAdminCreds", Boolean.TRUE);
        return JSONObject.fromObject(map).toString();
    }

    private class ConfigObserver
    implements Observer {
        private final OutputStream output;
        private final Bucket bucket;
        private final CountDownLatch complete;

        public ConfigObserver(Bucket bucket, OutputStream output, CountDownLatch complete) {
            this.bucket = bucket;
            this.output = output;
            this.complete = complete;
        }

        @Override
        public void update(Observable o, Object arg) {
            try {
                byte[] data = this.bucket.getJSON().getBytes();
                int n = data.length;
                this.output.write(data);
                this.output.write("\n\n\n\n".getBytes());
                this.output.flush();
            }
            catch (IOException ex) {
                o.deleteObserver(this);
                this.complete.countDown();
            }
        }
    }
}

