/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.examples.ExampleUtils;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class ReadLargeEncryptedMail {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.err.println("usage: ReadLargeEncryptedMail pkcs12Keystore password outputFile");
            System.exit(0);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
        String string = ExampleUtils.findKeyAlias(keyStore, stringArray[0], stringArray[1].toCharArray());
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        RecipientId recipientId = new RecipientId();
        recipientId.setSerialNumber(x509Certificate.getSerialNumber());
        recipientId.setIssuer(x509Certificate.getIssuerX500Principal().getEncoded());
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new SharedFileInputStream("encrypted.message"));
        SMIMEEnvelopedParser sMIMEEnvelopedParser = new SMIMEEnvelopedParser(mimeMessage);
        RecipientInformationStore recipientInformationStore = sMIMEEnvelopedParser.getRecipientInfos();
        RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
        FileBackedMimeBodyPart fileBackedMimeBodyPart = SMIMEUtil.toMimeBodyPart(recipientInformation.getContentStream(keyStore.getKey(string, null), "BC"));
        ExampleUtils.dumpContent(fileBackedMimeBodyPart, stringArray[2]);
    }
}

