/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.flac;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.gagravarr.flac.FlacNativeFile;
import org.gagravarr.flac.FlacOggFile;
import org.gagravarr.flac.FlacTags;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacketReader;

public class TestFlacComments
extends TestCase {
    private InputStream getTestOggFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testFLAC.oga");
    }

    private InputStream getTestFlacFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testFLAC.flac");
    }

    public void testReadOgg() throws IOException {
        OggFile ogg = new OggFile(this.getTestOggFile());
        OggPacketReader r = ogg.getPacketReader();
        r.getNextPacket();
        FlacTags tags = new FlacTags(r.getNextPacket());
        this.doTestComments(tags);
        ogg = new OggFile(this.getTestOggFile());
        FlacOggFile flac = new FlacOggFile(ogg);
        this.doTestComments(flac.getTags());
    }

    public void testReadFlac() throws IOException {
        FlacNativeFile flac = new FlacNativeFile(this.getTestFlacFile());
        this.doTestComments(flac.getTags());
    }

    private void doTestComments(FlacTags tags) {
        TestFlacComments.assertEquals((String)"reference libFLAC 1.2.1 20070917", (String)tags.getVendor());
        TestFlacComments.assertEquals((int)7, (int)tags.getAllComments().size());
        TestFlacComments.assertEquals((String)"Test Title", (String)tags.getTitle());
        TestFlacComments.assertEquals((int)1, (int)tags.getComments("TiTlE").size());
        TestFlacComments.assertEquals((String)"Test Title", (String)tags.getComments("tItLe").get(0));
        TestFlacComments.assertEquals((String)"Test Artist", (String)tags.getArtist());
        TestFlacComments.assertEquals((int)1, (int)tags.getComments("ArTiSt").size());
        TestFlacComments.assertEquals((String)"Test Artist", (String)tags.getComments("aRTiST").get(0));
        TestFlacComments.assertEquals((String)"Test Genre", (String)tags.getGenre());
        TestFlacComments.assertEquals((int)1, (int)tags.getComments("GEnRE").size());
        TestFlacComments.assertEquals((String)"Test Genre", (String)tags.getComments("genRE").get(0));
        TestFlacComments.assertEquals((String)"Test Album", (String)tags.getAlbum());
        TestFlacComments.assertEquals((int)1, (int)tags.getComments("alBUm").size());
        TestFlacComments.assertEquals((String)"Test Album", (String)tags.getComments("ALbUM").get(0));
        TestFlacComments.assertEquals((int)1, (int)tags.getComments("DAte").size());
        TestFlacComments.assertEquals((String)"2010-01-26", (String)tags.getComments("dAtE").get(0));
        TestFlacComments.assertEquals((int)2, (int)tags.getComments("COmmENT").size());
        TestFlacComments.assertEquals((String)"Test Comment", (String)tags.getComments("COMMent").get(0));
        TestFlacComments.assertEquals((String)"Another Test Comment", (String)tags.getComments("COMMent").get(1));
    }
}

