/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static String join(@NotNull Iterable<? extends CharSequence> strings, @NotNull String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        Iterator<? extends CharSequence> iter = strings.iterator();
        if (iter.hasNext()) {
            capacity += iter.next().length() + delimLength;
        }
        StringBuilder buffer = new StringBuilder(capacity);
        iter = strings.iterator();
        if (iter.hasNext()) {
            buffer.append(iter.next());
            while (iter.hasNext()) {
                buffer.append(delimiter);
                buffer.append(iter.next());
            }
        }
        return buffer.toString();
    }

    public static <T extends CharSequence> String join(@NotNull T[] strings, @NotNull String delimiter) {
        int capacity = 0;
        int delimLength = delimiter.length();
        for (T value : strings) {
            capacity += value.length() + delimLength;
        }
        StringBuilder buffer = new StringBuilder(capacity);
        boolean first = true;
        for (T value : strings) {
            if (!first) {
                buffer.append(delimiter);
            } else {
                first = false;
            }
            buffer.append((CharSequence)value);
        }
        return buffer.toString();
    }
}

