/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;

public class Age {
    private int _years;
    private int _months;
    private int _days;
    private int _hours;
    private int _minutes;
    private int _seconds;

    @Nullable
    public static Age fromPanasonicString(@NotNull String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() != 19 || s.startsWith("9999:99:99")) {
            return null;
        }
        try {
            int years = Integer.parseInt(s.substring(0, 4));
            int months = Integer.parseInt(s.substring(5, 7));
            int days = Integer.parseInt(s.substring(8, 10));
            int hours = Integer.parseInt(s.substring(11, 13));
            int minutes = Integer.parseInt(s.substring(14, 16));
            int seconds = Integer.parseInt(s.substring(17, 19));
            return new Age(years, months, days, hours, minutes, seconds);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public Age(int years, int months, int days, int hours, int minutes, int seconds) {
        this._years = years;
        this._months = months;
        this._days = days;
        this._hours = hours;
        this._minutes = minutes;
        this._seconds = seconds;
    }

    public int getYears() {
        return this._years;
    }

    public int getMonths() {
        return this._months;
    }

    public int getDays() {
        return this._days;
    }

    public int getHours() {
        return this._hours;
    }

    public int getMinutes() {
        return this._minutes;
    }

    public int getSeconds() {
        return this._seconds;
    }

    public String toString() {
        return String.format("%04d:%02d:%02d %02d:%02d:%02d", this._years, this._months, this._days, this._hours, this._minutes, this._seconds);
    }

    public String toFriendlyString() {
        StringBuilder result = new StringBuilder();
        Age.appendAgePart(result, this._years, "year");
        Age.appendAgePart(result, this._months, "month");
        Age.appendAgePart(result, this._days, "day");
        Age.appendAgePart(result, this._hours, "hour");
        Age.appendAgePart(result, this._minutes, "minute");
        Age.appendAgePart(result, this._seconds, "second");
        return result.toString();
    }

    private static void appendAgePart(StringBuilder result, int num, String singularName) {
        if (num == 0) {
            return;
        }
        if (result.length() != 0) {
            result.append(' ');
        }
        result.append(num).append(' ').append(singularName);
        if (num != 1) {
            result.append('s');
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Age age = (Age)o;
        if (this._days != age._days) {
            return false;
        }
        if (this._hours != age._hours) {
            return false;
        }
        if (this._minutes != age._minutes) {
            return false;
        }
        if (this._months != age._months) {
            return false;
        }
        if (this._seconds != age._seconds) {
            return false;
        }
        return this._years == age._years;
    }

    public int hashCode() {
        int result = this._years;
        result = 31 * result + this._months;
        result = 31 * result + this._days;
        result = 31 * result + this._hours;
        result = 31 * result + this._minutes;
        result = 31 * result + this._seconds;
        return result;
    }
}

