/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisFile;

public class TestVorbisFileRead
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    public void testRead() throws IOException {
        OggFile ogg = new OggFile(this.getTestFile());
        VorbisFile vf = new VorbisFile(ogg);
        TestVorbisFileRead.assertEquals((int)2, (int)vf.getInfo().getChannels());
        TestVorbisFileRead.assertEquals((long)44100L, (long)vf.getInfo().getRate());
        TestVorbisFileRead.assertEquals((int)0, (int)vf.getInfo().getBitrateLower());
        TestVorbisFileRead.assertEquals((int)0, (int)vf.getInfo().getBitrateUpper());
        TestVorbisFileRead.assertEquals((int)80000, (int)vf.getInfo().getBitrateNominal());
        TestVorbisFileRead.assertEquals((String)"Test Title", (String)vf.getComment().getTitle());
        TestVorbisFileRead.assertEquals((String)"Test Artist", (String)vf.getComment().getArtist());
        TestVorbisFileRead.assertEquals((int)3484, (int)vf.getSetup().getData().length);
        TestVorbisFileRead.assertNotNull((Object)vf.getNextAudioPacket());
        TestVorbisFileRead.assertNotNull((Object)vf.getNextAudioPacket());
        TestVorbisFileRead.assertNotNull((Object)vf.getNextAudioPacket());
        TestVorbisFileRead.assertNotNull((Object)vf.getNextAudioPacket());
        VorbisAudioData ad = vf.getNextAudioPacket();
        TestVorbisFileRead.assertEquals((long)960L, (long)ad.getGranulePosition());
    }
}

