/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis;

import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisComments;
import org.gagravarr.vorbis.VorbisInfo;
import org.gagravarr.vorbis.VorbisSetup;

public abstract class VorbisPacket
extends HighLevelOggStreamPacket {
    public static final int TYPE_INFO = 1;
    public static final int TYPE_COMMENTS = 3;
    public static final int TYPE_SETUP = 5;
    protected static final int HEADER_LENGTH_METADATA = 7;
    protected static final int HEADER_LENGTH_AUDIO = 0;

    protected VorbisPacket(OggPacket oggPacket) {
        super(oggPacket);
    }

    protected VorbisPacket() {
    }

    protected abstract int getHeaderSize();

    protected void populateMetadataHeader(byte[] b, int type, int dataLength) {
        b[0] = IOUtils.fromInt(type);
        b[1] = 118;
        b[2] = 111;
        b[3] = 114;
        b[4] = 98;
        b[5] = 105;
        b[6] = 115;
    }

    public static boolean isVorbisStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return VorbisPacket.isVorbisSpecial(firstPacket);
    }

    private static boolean isVorbisSpecial(OggPacket packet) {
        byte[] d;
        byte type = packet.getData()[0];
        return (type == 1 || type == 3 || type == 5) && (d = packet.getData())[1] == 118 && d[2] == 111 && d[3] == 114 && d[4] == 98 && d[5] == 105 && d[6] == 115;
    }

    public static VorbisPacket create(OggPacket packet) {
        byte type = packet.getData()[0];
        if (VorbisPacket.isVorbisSpecial(packet)) {
            switch (type) {
                case 1: {
                    return new VorbisInfo(packet);
                }
                case 3: {
                    return new VorbisComments(packet);
                }
                case 5: {
                    return new VorbisSetup(packet);
                }
            }
        }
        return new VorbisAudioData(packet);
    }
}

