/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog.DataFormatType;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.AccessElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

class AccessElementParser
extends AbstractElementParser {
    private final DatasetBuilder parentDatasetBuilder;
    private AccessBuilder selfBuilder;

    private AccessElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetBuilder parentDatasetBuilder) {
        super(elementName, reader, builderFactory);
        this.parentDatasetBuilder = parentDatasetBuilder;
    }

    AccessBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    void parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        if (this.parentDatasetBuilder == null) {
            throw new ThreddsXmlParserException("");
        }
        this.selfBuilder = this.parentDatasetBuilder.addAccessBuilder();
        Attribute serviceNameAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_ServiceName);
        if (serviceNameAtt != null) {
            String serviceName = serviceNameAtt.getValue();
            ServiceBuilder serviceBuilder = this.parentDatasetBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(serviceName);
            this.selfBuilder.setServiceBuilder(serviceBuilder);
        }
        Attribute urlPathAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_UrlPath);
        String urlPath = urlPathAtt.getValue();
        this.selfBuilder.setUrlPath(urlPath);
        Attribute dataFormatAtt = startElement.getAttributeByName(AccessElementNames.AccessElement_DataFormat);
        if (dataFormatAtt != null) {
            this.selfBuilder.setDataFormat(DataFormatType.getType(dataFormatAtt.getValue()));
        }
    }

    void handleChildStartElement() throws ThreddsXmlParserException {
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
    }

    static class Factory {
        private QName elementName = AccessElementNames.AccessElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        AccessElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetBuilder parentDatasetBuilder) {
            return new AccessElementParser(this.elementName, reader, builderFactory, parentDatasetBuilder);
        }
    }
}

