/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class CLibImageWriter
extends ImageWriter {
    /*
     * WARNING - void declaration
     */
    private static final Object getDataBufferData(DataBuffer db) {
        void var1_2;
        int dType = db.getDataType();
        switch (dType) {
            case 0: {
                Object[] data = ((DataBufferByte)db).getData();
                break;
            }
            case 1: {
                Object[] data = ((DataBufferUShort)db).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dType);
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getMediaLibDataType(int dataType) {
        void var1_1;
        switch (dataType) {
            case 0: {
                int mlibType = 1;
                break;
            }
            case 1: {
                int mlibType = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dataType);
            }
        }
        return (int)var1_1;
    }

    private static final int getMediaLibFormat(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int mlibFormat = 0;
        if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getNumBands() == 4 && colorModel != null && colorModel.hasAlpha()) {
            int[] masks = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            if (masks[3] == -16777216) {
                if (masks[0] == 255 && masks[1] == 65280 && masks[2] == 0xFF0000) {
                    mlibFormat = 8;
                } else if (masks[0] == 0xFF0000 && masks[1] == 65280 && masks[2] == 255) {
                    mlibFormat = 7;
                }
            }
        } else if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            int[] bandOffsets = csm.getBandOffsets();
            int pixelStride = csm.getPixelStride();
            if (pixelStride == bandOffsets.length) {
                int numBands = pixelStride;
                boolean hasOneBank = true;
                int[] bankIndices = csm.getBankIndices();
                for (int i = 1; i < bankIndices.length; ++i) {
                    if (bankIndices[i] == bankIndices[0]) continue;
                    hasOneBank = false;
                }
                if (hasOneBank) {
                    int csType;
                    if (colorModel instanceof IndexColorModel) {
                        mlibFormat = 1;
                    } else if (numBands == 1) {
                        mlibFormat = 2;
                    } else if (numBands == 2 && bandOffsets[0] == 0 && bandOffsets[1] == 1) {
                        mlibFormat = 9;
                    } else if (numBands == 3) {
                        int n = csType = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (csType == 5) {
                            if (bandOffsets[0] == 2 && bandOffsets[1] == 1 && bandOffsets[2] == 0) {
                                mlibFormat = 4;
                            } else if (bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2) {
                                mlibFormat = 3;
                            }
                        } else if (csType == 4 && bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2) {
                            mlibFormat = 12;
                        }
                    } else if (numBands == 4) {
                        int n = csType = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (csType == 5) {
                            if (bandOffsets[3] == 0) {
                                if (bandOffsets[0] == 3 && bandOffsets[1] == 2 && bandOffsets[2] == 1) {
                                    mlibFormat = 6;
                                } else if (bandOffsets[0] == 1 && bandOffsets[1] == 2 && bandOffsets[2] == 3) {
                                    mlibFormat = 5;
                                }
                            } else if (bandOffsets[3] == 3) {
                                if (bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2) {
                                    mlibFormat = 10;
                                } else if (bandOffsets[0] == 2 && bandOffsets[1] == 1 && bandOffsets[2] == 0) {
                                    mlibFormat = 15;
                                }
                            }
                        } else if (csType == 9 && bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2 && bandOffsets[3] == 3) {
                            mlibFormat = 11;
                        } else if (csType == 4 && bandOffsets[0] == 0 && bandOffsets[1] == 1 && bandOffsets[2] == 2 && bandOffsets[3] == 3) {
                            mlibFormat = colorModel != null && colorModel.hasAlpha() ? 13 : 14;
                        }
                    }
                }
            }
        }
        return mlibFormat;
    }

    private static final Raster getContiguousData(RenderedImage im, Rectangle region) {
        Raster raster;
        if (im == null) {
            throw new IllegalArgumentException("im == null");
        }
        if (region == null) {
            throw new IllegalArgumentException("region == null");
        }
        if (im.getNumXTiles() == 1 && im.getNumYTiles() == 1) {
            raster = im.getTile(im.getMinTileX(), im.getMinTileY());
            Rectangle bounds = raster.getBounds();
            if (!bounds.equals(region)) {
                raster = raster.createChild(region.x, region.y, region.width, region.height, region.x, region.y, null);
            }
        } else {
            SampleModel sampleModel = im.getSampleModel();
            WritableRaster target = sampleModel.getSampleSize(0) == 8 ? Raster.createInterleavedRaster(0, im.getWidth(), im.getHeight(), sampleModel.getNumBands(), new Point(im.getMinX(), im.getMinY())) : null;
            raster = im.copyData(target);
        }
        return raster;
    }

    private static void reformat(Raster source, int[] sourceBands, int subsampleX, int subsampleY, WritableRaster dst) {
        if (source == null) {
            throw new IllegalArgumentException("source == null!");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst == null!");
        }
        Rectangle sourceBounds = source.getBounds();
        if (sourceBounds.isEmpty()) {
            throw new IllegalArgumentException("source.getBounds().isEmpty()!");
        }
        boolean isSubBanding = false;
        int numSourceBands = source.getSampleModel().getNumBands();
        if (sourceBands != null) {
            if (sourceBands.length > numSourceBands) {
                throw new IllegalArgumentException("sourceBands.length > numSourceBands!");
            }
            boolean isRamp = sourceBands.length == numSourceBands;
            for (int i = 0; i < sourceBands.length; ++i) {
                if (sourceBands[i] < 0 || sourceBands[i] >= numSourceBands) {
                    throw new IllegalArgumentException("sourceBands[i] < 0 || sourceBands[i] >= numSourceBands!");
                }
                if (sourceBands[i] == i) continue;
                isRamp = false;
            }
            isSubBanding = !isRamp;
        }
        int sourceWidth = sourceBounds.width;
        int[] pixels = new int[sourceWidth * numSourceBands];
        int sourceX = sourceBounds.x;
        int sourceY = sourceBounds.y;
        int numBands = sourceBands != null ? sourceBands.length : numSourceBands;
        int dstWidth = dst.getWidth();
        int dstYMax = dst.getHeight() - 1;
        int copyFromIncrement = numSourceBands * subsampleX;
        for (int dstY = 0; dstY <= dstYMax; ++dstY) {
            int i;
            int copyTo;
            int copyFrom;
            source.getPixels(sourceX, sourceY, sourceWidth, 1, pixels);
            if (isSubBanding) {
                copyFrom = 0;
                copyTo = 0;
                for (i = 0; i < dstWidth; ++i) {
                    for (int j = 0; j < numBands; ++j) {
                        pixels[copyTo++] = pixels[copyFrom + sourceBands[j]];
                    }
                    copyFrom += copyFromIncrement;
                }
            } else {
                copyFrom = copyFromIncrement;
                copyTo = numSourceBands;
                for (i = 1; i < dstWidth; ++i) {
                    int k = copyFrom;
                    for (int j = 0; j < numSourceBands; ++j) {
                        pixels[copyTo++] = pixels[k++];
                    }
                    copyFrom += copyFromIncrement;
                }
            }
            dst.setPixels(0, dstY, dstWidth, 1, pixels);
            sourceY += subsampleY;
        }
    }

    protected CLibImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    private static final Rectangle getSourceRegion(ImageWriteParam param, int sourceMinX, int sourceMinY, int srcWidth, int srcHeight) {
        Rectangle sourceRegion = new Rectangle(sourceMinX, sourceMinY, srcWidth, srcHeight);
        if (param != null) {
            Rectangle region = param.getSourceRegion();
            if (region != null) {
                sourceRegion = sourceRegion.intersection(region);
            }
            int subsampleXOffset = param.getSubsamplingXOffset();
            int subsampleYOffset = param.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        return sourceRegion;
    }

    protected mediaLibImage getMediaLibImage(RenderedImage image, ImageWriteParam param, boolean allowBilevel, int[] supportedFormats) {
        int numBands;
        int[] sourceBands;
        if (supportedFormats == null) {
            throw new IllegalArgumentException("supportedFormats == null!");
        }
        Rectangle sourceRegion = CLibImageWriter.getSourceRegion(param, image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        if (sourceRegion.isEmpty()) {
            throw new IllegalArgumentException("sourceRegion.isEmpty()");
        }
        boolean reformatData = false;
        boolean isBilevel = false;
        int mediaLibFormat = 0;
        SampleModel sampleModel = image.getSampleModel();
        int numSourceBands = sampleModel.getNumBands();
        int[] nArray = sourceBands = param != null ? param.getSourceBands() : null;
        if (sourceBands != null) {
            numBands = sourceBands.length;
            if (numBands != numSourceBands) {
                reformatData = true;
            } else {
                for (int i = 0; i < numSourceBands; ++i) {
                    if (sourceBands[i] == i) continue;
                    reformatData = true;
                    break;
                }
            }
        } else {
            numBands = numSourceBands;
        }
        if (!(reformatData || param == null || param.getSourceXSubsampling() == 1 && param.getSourceXSubsampling() == 1)) {
            reformatData = true;
        }
        if (!reformatData) {
            if (allowBilevel && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1 && sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getDataType() == 0) {
                MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
                if (mppsm.getPixelBitStride() == 1) {
                    isBilevel = true;
                } else {
                    reformatData = true;
                }
            } else {
                mediaLibFormat = CLibImageWriter.getMediaLibFormat(sampleModel, image.getColorModel());
                reformatData = true;
                int len = supportedFormats.length;
                for (int i = 0; i < len; ++i) {
                    if (mediaLibFormat != supportedFormats[i]) continue;
                    reformatData = false;
                    break;
                }
            }
        }
        Raster raster = null;
        if (reformatData) {
            WritableRaster translatedChild;
            SampleModel newSampleModel;
            int height;
            int width;
            int dataType;
            int[] sampleSize = sampleModel.getSampleSize();
            int bitDepthMax = sampleSize[0];
            for (int i = 1; i < numSourceBands; ++i) {
                bitDepthMax = Math.max(bitDepthMax, sampleSize[i]);
            }
            if (bitDepthMax <= 8) {
                dataType = 0;
            } else if (bitDepthMax <= 16) {
                dataType = 1;
            } else {
                throw new UnsupportedOperationException(I18N.getString("CLibImageWriter0") + " " + bitDepthMax);
            }
            if (param != null) {
                int subsampleX = param.getSourceXSubsampling();
                int subsampleY = param.getSourceYSubsampling();
                width = (sourceRegion.width + subsampleX - 1) / subsampleX;
                height = (sourceRegion.height + subsampleY - 1) / subsampleY;
            } else {
                width = sourceRegion.width;
                height = sourceRegion.height;
            }
            int[] newBandOffsets = new int[numBands];
            for (int i = 0; i < numBands; ++i) {
                newBandOffsets[i] = i;
            }
            if (allowBilevel && sampleModel.getNumBands() == 1 && bitDepthMax == 1) {
                newSampleModel = new MultiPixelPackedSampleModel(dataType, width, height, 1);
                isBilevel = true;
            } else {
                newSampleModel = new PixelInterleavedSampleModel(dataType, width, height, newBandOffsets.length, width * numSourceBands, newBandOffsets);
            }
            WritableRaster newRaster = Raster.createWritableRaster(newSampleModel, null);
            if (param != null && (param.getSourceXSubsampling() != 1 || param.getSourceXSubsampling() != 1)) {
                CLibImageWriter.reformat(CLibImageWriter.getContiguousData(image, sourceRegion), sourceBands, param.getSourceXSubsampling(), param.getSourceYSubsampling(), newRaster);
            } else if (sourceBands == null && image.getSampleModel().getClass().isInstance(newSampleModel) && newSampleModel.getTransferType() == image.getSampleModel().getTransferType()) {
                translatedChild = newRaster.createWritableTranslatedChild(sourceRegion.x, sourceRegion.y);
                image.copyData(translatedChild);
            } else {
                translatedChild = newRaster.createWritableTranslatedChild(sourceRegion.x, sourceRegion.y);
                Raster sourceRaster = CLibImageWriter.getContiguousData(image, sourceRegion);
                if (sourceBands != null) {
                    sourceRaster = sourceRaster.createChild(sourceRegion.x, sourceRegion.y, sourceRegion.width, sourceRegion.height, sourceRegion.x, sourceRegion.y, sourceBands);
                }
                translatedChild.setRect(sourceRaster);
            }
            raster = newRaster;
            sampleModel = newRaster.getSampleModel();
        } else {
            raster = CLibImageWriter.getContiguousData(image, sourceRegion).createTranslatedChild(0, 0);
            sampleModel = raster.getSampleModel();
        }
        mediaLibImage mlibImage = null;
        if (isBilevel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            int stride = mppsm.getScanlineStride();
            int offset = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * stride - raster.getSampleModelTranslateX() / 8 + mppsm.getOffset(0, 0);
            Object bitData = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            mlibImage = new mediaLibImage(0, 1, raster.getWidth(), raster.getHeight(), stride, offset, (byte)mppsm.getBitOffset(0), bitData);
        } else {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            int mlibDataType = CLibImageWriter.getMediaLibDataType(sampleModel.getDataType());
            Object data = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            int stride = csm.getScanlineStride();
            int[] bandOffsets = csm.getBandOffsets();
            int minBandOffset = bandOffsets[0];
            for (int i = 1; i < bandOffsets.length; ++i) {
                if (bandOffsets[i] >= minBandOffset) continue;
                minBandOffset = bandOffsets[i];
            }
            int offset = (raster.getMinY() - raster.getSampleModelTranslateY()) * stride + (raster.getMinX() - raster.getSampleModelTranslateX()) * numSourceBands + minBandOffset;
            mlibImage = !reformatData && mediaLibFormat != 0 ? new mediaLibImage(mlibDataType, numSourceBands, raster.getWidth(), raster.getHeight(), stride, offset, mediaLibFormat, data) : new mediaLibImage(mlibDataType, numSourceBands, raster.getWidth(), raster.getHeight(), stride, offset, data);
        }
        return mlibImage;
    }
}

