/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUriResolver {
    private Logger logger = LoggerFactory.getLogger(HttpUriResolver.class);
    private URI uri;
    private long connectionTimeout;
    private int socketTimeout;
    private String contentEncoding = "gzip,deflate";
    private boolean allowContentEncoding;
    private boolean followRedirects;
    private HttpMethod method = null;
    private Map<String, String> respHeaders;

    HttpUriResolver(URI uri, long connectionTimeout, int socketTimeout, boolean allowContentEncoding, boolean followRedirects) {
        if (!uri.getScheme().equalsIgnoreCase("http")) {
            throw new IllegalArgumentException("Given a Non-HTTP URI [" + uri.toString() + "].");
        }
        this.uri = uri;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.allowContentEncoding = allowContentEncoding;
        this.followRedirects = followRedirects;
    }

    public URI getUri() {
        return this.uri;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean getAllowContentEncoding() {
        return this.allowContentEncoding;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void makeRequest() throws IOException {
        if (this.method != null) {
            throw new IllegalStateException("Request already made.");
        }
        this.method = this.getHttpResponse(this.uri);
    }

    public int getResponseStatusCode() {
        if (this.method == null) {
            throw new IllegalStateException("Request has not been made.");
        }
        return this.method.getStatusCode();
    }

    public String getResponseStatusText() {
        if (this.method == null) {
            throw new IllegalStateException("Request has not been made.");
        }
        return this.method.getStatusText();
    }

    public Map<String, String> getResponseHeaders() {
        if (this.method == null) {
            throw new IllegalStateException("Request has not been made.");
        }
        if (this.respHeaders == null) {
            Header[] headers;
            this.respHeaders = new HashMap<String, String>();
            for (Header h : headers = this.method.getResponseHeaders()) {
                this.respHeaders.put(h.getName(), h.getValue());
            }
        }
        return this.respHeaders;
    }

    public String getResponseHeaderValue(String name) {
        if (this.method == null) {
            throw new IllegalStateException("Request has not been made.");
        }
        Header responseHeader = this.method.getResponseHeader(name);
        return responseHeader == null ? null : responseHeader.getValue();
    }

    public InputStream getResponseBodyAsInputStream() throws IOException {
        String contentEncoding;
        if (this.method == null) {
            throw new IllegalStateException("Request has not been made.");
        }
        InputStream is = this.method.getResponseBodyAsStream();
        Header contentEncodingHeader = this.method.getResponseHeader("Content-Encoding");
        if (contentEncodingHeader != null && (contentEncoding = contentEncodingHeader.getValue()) != null) {
            if (contentEncoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(is);
            }
            if (contentEncoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(is);
            }
        }
        return is;
    }

    private HttpMethod getHttpResponse(URI uri) throws IOException {
        HttpClient client = new HttpClient();
        HttpClientParams params = client.getParams();
        params.setConnectionManagerTimeout(this.connectionTimeout);
        params.setSoTimeout(this.socketTimeout);
        GetMethod method = new GetMethod(uri.toString());
        method.setFollowRedirects(this.followRedirects);
        method.addRequestHeader("Accept-Encoding", this.contentEncoding);
        client.executeMethod((HttpMethod)method);
        int statusCode = method.getStatusCode();
        if (statusCode == 200 || statusCode == 201) {
            return method;
        }
        return null;
    }
}

