/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.grib.GribNumbers;
import ucar.nc2.iosp.grib.tables.GribCodeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GribTemplate
implements Comparable<GribTemplate> {
    static Map<String, String> convertMap = new HashMap<String, String>();
    static Map<String, GribCodeTable> gribCodes;
    public String name;
    public String desc;
    public int m1;
    public int m2;
    public List<Field> flds = new ArrayList<Field>();
    static String resourceName;

    static String convert(String table, int value) {
        GribCodeTable gct;
        if (gribCodes == null) {
            try {
                gribCodes = GribCodeTable.readGribCodes();
            }
            catch (IOException e) {
                return "Read GridCodes failed";
            }
        }
        if ((gct = gribCodes.get(table)) == null) {
            return table + " not found";
        }
        GribCodeTable.TableEntry entry = gct.get(value);
        if (entry != null) {
            return entry.meaning;
        }
        return "Table " + table + " code " + value + " not found";
    }

    GribTemplate(String desc) {
        this.desc = desc;
        String[] slist = desc.split(" ");
        for (int i = 0; i < slist.length; ++i) {
            if (!slist[i].equalsIgnoreCase("template")) continue;
            this.name = slist[i + 1];
            String[] slist2 = this.name.split("\\.");
            if (slist2.length == 2) {
                this.m1 = Integer.parseInt(slist2[0]);
                this.m2 = Integer.parseInt(slist2[1]);
                break;
            }
            System.out.println("HEY bad= %s%n" + this.name);
            break;
        }
    }

    void add(String octet, String content) {
        this.flds.add(new Field(octet, content));
    }

    void add(int start, int nbytes, String content) {
        this.flds.add(new Field(start, nbytes, content));
    }

    @Override
    public int compareTo(GribTemplate o) {
        if (this.m1 == o.m1) {
            return this.m2 - o.m2;
        }
        return this.m1 - o.m1;
    }

    public void showInfo(byte[] pds, Formatter f) {
        f.format("%n(%s) %s %n", this.name, this.desc);
        for (Field fld : this.flds) {
            if (fld.start < 0) continue;
            String info = convertMap.get(fld.content);
            if (info == null) {
                f.format("%3d: %90s == %d %n", fld.start, fld.content, fld.value(pds));
                continue;
            }
            String desc = GribTemplate.convert(info, fld.value(pds));
            if (desc == null) {
                f.format("%3d: %90s == %d (%s) %n", fld.start, fld.content, fld.value(pds), GribTemplate.convert(info, fld.value(pds)));
                continue;
            }
            f.format("%3d: %90s == %d (table %s: %s) %n", fld.start, fld.content, fld.value(pds), info, desc);
        }
    }

    public static List<GribTemplate> readXml(InputStream ios) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(ios);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        HashMap<String, GribTemplate> map = new HashMap<String, GribTemplate>();
        Element root = doc.getRootElement();
        List featList = root.getChildren("ForExport_Templates_E");
        for (Element elem : featList) {
            String desc = elem.getChildTextNormalize("TemplateName_E");
            String octet = elem.getChildTextNormalize("OctetNo");
            String content = elem.getChildTextNormalize("Contents_E");
            GribTemplate t = (GribTemplate)map.get(desc);
            if (t == null) {
                t = new GribTemplate(desc);
                map.put(desc, t);
            }
            t.add(octet, content);
        }
        ios.close();
        ArrayList<GribTemplate> tlist = new ArrayList<GribTemplate>(map.values());
        Collections.sort(tlist);
        for (GribTemplate t : tlist) {
            if (t.m1 == 3) {
                t.add(1, 4, "GDS length");
                t.add(5, 1, "Section");
                t.add(6, 1, "Source of Grid Definition (see code table 3.0)");
                t.add(7, 4, "Number of data points");
                t.add(11, 1, "Number of octects for optional list of numbers");
                t.add(12, 1, "Interpretation of list of numbers");
                t.add(13, 2, "Grid Definition Template Number");
            } else if (t.m1 == 4) {
                t.add(1, 4, "PDS length");
                t.add(5, 1, "Section");
                t.add(6, 2, "Number of coordinates values after Template");
                t.add(8, 2, "Product Definition Template Number");
            }
            Collections.sort(t.flds);
        }
        return tlist;
    }

    public static Map<String, GribTemplate> getParameterTemplates() throws IOException {
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return null;
        }
        List<GribTemplate> tlist = GribTemplate.readXml(in);
        HashMap<String, GribTemplate> map = new HashMap<String, GribTemplate>(100);
        for (GribTemplate t : tlist) {
            map.put(t.m1 + "." + t.m2, t);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GribTemplate> getWmoStandard() throws IOException {
        List<GribTemplate> list;
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return null;
        }
        try {
            list = GribTemplate.readXml(in);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return list;
    }

    public static void main(String[] arg) throws IOException {
        Class<GribCodeTable> c = GribCodeTable.class;
        InputStream in = c.getResourceAsStream(resourceName);
        if (in == null) {
            System.out.printf("cant open %s%n", resourceName);
            return;
        }
        List<GribTemplate> tlist = GribTemplate.readXml(in);
        for (GribTemplate t : tlist) {
            System.out.printf("%n(%s) %s %n", t.name, t.desc);
            for (Field f : t.flds) {
                System.out.printf(" (%d,%d) %10s : %s %n", f.start, f.nbytes, f.octet, f.content);
            }
        }
        for (GribTemplate t : tlist) {
            System.out.printf("%n(%s) %s %n", t.name, t.desc);
            int start = -1;
            int next = 0;
            for (Field f : t.flds) {
                if (f.start < 0) continue;
                if (start < 0) {
                    start = f.start;
                    next = start + f.nbytes;
                    continue;
                }
                if (f.start != next) {
                    System.out.printf(" missing %d to %d %n", next, start);
                }
                next = f.start + f.nbytes;
            }
            System.out.printf(" range %d-%d %n", start, next);
        }
    }

    static {
        convertMap.put("Type of generating process", "4.3");
        convertMap.put("Indicator of unit of time range", "4.4");
        convertMap.put("Indicator of unit of time for time range over which statistical processing is done", "4.4");
        convertMap.put("Indicator of unit of time for the increment between the successive fields used", "4.4");
        convertMap.put("Type of first fixed surface", "4.5");
        convertMap.put("Type of second fixed surface", "4.5");
        convertMap.put("Derived forecast", "4.7");
        convertMap.put("Probability type", "4.9");
        convertMap.put("Statistical process used to calculate the processed field from the field at each time increment during the time range", "4.10");
        convertMap.put("Type of time increment between successive fields used in the statistical processing", "4.11");
        resourceName = "/resources/grib/wmo/GRIB2_5_2_0_Templates_E.xml";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Field
    implements Comparable<Field> {
        public String octet;
        public String content;
        public int start;
        public int nbytes;

        Field(String octet, String content) {
            this.octet = octet;
            this.content = content;
            try {
                int pos = octet.indexOf(45);
                if (pos > 0) {
                    this.start = Integer.parseInt(octet.substring(0, pos));
                    String stops = octet.substring(pos + 1);
                    int stop = -1;
                    try {
                        stop = Integer.parseInt(stops);
                        this.nbytes = stop - this.start + 1;
                    }
                    catch (Exception e) {}
                } else {
                    this.start = Integer.parseInt(octet);
                    this.nbytes = 1;
                }
            }
            catch (Exception e) {
                this.start = -1;
                this.nbytes = 0;
            }
        }

        Field(int start, int nbytes, String content) {
            this.start = start;
            this.nbytes = nbytes;
            this.content = content;
            this.octet = start + "-" + (start + nbytes - 1);
        }

        @Override
        public int compareTo(Field o) {
            return this.start - o.start;
        }

        int value(byte[] pds) {
            switch (this.nbytes) {
                case 1: {
                    return this.get(pds, this.start);
                }
                case 2: {
                    return GribNumbers.int2((int)this.get(pds, this.start), (int)this.get(pds, this.start + 1));
                }
                case 4: {
                    return GribNumbers.int4((int)this.get(pds, this.start), (int)this.get(pds, this.start + 1), (int)this.get(pds, this.start + 2), (int)this.get(pds, this.start + 3));
                }
            }
            return -9999;
        }

        int get(byte[] pds, int offset) {
            return pds[offset - 1] & 0xFF;
        }
    }
}

