/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.decoder;

import jj2000.j2k.entropy.decoder.ByteInputBuffer;

class ByteToBitInput {
    ByteInputBuffer in;
    int bbuf;
    int bpos = -1;

    ByteToBitInput(ByteInputBuffer in) {
        this.in = in;
    }

    final int readBit() {
        if (this.bpos < 0) {
            if ((this.bbuf & 0xFF) != 255) {
                this.bbuf = this.in.read();
                this.bpos = 7;
            } else {
                this.bbuf = this.in.read();
                this.bpos = 6;
            }
        }
        return this.bbuf >> this.bpos-- & 1;
    }

    public boolean checkBytePadding() {
        int seq;
        if (this.bpos < 0 && (this.bbuf & 0xFF) == 255) {
            this.bbuf = this.in.read();
            this.bpos = 6;
        }
        if (this.bpos >= 0 && (seq = this.bbuf & (1 << this.bpos + 1) - 1) != 85 >> 7 - this.bpos) {
            return true;
        }
        return this.bbuf != -1 && (this.bbuf == 255 && this.bpos == 0 ? (this.in.read() & 0xFF) >= 128 : this.in.read() != -1);
    }

    final void flush() {
        this.bbuf = 0;
        this.bpos = -1;
    }

    final void setByteArray(byte[] buf, int off, int len) {
        this.in.setByteArray(buf, off, len);
        this.bbuf = 0;
        this.bpos = -1;
    }
}

