/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans;

import com.mchange.v2.lang.Coerce;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class BeansUtils {
    static final MLogger logger = MLog.getLogger(BeansUtils.class);
    static final Object[] EMPTY_ARGS = new Object[0];
    static /* synthetic */ Class class$java$lang$String;

    public static PropertyEditor findPropertyEditor(PropertyDescriptor pd) {
        PropertyEditor out;
        block4: {
            out = null;
            Class<?> editorClass = null;
            try {
                editorClass = pd.getPropertyEditorClass();
                if (editorClass != null) {
                    out = (PropertyEditor)editorClass.newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Bad property editor class " + editorClass.getName() + " registered for property " + pd.getName(), e);
            }
        }
        if (out == null) {
            out = PropertyEditorManager.findEditor(pd.getPropertyType());
        }
        return out;
    }

    public static boolean equalsByAccessibleProperties(Object bean0, Object bean1) throws IntrospectionException {
        return BeansUtils.equalsByAccessibleProperties(bean0, bean1, Collections.EMPTY_SET);
    }

    public static boolean equalsByAccessibleProperties(Object bean0, Object bean1, Collection ignoreProps) throws IntrospectionException {
        HashMap m0 = new HashMap();
        HashMap m1 = new HashMap();
        BeansUtils.extractAccessiblePropertiesToMap(m0, bean0, ignoreProps);
        BeansUtils.extractAccessiblePropertiesToMap(m1, bean1, ignoreProps);
        return ((Object)m0).equals(m1);
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean) throws IntrospectionException {
        BeansUtils.overwriteAccessibleProperties(sourceBean, destBean, Collections.EMPTY_SET);
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean, Collection ignoreProps) throws IntrospectionException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), Object.class);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                if (ignoreProps.contains(pd.getName())) continue;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter == null || setter == null) {
                    if (pd instanceof IndexedPropertyDescriptor && logger.isLoggable(MLevel.WARNING)) {
                        logger.warning("BeansUtils.overwriteAccessibleProperties() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                    }
                    if (!logger.isLoggable(MLevel.INFO)) continue;
                    logger.info("Property inaccessible for overwriting: " + pd.getName());
                    continue;
                }
                Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                setter.invoke(destBean, value);
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Converting exception to throwable IntrospectionException");
            }
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(sourceMap, destBean, skip_nulls, Collections.EMPTY_SET);
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls, Collection ignoreProps) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(sourceMap, destBean, skip_nulls, ignoreProps, false, MLevel.WARNING, MLevel.WARNING, true);
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls, Collection ignoreProps, boolean coerce_strings, MLevel cantWriteLevel, MLevel cantCoerceLevel, boolean die_on_one_prop_failure) throws IntrospectionException {
        if (cantWriteLevel == null) {
            cantWriteLevel = MLevel.WARNING;
        }
        if (cantCoerceLevel == null) {
            cantCoerceLevel = MLevel.WARNING;
        }
        Set sourceMapProps = sourceMap.keySet();
        String propName = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(destBean.getClass(), Object.class);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        int len = pds.length;
        for (int i = 0; i < len; ++i) {
            Object propVal;
            PropertyDescriptor pd = pds[i];
            propName = pd.getName();
            if (!sourceMapProps.contains(propName) || ignoreProps != null && ignoreProps.contains(propName) || (propVal = sourceMap.get(propName)) == null && skip_nulls) continue;
            Method setter = pd.getWriteMethod();
            boolean rethrow = false;
            Class<?> propType = pd.getPropertyType();
            if (setter == null) {
                if (pd instanceof IndexedPropertyDescriptor && logger.isLoggable(MLevel.FINER)) {
                    logger.finer("BeansUtils.overwriteAccessiblePropertiesFromMap() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                }
                if (!logger.isLoggable(cantWriteLevel)) continue;
                String msg = "Property inaccessible for overwriting: " + propName;
                logger.log(cantWriteLevel, msg);
                if (!die_on_one_prop_failure) continue;
                rethrow = true;
                throw new IntrospectionException(msg);
            }
            if (coerce_strings && propVal != null && propVal.getClass() == (class$java$lang$String == null ? BeansUtils.class$("java.lang.String") : class$java$lang$String) && (propType = pd.getPropertyType()) != (class$java$lang$String == null ? BeansUtils.class$("java.lang.String") : class$java$lang$String) && Coerce.canCoerce(propType)) {
                String msg;
                try {
                    Object coercedPropVal = Coerce.toObject((String)propVal, propType);
                    setter.invoke(destBean, coercedPropVal);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    msg = "Failed to coerce property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                    if (logger.isLoggable(cantCoerceLevel)) {
                        logger.log(cantCoerceLevel, msg, e);
                    }
                    if (!die_on_one_prop_failure) continue;
                    rethrow = true;
                    throw new IntrospectionException(msg);
                }
                catch (Exception e) {
                    msg = "Failed to set property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                    if (logger.isLoggable(cantWriteLevel)) {
                        logger.log(cantWriteLevel, msg, e);
                    }
                    if (!die_on_one_prop_failure) continue;
                    rethrow = true;
                    throw new IntrospectionException(msg);
                }
            }
            try {
                setter.invoke(destBean, propVal);
                continue;
            }
            catch (Exception e) {
                String msg = "Failed to set property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                if (logger.isLoggable(cantWriteLevel)) {
                    logger.log(cantWriteLevel, msg, e);
                }
                if (!die_on_one_prop_failure) continue;
                rethrow = true;
                throw new IntrospectionException(msg);
            }
        }
    }

    public static void appendPropNamesAndValues(StringBuffer appendIntoMe, Object bean, Collection ignoreProps) throws IntrospectionException {
        TreeMap tmp = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        BeansUtils.extractAccessiblePropertiesToMap(tmp, bean, ignoreProps);
        boolean first = true;
        Iterator ii = tmp.keySet().iterator();
        while (ii.hasNext()) {
            String key = (String)ii.next();
            Object val = tmp.get(key);
            if (first) {
                first = false;
            } else {
                appendIntoMe.append(", ");
            }
            appendIntoMe.append(key);
            appendIntoMe.append(" -> ");
            appendIntoMe.append(val);
        }
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean) throws IntrospectionException {
        BeansUtils.extractAccessiblePropertiesToMap(fillMe, bean, Collections.EMPTY_SET);
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean, Collection ignoreProps) throws IntrospectionException {
        String propName = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                propName = pd.getName();
                if (ignoreProps.contains(propName)) continue;
                Method readMethod = pd.getReadMethod();
                Object propVal = readMethod.invoke(bean, EMPTY_ARGS);
                fillMe.put(propName, propVal);
            }
        }
        catch (IntrospectionException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Problem occurred while overwriting property: " + propName);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "extractAccessiblePropertiesToMap( Map fillMe, Object bean, Collection ignoreProps )", (propName != null ? "Problem occurred while overwriting property: " + propName : "") + " throwing...", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "extractAccessiblePropertiesToMap( Map fillMe, Object bean, Collection ignoreProps )", "Caught unexpected Exception; Converting to IntrospectionException.", e);
            }
            throw new IntrospectionException(e.toString() + (propName == null ? "" : " [" + propName + ']'));
        }
    }

    private static void overwriteProperty(String propName, Object value, Method putativeSetter, Object target) throws Exception {
        if (putativeSetter.getDeclaringClass().isAssignableFrom(target.getClass())) {
            putativeSetter.invoke(target, value);
        } else {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass(), Object.class);
            PropertyDescriptor pd = null;
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                if (!propName.equals(pds[i].getName())) continue;
                pd = pds[i];
                break;
            }
            Method targetSetter = pd.getWriteMethod();
            targetSetter.invoke(target, value);
        }
    }

    public static void overwriteSpecificAccessibleProperties(Object sourceBean, Object destBean, Collection props) throws IntrospectionException {
        try {
            HashSet _props = new HashSet(props);
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), Object.class);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                if (!_props.remove(name)) continue;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter == null || setter == null) {
                    if (pd instanceof IndexedPropertyDescriptor && logger.isLoggable(MLevel.WARNING)) {
                        logger.warning("BeansUtils.overwriteAccessibleProperties() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                    }
                    if (!logger.isLoggable(MLevel.INFO)) continue;
                    logger.info("Property inaccessible for overwriting: " + pd.getName());
                    continue;
                }
                Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                BeansUtils.overwriteProperty(name, value, setter, destBean);
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                Iterator ii = _props.iterator();
                while (ii.hasNext()) {
                    logger.warning("failed to find expected property: " + ii.next());
                }
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "overwriteSpecificAccessibleProperties( Object sourceBean, Object destBean, Collection props )", "Caught unexpected Exception; Converting to IntrospectionException.", e);
            }
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void debugShowPropertyChange(PropertyChangeEvent evt) {
        System.err.println("PropertyChangeEvent: [ propertyName -> " + evt.getPropertyName() + ", oldValue -> " + evt.getOldValue() + ", newValue -> " + evt.getNewValue() + " ]");
    }

    private BeansUtils() {
    }
}

