/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MLevel {
    public static final MLevel ALL;
    public static final MLevel CONFIG;
    public static final MLevel FINE;
    public static final MLevel FINER;
    public static final MLevel FINEST;
    public static final MLevel INFO;
    public static final MLevel OFF;
    public static final MLevel SEVERE;
    public static final MLevel WARNING;
    private static final Map integersToMLevels;
    private static final Map namesToMLevels;
    Object level;
    int intval;
    String lvlstring;

    public static MLevel fromIntValue(int intval) {
        return (MLevel)integersToMLevels.get(new Integer(intval));
    }

    public static MLevel fromSeverity(String name) {
        return (MLevel)namesToMLevels.get(name);
    }

    public int intValue() {
        return this.intval;
    }

    public Object asJdk14Level() {
        return this.level;
    }

    public String getSeverity() {
        return this.lvlstring;
    }

    public String toString() {
        return this.getClass().getName() + this.getLineHeader();
    }

    public String getLineHeader() {
        return "[" + this.lvlstring + ']';
    }

    private MLevel(Object level, int intval, String lvlstring) {
        this.level = level;
        this.intval = intval;
        this.lvlstring = lvlstring;
    }

    static {
        MLevel warning;
        MLevel severe;
        MLevel off;
        MLevel info;
        MLevel finest;
        MLevel finer;
        MLevel fine;
        MLevel config;
        MLevel all;
        boolean jdk14api;
        Class<?> lvlClass;
        try {
            lvlClass = Class.forName("java.util.logging.Level");
            jdk14api = true;
        }
        catch (ClassNotFoundException e) {
            lvlClass = null;
            jdk14api = false;
        }
        try {
            all = new MLevel(jdk14api ? lvlClass.getField("ALL").get(null) : null, Integer.MIN_VALUE, "ALL");
            config = new MLevel(jdk14api ? lvlClass.getField("CONFIG").get(null) : null, 700, "CONFIG");
            fine = new MLevel(jdk14api ? lvlClass.getField("FINE").get(null) : null, 500, "FINE");
            finer = new MLevel(jdk14api ? lvlClass.getField("FINER").get(null) : null, 400, "FINER");
            finest = new MLevel(jdk14api ? lvlClass.getField("FINEST").get(null) : null, 300, "FINEST");
            info = new MLevel(jdk14api ? lvlClass.getField("INFO").get(null) : null, 800, "INFO");
            off = new MLevel(jdk14api ? lvlClass.getField("OFF").get(null) : null, Integer.MAX_VALUE, "OFF");
            severe = new MLevel(jdk14api ? lvlClass.getField("SEVERE").get(null) : null, 900, "SEVERE");
            warning = new MLevel(jdk14api ? lvlClass.getField("WARNING").get(null) : null, 1000, "WARNING");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError("Huh? java.util.logging.Level is here, but not its expected public fields?");
        }
        ALL = all;
        CONFIG = config;
        FINE = fine;
        FINER = finer;
        FINEST = finest;
        INFO = info;
        OFF = off;
        SEVERE = severe;
        WARNING = warning;
        HashMap<Object, MLevel> tmp = new HashMap<Object, MLevel>();
        tmp.put(new Integer(all.intValue()), all);
        tmp.put(new Integer(config.intValue()), config);
        tmp.put(new Integer(fine.intValue()), fine);
        tmp.put(new Integer(finer.intValue()), finer);
        tmp.put(new Integer(finest.intValue()), finest);
        tmp.put(new Integer(info.intValue()), info);
        tmp.put(new Integer(off.intValue()), off);
        tmp.put(new Integer(severe.intValue()), severe);
        tmp.put(new Integer(warning.intValue()), warning);
        integersToMLevels = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(all.getSeverity(), all);
        tmp.put(config.getSeverity(), config);
        tmp.put(fine.getSeverity(), fine);
        tmp.put(finer.getSeverity(), finer);
        tmp.put(finest.getSeverity(), finest);
        tmp.put(info.getSeverity(), info);
        tmp.put(off.getSeverity(), off);
        tmp.put(severe.getSeverity(), severe);
        tmp.put(warning.getSeverity(), warning);
        namesToMLevels = Collections.unmodifiableMap(tmp);
    }
}

