/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import java.io.IOException;

class PSTDescriptorItem {
    int descriptorIdentifier;
    int offsetIndexIdentifier;
    int subNodeOffsetIndexIdentifier;
    byte[] dataBlockData = null;
    int[] dataBlockOffsets = null;
    private PSTFile pstFile;

    PSTDescriptorItem(byte[] data, int offset, PSTFile pstFile) {
        this.pstFile = pstFile;
        if (pstFile.getPSTFileType() == 14) {
            this.descriptorIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset, offset + 4);
            this.offsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset + 4, offset + 8) & 0xFFFFFFFE;
            this.subNodeOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset + 8, offset + 12) & 0xFFFFFFFE;
        } else {
            this.descriptorIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset, offset + 4);
            this.offsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset + 8, offset + 16) & 0xFFFFFFFE;
            this.subNodeOffsetIndexIdentifier = (int)PSTObject.convertLittleEndianBytesToLong(data, offset + 16, offset + 24) & 0xFFFFFFFE;
        }
    }

    public byte[] getData() throws IOException, PSTException {
        if (this.dataBlockData != null) {
            return this.dataBlockData;
        }
        PSTNodeInputStream in = this.pstFile.readLeaf(this.offsetIndexIdentifier);
        byte[] out = new byte[(int)in.length()];
        in.read(out);
        this.dataBlockData = out;
        return this.dataBlockData;
    }

    public int[] getBlockOffsets() throws IOException, PSTException {
        if (this.dataBlockOffsets != null) {
            return this.dataBlockOffsets;
        }
        Long[] offsets = this.pstFile.readLeaf(this.offsetIndexIdentifier).getBlockOffsets();
        int[] offsetsOut = new int[offsets.length];
        for (int x = 0; x < offsets.length; ++x) {
            offsetsOut[x] = offsets[x].intValue();
        }
        return offsetsOut;
    }

    public int getDataSize() throws IOException, PSTException {
        return this.pstFile.getLeafSize(this.offsetIndexIdentifier);
    }

    public String toString() {
        return "PSTDescriptorItem\n   descriptorIdentifier: " + this.descriptorIdentifier + "\n" + "   offsetIndexIdentifier: " + this.offsetIndexIdentifier + "\n" + "   subNodeOffsetIndexIdentifier: " + this.subNodeOffsetIndexIdentifier + "\n";
    }
}

