/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Map;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.util.GenericName;

final class CharacteristicMap
extends AbstractMap<String, AbstractAttribute<?>>
implements Cloneable {
    private final AbstractAttribute<?> source;
    AbstractAttribute<?>[] characterizedBy;
    final CharacteristicTypeMap types;

    CharacteristicMap(AbstractAttribute<?> abstractAttribute, CharacteristicTypeMap characteristicTypeMap) {
        this.source = abstractAttribute;
        this.types = characteristicTypeMap;
    }

    public CharacteristicMap clone() throws CloneNotSupportedException {
        CharacteristicMap characteristicMap = (CharacteristicMap)super.clone();
        AbstractAttribute<?>[] abstractAttributeArray = characteristicMap.characterizedBy;
        if (abstractAttributeArray != null) {
            characteristicMap.characterizedBy = abstractAttributeArray = (AbstractAttribute[])abstractAttributeArray.clone();
            Cloner cloner = new Cloner();
            for (int i = 0; i < abstractAttributeArray.length; ++i) {
                AbstractAttribute<?> abstractAttribute = abstractAttributeArray[i];
                if (!(abstractAttribute instanceof Cloneable)) continue;
                abstractAttributeArray[i] = (AbstractAttribute)cloner.clone(abstractAttribute);
            }
        }
        return characteristicMap;
    }

    @Override
    public void clear() {
        this.characterizedBy = null;
    }

    @Override
    public boolean isEmpty() {
        if (this.characterizedBy != null) {
            for (AbstractAttribute<?> abstractAttribute : this.characterizedBy) {
                if (abstractAttribute == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n = 0;
        if (this.characterizedBy != null) {
            for (AbstractAttribute<?> abstractAttribute : this.characterizedBy) {
                if (abstractAttribute == null) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public AbstractAttribute<?> get(Object object) {
        Integer n;
        if (this.characterizedBy != null && (n = this.types.indices.get(object)) != null) {
            return this.characterizedBy[n];
        }
        return null;
    }

    @Override
    public AbstractAttribute<?> remove(Object object) {
        Integer n;
        if (this.characterizedBy != null && (n = this.types.indices.get(object)) != null) {
            AbstractAttribute<?> abstractAttribute = this.characterizedBy[n];
            this.characterizedBy[n.intValue()] = null;
            return abstractAttribute;
        }
        return null;
    }

    private int indexOf(String string) {
        ArgumentChecks.ensureNonNull("key", string);
        Integer n = this.types.indices.get(string);
        if (n == null) {
            throw new IllegalArgumentException(Resources.format((short)7, this.source.getName(), string));
        }
        return n;
    }

    final void verifyAttributeType(int n, DefaultAttributeType<?> defaultAttributeType) {
        DefaultAttributeType<?> defaultAttributeType2 = this.types.characterizedBy[n];
        if (!defaultAttributeType2.equals(defaultAttributeType)) {
            GenericName genericName = defaultAttributeType2.getName();
            GenericName genericName2 = defaultAttributeType.getName();
            throw new IllegalArgumentException(String.valueOf(genericName).equals(String.valueOf(genericName2)) ? Resources.format((short)12, genericName) : Resources.format((short)4, genericName.push(this.source.getName()), genericName2));
        }
    }

    @Override
    public AbstractAttribute<?> put(String string, AbstractAttribute<?> abstractAttribute) {
        int n = this.indexOf(string);
        ArgumentChecks.ensureNonNull("value", abstractAttribute);
        this.verifyAttributeType(n, abstractAttribute.getType());
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        AbstractAttribute<?> abstractAttribute2 = this.characterizedBy[n];
        this.characterizedBy[n] = abstractAttribute;
        return abstractAttribute2;
    }

    @Override
    protected boolean addKey(String string) {
        int n = this.indexOf(string);
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        if (this.characterizedBy[n] == null) {
            this.characterizedBy[n] = this.types.characterizedBy[n].newInstance();
            return true;
        }
        return false;
    }

    @Override
    protected boolean addValue(AbstractAttribute<?> abstractAttribute) {
        AbstractAttribute<?> abstractAttribute2;
        ArgumentChecks.ensureNonNull("value", abstractAttribute);
        int n = this.indexOf(abstractAttribute.getName().toString());
        this.verifyAttributeType(n, abstractAttribute.getType());
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        if ((abstractAttribute2 = this.characterizedBy[n]) == null) {
            this.characterizedBy[n] = abstractAttribute;
            return true;
        }
        if (abstractAttribute2.equals(abstractAttribute)) {
            return false;
        }
        throw new IllegalStateException(Resources.format((short)6, this.source.getName(), abstractAttribute.getName()));
    }

    @Override
    protected AbstractMap.EntryIterator<String, AbstractAttribute<?>> entryIterator() {
        if (this.characterizedBy == null) {
            return null;
        }
        return new AbstractMap.EntryIterator<String, AbstractAttribute<?>>(){
            private int index = -1;
            private AbstractAttribute<?> value;

            @Override
            protected boolean next() {
                while (++this.index < CharacteristicMap.this.characterizedBy.length) {
                    this.value = CharacteristicMap.this.characterizedBy[this.index];
                    if (this.value == null) continue;
                    return true;
                }
                this.value = null;
                return false;
            }

            @Override
            protected String getKey() {
                return this.value.getType().getName().toString();
            }

            @Override
            protected AbstractAttribute<?> getValue() {
                return this.value;
            }

            @Override
            protected Map.Entry<String, AbstractAttribute<?>> getEntry() {
                return new Entry(this.index, this.value);
            }

            @Override
            protected void remove() {
                CharacteristicMap.this.characterizedBy[this.index] = null;
            }
        };
    }

    private final class Entry
    extends AbstractMapEntry<String, AbstractAttribute<?>> {
        private final int index;
        private AbstractAttribute<?> value;

        Entry(int n, AbstractAttribute<?> abstractAttribute) {
            this.index = n;
            this.value = abstractAttribute;
        }

        @Override
        public String getKey() {
            return this.value.getType().getName().toString();
        }

        @Override
        public AbstractAttribute<?> getValue() {
            return this.value;
        }

        @Override
        public AbstractAttribute<?> setValue(AbstractAttribute<?> abstractAttribute) {
            ArgumentChecks.ensureNonNull("value", abstractAttribute);
            CharacteristicMap.this.verifyAttributeType(this.index, abstractAttribute.getType());
            AbstractAttribute<?> abstractAttribute2 = this.value;
            CharacteristicMap.this.characterizedBy[this.index] = abstractAttribute;
            this.value = abstractAttribute;
            return abstractAttribute2;
        }
    }
}

