/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import org.apache.sis.util.Static;

public final class ShapeUtilities
extends Static {
    private static final double EPS = 1.0E-6;

    private ShapeUtilities() {
    }

    public static Point2D.Double intersectionPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d4 -= d2) * (d7 -= d5);
        double d10 = (d3 -= d) * (d8 -= d6);
        d9 = ((d6 - d2) * (d3 * d7) + d9 * d - d10 * d5) / (d9 - d10);
        double d11 = d10 = Math.abs(d7) > Math.abs(d3) ? d8 / d7 * (d9 - d5) + d6 : d4 / d3 * (d9 - d) + d2;
        if (d3 != 0.0 && !(!(d3 < 0.0) ? d9 >= d && d9 <= d + d3 : d9 <= d && d9 >= d + d3)) {
            return null;
        }
        if (d7 != 0.0 && !(!(d7 < 0.0) ? d9 >= d5 && d9 <= d5 + d7 : d9 <= d5 && d9 >= d5 + d7)) {
            return null;
        }
        if (d4 != 0.0 && !(!(d4 < 0.0) ? d10 >= d2 && d10 <= d2 + d4 : d10 <= d2 && d10 >= d2 + d4)) {
            return null;
        }
        if (d8 != 0.0 && !(!(d8 < 0.0) ? d10 >= d6 && d10 <= d6 + d8 : d10 <= d6 && d10 >= d6 + d8)) {
            return null;
        }
        return new Point2D.Double(d9, d10);
    }

    public static Point2D.Double nearestColinearPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d4 - d2) / (d3 - d);
        if (!Double.isInfinite(d7)) {
            double d8 = d4 - d7 * d3;
            d5 = ((d6 - d8) * d7 + d5) / (d7 * d7 + 1.0);
            d6 = d5 * d7 + d8;
        } else {
            d5 = d3;
        }
        if (d <= d3) {
            if (d5 < d) {
                d5 = d;
            }
            if (d5 > d3) {
                d5 = d3;
            }
        } else {
            if (d5 > d) {
                d5 = d;
            }
            if (d5 < d3) {
                d5 = d3;
            }
        }
        if (d2 <= d4) {
            if (d6 < d2) {
                d6 = d2;
            }
            if (d6 > d4) {
                d6 = d4;
            }
        } else {
            if (d6 > d2) {
                d6 = d2;
            }
            if (d6 < d4) {
                d6 = d4;
            }
        }
        return new Point2D.Double(d5, d6);
    }

    public static Point2D.Double colinearPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl;
        boolean bl2;
        double d8;
        double d9;
        double d10;
        double d11 = d;
        double d12 = d2;
        double d13 = d3;
        double d14 = d4;
        d7 *= d7;
        if (d == d3) {
            d10 = d - d5;
            d10 = Math.sqrt(d7 - d10 * d10);
            d2 = d6 - d10;
            d4 = d6 + d10;
        } else if (d2 == d4) {
            d10 = d2 - d6;
            d10 = Math.sqrt(d7 - d10 * d10);
            d = d5 - d10;
            d3 = d5 + d10;
        } else {
            d10 = (d2 - d4) / (d3 - d);
            d9 = d4 - d6 + d10 * (d3 - d5);
            d8 = d10 * d9;
            double d15 = d10 * d10 + 1.0;
            double d16 = Math.sqrt(d8 * d8 + d15 * (d7 - d9 * d9));
            d = (d8 + d16) / d15;
            d3 = (d8 - d16) / d15;
            d2 = d6 + d9 - d10 * d;
            d4 = d6 + d9 - d10 * d3;
            d += d5;
            d3 += d5;
        }
        if (d12 > d14) {
            bl2 = d2 <= d12 && d2 >= d14;
            bl = d4 <= d12 && d4 >= d14;
        } else {
            bl2 = d2 >= d12 && d2 <= d14;
            boolean bl3 = bl = d4 >= d12 && d4 <= d14;
        }
        if (d11 > d13) {
            bl2 &= d <= d11 && d >= d13;
            bl &= d3 <= d11 && d3 >= d13;
        } else {
            bl2 &= d >= d11 && d <= d13;
            bl &= d3 >= d11 && d3 <= d13;
        }
        if (!bl2 && !bl) {
            return null;
        }
        if (!bl2) {
            return new Point2D.Double(d3, d4);
        }
        if (!bl) {
            return new Point2D.Double(d, d2);
        }
        d5 = d - d11;
        d6 = d2 - d12;
        d9 = d5 * d5 + d6 * d6;
        d8 = (d5 = d3 - d11) * d5 + (d6 = d4 - d12) * d6;
        if (d9 > d8) {
            return new Point2D.Double(d3, d4);
        }
        return new Point2D.Double(d, d2);
    }

    public static QuadCurve2D.Double fitParabol(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        Point2D.Double double_ = ShapeUtilities.parabolicControlPoint(d, d2, d3, d4, d5, d6, bl);
        return double_ != null ? new QuadCurve2D.Double(d, d2, double_.x, double_.y, d5, d6) : null;
    }

    public static Point2D.Double parabolicControlPoint(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        d3 -= d;
        d4 -= d2;
        d5 -= d;
        d6 -= d2;
        if (bl) {
            double d7 = (d6 - d4 * d5 / d3) / (d5 - d3);
            double d8 = Math.abs(d7);
            if (!(d8 <= 1000000.0)) {
                return null;
            }
            if (!(d8 >= 1.0E-6)) {
                return null;
            }
            double d9 = d6 / d5 - d7;
            d3 = (1.0 + d9 / (2.0 * d7)) * d5 - d6 / (2.0 * d7);
            d4 = d2 + d9 * d3;
            d3 += d;
        } else {
            double d10 = d5;
            double d11 = d6;
            d5 = Math.hypot(d5, d6);
            d6 = (d3 * d10 + d4 * d11) / d5;
            d4 = (d4 * d10 - d3 * d11) / d5;
            d3 = d6;
            d6 = 0.0;
            double d12 = d4 * 0.5 * d5 / (d3 * (d5 - d3));
            double d13 = Math.abs(d12);
            if (!(d13 <= 1000000.0)) {
                return null;
            }
            if (!(d13 >= 1.0E-6)) {
                return null;
            }
            d3 = 0.5 * d10 - d12 * d11 + d;
            d4 = d12 * d10 + 0.5 * d11 + d2;
        }
        return new Point2D.Double(d3, d4);
    }

    public static Point2D.Double circleCentre(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 -= d) * d3 + (d4 -= d2) * d4;
        double d8 = (d5 -= d) * d5 + (d6 -= d2) * d6;
        double d9 = (d4 * d8 - d6 * d7) / (d4 * d5 - d6 * d3);
        return new Point2D.Double(d + 0.5 * d9, d2 + 0.5 * (d7 - d9 * d3) / d4);
    }

    public static Shape toPrimitive(Shape shape) {
        double[] dArray;
        PathIterator pathIterator = shape.getPathIterator(null);
        if (!pathIterator.isDone() && pathIterator.currentSegment(dArray = new double[6]) == 0) {
            pathIterator.next();
            if (!pathIterator.isDone()) {
                double d = dArray[0];
                double d2 = dArray[1];
                int n = pathIterator.currentSegment(dArray);
                pathIterator.next();
                if (pathIterator.isDone()) {
                    switch (n) {
                        case 1: {
                            return new Line2D.Double(d, d2, dArray[0], dArray[1]);
                        }
                        case 2: {
                            return new QuadCurve2D.Double(d, d2, dArray[0], dArray[1], dArray[2], dArray[3]);
                        }
                        case 3: {
                            return new CubicCurve2D.Double(d, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        }
                    }
                }
            }
        }
        return shape;
    }
}

