/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.LocalDate;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.acquisition.DefaultAcquisitionInformation;
import org.apache.sis.metadata.iso.acquisition.DefaultEvent;
import org.apache.sis.metadata.iso.acquisition.DefaultInstrument;
import org.apache.sis.metadata.iso.acquisition.DefaultOperation;
import org.apache.sis.metadata.iso.acquisition.DefaultPlatform;
import org.apache.sis.metadata.iso.acquisition.DefaultRequirement;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultFeatureCatalogueDescription;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.distribution.DefaultFormat;
import org.apache.sis.metadata.iso.extent.DefaultBoundingPolygon;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.identification.DefaultResolution;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.lineage.DefaultProcessStep;
import org.apache.sis.metadata.iso.lineage.DefaultProcessing;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGCP;
import org.apache.sis.metadata.iso.spatial.DefaultGCPCollection;
import org.apache.sis.metadata.iso.spatial.DefaultGeorectified;
import org.apache.sis.metadata.iso.spatial.DefaultGeoreferenceable;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.iso.Types;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Context;
import org.opengis.metadata.acquisition.OperationType;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.GeolocationInformation;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;

public class MetadataBuilder {
    private static final MemberName[] BAND_NUMBERS = new MemberName[16];
    private PartyType partyType = PartyType.UNKNOWN;
    private GridType gridType = GridType.UNSPECIFIED;
    private boolean electromagnetic;
    private final Map<Object, Object> sharedValues = new HashMap<Object, Object>();
    private DefaultMetadata metadata;
    private DefaultDataIdentification identification;
    private DefaultCitation citation;
    private DefaultResponsibleParty responsibility;
    private AbstractParty party;
    private DefaultLegalConstraints constraints;
    private DefaultExtent extent;
    private DefaultAcquisitionInformation acquisition;
    private DefaultPlatform platform;
    private DefaultFeatureCatalogueDescription featureDescription;
    private DefaultCoverageDescription coverageDescription;
    private DefaultAttributeGroup attributeGroup;
    private DefaultSampleDimension sampleDimension;
    private DefaultGridSpatialRepresentation gridRepresentation;
    private DefaultGCPCollection groundControlPoints;
    private DefaultDistribution distribution;
    private Format format;
    private DefaultLineage lineage;
    private DefaultProcessStep processStep;
    private DefaultProcessing processing;

    private DefaultMetadata metadata() {
        if (this.metadata == null) {
            this.metadata = new DefaultMetadata();
        }
        return this.metadata;
    }

    private DefaultDataIdentification identification() {
        if (this.identification == null) {
            this.identification = new DefaultDataIdentification();
        }
        return this.identification;
    }

    private DefaultCitation citation() {
        if (this.citation == null) {
            this.citation = new DefaultCitation();
        }
        return this.citation;
    }

    private DefaultResponsibleParty responsibility() {
        if (this.responsibility == null) {
            this.responsibility = new DefaultResponsibleParty();
        }
        return this.responsibility;
    }

    private AbstractParty party() {
        if (this.party == null) {
            switch (this.partyType) {
                case UNKNOWN: {
                    this.party = new AbstractParty();
                    break;
                }
                case INDIVIDUAL: {
                    this.party = new DefaultIndividual();
                    break;
                }
                case ORGANISATION: {
                    this.party = new DefaultOrganisation();
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.partyType);
                }
            }
        }
        return this.party;
    }

    private DefaultLegalConstraints constraints() {
        if (this.constraints == null) {
            this.constraints = new DefaultLegalConstraints();
        }
        return this.constraints;
    }

    private DefaultExtent extent() {
        if (this.extent == null) {
            this.extent = new DefaultExtent();
        }
        return this.extent;
    }

    private DefaultAcquisitionInformation acquisition() {
        if (this.acquisition == null) {
            this.acquisition = new DefaultAcquisitionInformation();
        }
        return this.acquisition;
    }

    private DefaultPlatform platform() {
        if (this.platform == null) {
            this.platform = new DefaultPlatform();
        }
        return this.platform;
    }

    private DefaultFeatureCatalogueDescription featureDescription() {
        if (this.featureDescription == null) {
            this.featureDescription = new DefaultFeatureCatalogueDescription();
            this.featureDescription.setIncludedWithDataset(true);
        }
        return this.featureDescription;
    }

    private DefaultCoverageDescription coverageDescription() {
        if (this.coverageDescription == null) {
            this.coverageDescription = this.electromagnetic ? new DefaultImageDescription() : new DefaultCoverageDescription();
        }
        return this.coverageDescription;
    }

    private DefaultAttributeGroup attributeGroup() {
        if (this.attributeGroup == null) {
            this.attributeGroup = new DefaultAttributeGroup();
        }
        return this.attributeGroup;
    }

    private DefaultSampleDimension sampleDimension() {
        if (this.sampleDimension == null) {
            this.sampleDimension = new DefaultSampleDimension();
        }
        return this.sampleDimension;
    }

    private DefaultGridSpatialRepresentation gridRepresentation() {
        if (this.gridRepresentation == null) {
            switch (this.gridType) {
                case GEORECTIFIED: {
                    this.gridRepresentation = new DefaultGeorectified();
                    break;
                }
                case GEOREFERENCEABLE: {
                    this.gridRepresentation = new DefaultGeoreferenceable();
                    break;
                }
                default: {
                    this.gridRepresentation = new DefaultGridSpatialRepresentation();
                }
            }
        }
        return this.gridRepresentation;
    }

    private DefaultGCPCollection groundControlPoints() {
        if (this.groundControlPoints == null) {
            this.groundControlPoints = new DefaultGCPCollection();
        }
        return this.groundControlPoints;
    }

    private DefaultDistribution distribution() {
        if (this.distribution == null) {
            this.distribution = new DefaultDistribution();
        }
        return this.distribution;
    }

    private DefaultFormat format() {
        DefaultFormat defaultFormat = DefaultFormat.castOrCopy(this.format);
        if (defaultFormat == null) {
            defaultFormat = new DefaultFormat();
            this.format = defaultFormat;
        }
        return defaultFormat;
    }

    private DefaultLineage lineage() {
        if (this.lineage == null) {
            this.lineage = new DefaultLineage();
        }
        return this.lineage;
    }

    private DefaultProcessStep processStep() {
        if (this.processStep == null) {
            this.processStep = new DefaultProcessStep();
        }
        return this.processStep;
    }

    private DefaultProcessing processing() {
        if (this.processing == null) {
            this.processing = new DefaultProcessing();
        }
        return this.processing;
    }

    private static <E> void addIfNotPresent(Collection<E> collection, E e) {
        if (!collection.contains(e)) {
            collection.add(e);
        }
    }

    public final void newParty(PartyType partyType) {
        ArgumentChecks.ensureNonNull("type", (Object)partyType);
        if (this.party != null) {
            MetadataBuilder.addIfNotPresent(this.responsibility().getParties(), this.party);
            this.party = null;
        }
        this.partyType = partyType;
    }

    public final void newIdentification() {
        this.newParty(PartyType.UNKNOWN);
        if (this.responsibility != null) {
            MetadataBuilder.addIfNotPresent(this.citation().getCitedResponsibleParties(), this.responsibility);
            this.responsibility = null;
        }
        if (this.citation != null) {
            this.identification().setCitation(this.citation);
            this.citation = null;
        }
        if (this.extent != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getExtents(), this.extent);
            this.extent = null;
        }
        if (this.format != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getResourceFormats(), this.format);
            this.format = null;
        }
        if (this.constraints != null) {
            MetadataBuilder.addIfNotPresent(this.identification().getResourceConstraints(), this.constraints);
            this.constraints = null;
        }
        if (this.identification != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getIdentificationInfo(), this.identification);
            this.identification = null;
        }
    }

    public final void newAcquisition() {
        if (this.platform != null) {
            MetadataBuilder.addIfNotPresent(this.acquisition().getPlatforms(), this.platform);
        }
        if (this.acquisition != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getAcquisitionInformation(), this.acquisition);
            this.acquisition = null;
        }
    }

    public final void newDistribution() {
        if (this.distribution != null) {
            this.metadata().setDistributionInfo(this.distribution);
            this.distribution = null;
        }
    }

    public final void newFeatureTypes() {
        if (this.featureDescription != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getContentInfo(), this.featureDescription);
            this.featureDescription = null;
        }
    }

    public final void newCoverage(boolean bl) {
        this.newSampleDimension();
        if (this.attributeGroup != null) {
            MetadataBuilder.addIfNotPresent(this.coverageDescription().getAttributeGroups(), this.attributeGroup);
            this.attributeGroup = null;
        }
        if (this.coverageDescription != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getContentInfo(), this.coverageDescription);
            this.coverageDescription = null;
        }
        this.electromagnetic = bl;
    }

    public final void newSampleDimension() {
        if (this.sampleDimension != null) {
            MetadataBuilder.addIfNotPresent(this.attributeGroup().getAttributes(), this.sampleDimension);
            this.sampleDimension = null;
        }
    }

    public final void newGridRepresentation(GridType gridType) {
        ArgumentChecks.ensureNonNull("type", (Object)gridType);
        if (this.gridRepresentation != null) {
            int n = this.gridRepresentation.getAxisDimensionProperties().size();
            if (n != 0) {
                this.gridRepresentation.setNumberOfDimensions(this.shared(n));
            }
            if (this.groundControlPoints != null && this.gridRepresentation instanceof DefaultGeoreferenceable) {
                MetadataBuilder.addIfNotPresent(((DefaultGeoreferenceable)this.gridRepresentation).getGeolocationInformation(), this.groundControlPoints);
                this.groundControlPoints = null;
            }
            MetadataBuilder.addIfNotPresent(this.metadata.getSpatialRepresentationInfo(), this.gridRepresentation);
            this.gridRepresentation = null;
        }
        this.gridType = gridType;
    }

    public final void newLineage() {
        if (this.processing != null) {
            this.processStep().setProcessingInformation(this.processing);
            this.processing = null;
        }
        if (this.processStep != null) {
            MetadataBuilder.addIfNotPresent(this.lineage().getProcessSteps(), this.processStep);
            this.processStep = null;
        }
        if (this.lineage != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getResourceLineages(), this.lineage);
            this.lineage = null;
        }
    }

    private Citation sharedCitation(InternationalString internationalString) {
        if (internationalString == null) {
            return null;
        }
        Citation citation = (Citation)this.sharedValues.get(internationalString);
        if (citation == null) {
            citation = new DefaultCitation(internationalString);
            this.sharedValues.put(internationalString, citation);
        }
        return citation;
    }

    private Identifier sharedIdentifier(CharSequence charSequence, String string) {
        DefaultIdentifier defaultIdentifier = new DefaultIdentifier(this.sharedCitation(MetadataBuilder.trim(charSequence)), string);
        return JDK8.getOrDefault(this.sharedValues, defaultIdentifier, defaultIdentifier);
    }

    public final void addIdentifier(CharSequence charSequence, String string, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (string != null && !(string = string.trim()).isEmpty()) {
            Identifier identifier = this.sharedIdentifier(charSequence, string);
            if (scope != Scope.RESOURCE) {
                this.metadata().setMetadataIdentifier(identifier);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addIfNotPresent(this.citation().getIdentifiers(), identifier);
            }
        }
    }

    public final void setFormat(String string) throws MetadataStoreException {
        if (string != null && string.length() != 0 && this.format == null) {
            this.format = MetadataSource.getProvided().lookup(Format.class, string);
            this.format = DefaultFormat.castOrCopy(this.format);
        }
    }

    public final void addLanguage(Locale locale, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (locale != null) {
            if (scope != Scope.RESOURCE) {
                this.metadata().getLanguages().add(locale);
            }
            if (scope != Scope.METADATA) {
                this.identification().getLanguages().add(locale);
            }
        }
    }

    public final void addEncoding(Charset charset, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (charset != null) {
            if (scope != Scope.RESOURCE) {
                this.metadata().getCharacterSets().add(charset);
            }
            if (scope != Scope.METADATA) {
                this.identification().getCharacterSets().add(Types.forCodeName(CharacterSet.class, charset.toString(), true));
            }
        }
    }

    public final void addResourceScope(ScopeCode scopeCode, CharSequence charSequence) {
        if (scopeCode != null || charSequence != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getMetadataScopes(), new DefaultMetadataScope(scopeCode, charSequence));
        }
    }

    public final void addCitationDate(Date date, DateType dateType, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (date != null) {
            DefaultCitationDate defaultCitationDate = new DefaultCitationDate(date, dateType);
            if (scope != Scope.RESOURCE) {
                MetadataBuilder.addEarliest(this.metadata().getDateInfo(), defaultCitationDate, dateType);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addEarliest(this.citation().getDates(), defaultCitationDate, dateType);
            }
        }
    }

    private static void addEarliest(Collection<CitationDate> collection, CitationDate citationDate, DateType dateType) {
        Iterator<CitationDate> iterator = collection.iterator();
        while (iterator.hasNext()) {
            CitationDate citationDate2 = iterator.next();
            if (!dateType.equals(citationDate2.getDateType())) continue;
            Date date = citationDate2.getDate();
            Date date2 = citationDate.getDate();
            if (dateType.name().startsWith("LATE_") ? date.before(date2) : date.after(date2)) {
                iterator.remove();
                break;
            }
            return;
        }
        collection.add(citationDate);
    }

    private static InternationalString trim(CharSequence charSequence) {
        if ((charSequence = CharSequences.trimWhitespaces(charSequence)) != null && charSequence.length() != 0) {
            return Types.toInternationalString(charSequence);
        }
        return null;
    }

    private static InternationalString append(InternationalString internationalString, InternationalString internationalString2) {
        String string;
        if (internationalString == null) {
            return internationalString2;
        }
        String string2 = internationalString.toString();
        if (string2.contains(string = internationalString2.toString())) {
            return internationalString;
        }
        return Types.toInternationalString(string2 + System.lineSeparator() + string);
    }

    private static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        return charSequence.toString().equals(charSequence2.toString());
    }

    public final void addTitle(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultCitation defaultCitation = this.citation();
            InternationalString internationalString2 = defaultCitation.getTitle();
            if (internationalString2 == null) {
                defaultCitation.setTitle(internationalString);
            } else if (!MetadataBuilder.equals(internationalString2, internationalString)) {
                MetadataBuilder.addIfNotPresent(defaultCitation.getAlternateTitles(), internationalString);
            }
        }
    }

    public final void addTitleOrIdentifier(String string, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (scope != Scope.METADATA && (this.citation == null || this.citation.getTitle() == null)) {
            this.addTitle(string);
            if (scope == Scope.RESOURCE) {
                return;
            }
            scope = Scope.METADATA;
        }
        this.addIdentifier(null, string, scope);
    }

    public final void addEdition(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultCitation defaultCitation = this.citation();
            defaultCitation.setEdition(MetadataBuilder.append(defaultCitation.getEdition(), internationalString));
        }
    }

    public final void addAbstract(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultDataIdentification defaultDataIdentification = this.identification();
            defaultDataIdentification.setAbstract(MetadataBuilder.append(defaultDataIdentification.getAbstract(), internationalString));
        }
    }

    public final void addPurpose(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultDataIdentification defaultDataIdentification = this.identification();
            defaultDataIdentification.setPurpose(MetadataBuilder.append(defaultDataIdentification.getPurpose(), internationalString));
        }
    }

    public final void addOtherCitationDetails(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultCitation defaultCitation = this.citation();
            defaultCitation.setOtherCitationDetails(MetadataBuilder.append(defaultCitation.getOtherCitationDetails(), internationalString));
        }
    }

    public final void addSupplementalInformation(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultDataIdentification defaultDataIdentification = this.identification();
            defaultDataIdentification.setSupplementalInformation(MetadataBuilder.append(defaultDataIdentification.getSupplementalInformation(), internationalString));
        }
    }

    public final void addTopicCategory(TopicCategory topicCategory) {
        if (topicCategory != null) {
            this.identification().getTopicCategories().add(topicCategory);
        }
    }

    public final void addKeywords(Iterable<? extends CharSequence> iterable, KeywordType keywordType, CharSequence charSequence) {
        if (iterable != null) {
            DefaultKeywords defaultKeywords = null;
            Collection<InternationalString> collection = null;
            for (CharSequence charSequence2 : iterable) {
                InternationalString internationalString = MetadataBuilder.trim(charSequence2);
                if (internationalString == null) continue;
                if (collection == null) {
                    defaultKeywords = new DefaultKeywords();
                    defaultKeywords.setType(keywordType);
                    defaultKeywords.setThesaurusName(this.sharedCitation(MetadataBuilder.trim(charSequence)));
                    collection = defaultKeywords.getKeywords();
                }
                collection.add(internationalString);
            }
            if (defaultKeywords != null) {
                MetadataBuilder.addIfNotPresent(this.identification().getDescriptiveKeywords(), defaultKeywords);
            }
        }
    }

    public final void addAuthor(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            InternationalString internationalString2;
            if (this.party != null && (internationalString2 = this.party.getName()) != null) {
                if (MetadataBuilder.equals(internationalString2, charSequence)) {
                    return;
                }
                this.newParty(this.partyType);
            }
            this.party().setName(internationalString);
        }
    }

    public final void addCitedResponsibleParty(ResponsibleParty responsibleParty, Role role) {
        if (responsibleParty != null) {
            if (role != null && !role.equals(responsibleParty.getRole())) {
                responsibleParty = new DefaultResponsibleParty(responsibleParty);
                ((DefaultResponsibility)((Object)responsibleParty)).setRole(role);
            }
            MetadataBuilder.addIfNotPresent(this.citation().getCitedResponsibleParties(), responsibleParty);
        }
    }

    public final void addPointOfContact(ResponsibleParty responsibleParty, Scope scope) {
        ArgumentChecks.ensureNonNull("scope", (Object)scope);
        if (responsibleParty != null) {
            if (scope != Scope.RESOURCE) {
                MetadataBuilder.addIfNotPresent(this.metadata().getContacts(), responsibleParty);
            }
            if (scope != Scope.METADATA) {
                MetadataBuilder.addIfNotPresent(this.identification().getPointOfContacts(), responsibleParty);
            }
        }
    }

    public final void addDistributor(ResponsibleParty responsibleParty) {
        if (responsibleParty != null) {
            MetadataBuilder.addIfNotPresent(this.distribution().getDistributors(), new DefaultDistributor(responsibleParty));
        }
    }

    public final void addCredits(CharSequence charSequence) {
        String string;
        if (charSequence != null && !(string = CharSequences.trimWhitespaces(charSequence).toString()).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.identification().getCredits(), string);
        }
    }

    public final void parseLegalNotice(String string) {
        if (string != null) {
            LegalSymbols.parse(string, this.constraints());
        }
    }

    public final void addAccessConstraint(Restriction restriction) {
        if (restriction != null) {
            this.constraints().getAccessConstraints().add(restriction);
        }
    }

    public final void addUseLimitation(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            MetadataBuilder.addIfNotPresent(this.constraints().getUseLimitations(), internationalString);
        }
    }

    public final void addReferenceSystem(ReferenceSystem referenceSystem) {
        if (referenceSystem != null) {
            MetadataBuilder.addIfNotPresent(this.metadata().getReferenceSystemInfo(), referenceSystem);
        }
    }

    public final void addBoundingPolygon(Geometry geometry) {
        if (geometry != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), new DefaultBoundingPolygon(geometry));
        }
    }

    public final void addExtent(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), new DefaultGeographicDescription(charSequence));
        }
    }

    public final void addExtent(AbstractEnvelope abstractEnvelope) throws TransformException {
        if (abstractEnvelope != null) {
            this.addReferenceSystem(abstractEnvelope.getCoordinateReferenceSystem());
            if (!abstractEnvelope.isAllNaN()) {
                this.extent().addElements(abstractEnvelope);
            }
        }
    }

    public final void addExtent(double[] dArray, int n) {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox;
        if (dArray != null && !(defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(dArray[n], dArray[++n], dArray[++n], dArray[++n])).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.extent().getGeographicElements(), defaultGeographicBoundingBox);
        }
    }

    public final void addVerticalExtent(double d, double d2, VerticalCRS verticalCRS) {
        if (!Double.isNaN(d) || !Double.isNaN(d2) || verticalCRS != null) {
            MetadataBuilder.addIfNotPresent(this.extent().getVerticalElements(), new DefaultVerticalExtent(d, d2, verticalCRS));
        }
    }

    public final void addTemporalExtent(Date date, Date date2) {
        if (date != null || date2 != null) {
            DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent();
            defaultTemporalExtent.setBounds(date, date2);
            MetadataBuilder.addIfNotPresent(this.extent().getTemporalElements(), defaultTemporalExtent);
        }
    }

    public final GenericName addFeatureType(DefaultFeatureType defaultFeatureType, Integer n) {
        GenericName genericName;
        if (defaultFeatureType != null && (genericName = defaultFeatureType.getName()) != null) {
            DefaultFeatureTypeInfo defaultFeatureTypeInfo = new DefaultFeatureTypeInfo(genericName);
            if (n != null) {
                defaultFeatureTypeInfo.setFeatureInstanceCount(this.shared(n));
            }
            MetadataBuilder.addIfNotPresent(this.featureDescription().getFeatureTypeInfo(), defaultFeatureTypeInfo);
            return genericName;
        }
        return null;
    }

    public final void addSpatialRepresentation(SpatialRepresentationType spatialRepresentationType) {
        if (spatialRepresentationType != null) {
            this.identification().getSpatialRepresentationTypes().add(spatialRepresentationType);
        }
    }

    public final void addResolution(double d) {
        if (!Double.isNaN(d)) {
            DefaultResolution defaultResolution = new DefaultResolution();
            defaultResolution.setDistance(this.shared(d));
            MetadataBuilder.addIfNotPresent(this.identification().getSpatialResolutions(), defaultResolution);
        }
    }

    public final void setCellGeometry(CellGeometry cellGeometry) {
        if (cellGeometry != null) {
            this.gridRepresentation().setCellGeometry(cellGeometry);
        }
    }

    public final void setPointInPixel(PixelOrientation pixelOrientation) {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation;
        if (pixelOrientation != null && (defaultGridSpatialRepresentation = this.gridRepresentation()) instanceof DefaultGeorectified) {
            ((DefaultGeorectified)defaultGridSpatialRepresentation).setPointInPixel(pixelOrientation);
        }
    }

    public final void setGeoreferencingAvailability(boolean bl, boolean bl2, boolean bl3) {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation = this.gridRepresentation();
        defaultGridSpatialRepresentation.setTransformationParameterAvailable(bl);
        if (defaultGridSpatialRepresentation instanceof DefaultGeorectified) {
            ((DefaultGeorectified)defaultGridSpatialRepresentation).setCheckPointAvailable(bl2);
        } else if (defaultGridSpatialRepresentation instanceof DefaultGeoreferenceable) {
            ((DefaultGeoreferenceable)defaultGridSpatialRepresentation).setControlPointAvailable(bl2);
            ((DefaultGeoreferenceable)defaultGridSpatialRepresentation).setOrientationParameterAvailable(bl3);
        }
    }

    public final void addGeolocation(GeolocationInformation geolocationInformation) {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation;
        if (geolocationInformation != null && (defaultGridSpatialRepresentation = this.gridRepresentation()) instanceof DefaultGeoreferenceable) {
            MetadataBuilder.addIfNotPresent(((DefaultGeoreferenceable)defaultGridSpatialRepresentation).getGeolocationInformation(), geolocationInformation);
        }
    }

    public final void addControlPoints(DirectPosition directPosition, Element element) {
        if (directPosition != null) {
            Collection<GCP> collection;
            DefaultGridSpatialRepresentation defaultGridSpatialRepresentation = this.gridRepresentation();
            if (defaultGridSpatialRepresentation instanceof DefaultGeorectified) {
                collection = ((DefaultGeorectified)defaultGridSpatialRepresentation).getCheckPoints();
            } else if (defaultGridSpatialRepresentation instanceof DefaultGeoreferenceable) {
                collection = this.groundControlPoints().getGCPs();
            } else {
                return;
            }
            DefaultGCP defaultGCP = new DefaultGCP();
            defaultGCP.setGeographicCoordinates(directPosition);
            if (element != null) {
                MetadataBuilder.addIfNotPresent(defaultGCP.getAccuracyReports(), element);
            }
            MetadataBuilder.addIfNotPresent(collection, defaultGCP);
        }
    }

    public final void setGridToCRS(CharSequence charSequence) {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation;
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null && (defaultGridSpatialRepresentation = this.gridRepresentation()) instanceof DefaultGeorectified) {
            ((DefaultGeorectified)defaultGridSpatialRepresentation).setTransformationDimensionDescription(internationalString);
        }
    }

    private DefaultDimension axis(int n) {
        List<Dimension> list = this.gridRepresentation().getAxisDimensionProperties();
        for (int i = list.size(); i <= n; ++i) {
            list.add(new DefaultDimension());
        }
        return (DefaultDimension)list.get(n);
    }

    public final void setAxisName(int n, DimensionNameType dimensionNameType) {
        this.axis(n).setDimensionName(dimensionNameType);
    }

    public final void setAxisLength(int n, int n2) {
        this.axis(n).setDimensionSize(this.shared(n2));
    }

    public final void setAxisResolution(int n, double d) {
        if (!Double.isNaN(d)) {
            this.axis(n).setResolution(this.shared(d));
        }
    }

    public final void addContentType(CoverageContentType coverageContentType) {
        if (coverageContentType != null) {
            this.attributeGroup().getContentTypes().add(coverageContentType);
        }
    }

    public final void setBandIdentifier(MemberName memberName) {
        if (memberName != null) {
            this.sampleDimension().setSequenceIdentifier(memberName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void setBandIdentifier(int n) {
        MemberName[] memberNameArray;
        if (n <= 0) return;
        boolean bl = n <= BAND_NUMBERS.length;
        MemberName memberName = null;
        if (bl) {
            memberNameArray = BAND_NUMBERS;
            // MONITORENTER : BAND_NUMBERS
            memberName = BAND_NUMBERS[n - 1];
            // MONITOREXIT : memberNameArray
        }
        if (memberName == null) {
            memberName = Names.createMemberName(null, null, String.valueOf(n), Integer.class);
            if (bl) {
                memberNameArray = BAND_NUMBERS;
                // MONITORENTER : BAND_NUMBERS
                MetadataBuilder.BAND_NUMBERS[n - 1] = memberName;
                // MONITOREXIT : memberNameArray
            }
        }
        this.setBandIdentifier(memberName);
    }

    public final void addBandName(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            MetadataBuilder.addIfNotPresent(this.sampleDimension().getNames(), this.sharedIdentifier(charSequence, string));
        }
    }

    public final void addBandDescription(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultSampleDimension defaultSampleDimension = this.sampleDimension();
            defaultSampleDimension.setDescription(MetadataBuilder.append(defaultSampleDimension.getDescription(), internationalString));
        }
    }

    public void addSampleValueDescription(CharSequence charSequence, CharSequence charSequence2) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        InternationalString internationalString2 = MetadataBuilder.trim(charSequence2);
        if (internationalString != null && internationalString2 != null) {
            DefaultRangeElementDescription defaultRangeElementDescription = new DefaultRangeElementDescription();
            defaultRangeElementDescription.setName(internationalString);
            defaultRangeElementDescription.setDefinition(internationalString2);
            MetadataBuilder.addIfNotPresent(this.coverageDescription().getRangeElementDescriptions(), defaultRangeElementDescription);
        }
    }

    public final void addMinimumSampleValue(double d) {
        DefaultSampleDimension defaultSampleDimension;
        Double d2;
        if (!Double.isNaN(d) && ((d2 = (defaultSampleDimension = this.sampleDimension()).getMinValue()) == null || d < d2)) {
            defaultSampleDimension.setMinValue(this.shared(d));
        }
    }

    public final void addMaximumSampleValue(double d) {
        DefaultSampleDimension defaultSampleDimension;
        Double d2;
        if (!Double.isNaN(d) && ((d2 = (defaultSampleDimension = this.sampleDimension()).getMaxValue()) == null || d > d2)) {
            defaultSampleDimension.setMaxValue(this.shared(d));
        }
    }

    public final void setSampleUnits(Unit<?> unit) {
        if (unit != null) {
            this.sampleDimension().setUnits(unit);
        }
    }

    public final void setTransferFunction(double d, double d2) {
        if (!Double.isNaN(d) || !Double.isNaN(d2)) {
            DefaultSampleDimension defaultSampleDimension = this.sampleDimension();
            if (!Double.isNaN(d)) {
                defaultSampleDimension.setScaleFactor(d);
            }
            if (!Double.isNaN(d2)) {
                defaultSampleDimension.setOffset(d2);
            }
            defaultSampleDimension.setTransferFunctionType(TransferFunctionType.LINEAR);
        }
    }

    public final void setBitPerSample(int n) {
        this.sampleDimension().setBitsPerValue(n);
    }

    public final void setProcessingLevelCode(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            this.coverageDescription().setProcessingLevelCode(this.sharedIdentifier(charSequence, string));
        }
    }

    public final void setCloudCoverPercentage(double d) {
        if (!Double.isNaN(d)) {
            ((DefaultImageDescription)this.coverageDescription()).setCloudCoverPercentage(this.shared(d));
        }
    }

    public final void setIlluminationAzimuthAngle(double d) {
        if (!Double.isNaN(d)) {
            ((DefaultImageDescription)this.coverageDescription()).setIlluminationAzimuthAngle(this.shared(d));
        }
    }

    public final void setIlluminationElevationAngle(double d) {
        if (!Double.isNaN(d)) {
            ((DefaultImageDescription)this.coverageDescription()).setIlluminationElevationAngle(this.shared(d));
        }
    }

    public final void addPlatform(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            Identifier identifier;
            if (this.platform != null && (identifier = this.platform.getIdentifier()) != null) {
                if (string.equals(identifier.getCode())) {
                    return;
                }
                this.acquisition().getPlatforms().add(this.platform);
                this.platform = null;
            }
            this.platform().setIdentifier(this.sharedIdentifier(charSequence, string));
        }
    }

    public final void addInstrument(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            DefaultInstrument defaultInstrument = new DefaultInstrument();
            defaultInstrument.setIdentifier(this.sharedIdentifier(charSequence, string));
            MetadataBuilder.addIfNotPresent(this.platform().getInstruments(), defaultInstrument);
        }
    }

    public final void addAcquisitionTime(Date date) {
        if (date != null) {
            DefaultEvent defaultEvent = new DefaultEvent();
            defaultEvent.setContext(Context.ACQUISITION);
            defaultEvent.setTime(date);
            DefaultOperation defaultOperation = new DefaultOperation();
            defaultOperation.setSignificantEvents(Collections.singleton(defaultEvent));
            defaultOperation.setType(OperationType.REAL);
            defaultOperation.setStatus(Progress.COMPLETED);
            MetadataBuilder.addIfNotPresent(this.acquisition().getOperations(), defaultOperation);
        }
    }

    public final void addAcquisitionOperation(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            DefaultOperation defaultOperation = new DefaultOperation();
            defaultOperation.setIdentifier(this.sharedIdentifier(charSequence, string));
            MetadataBuilder.addIfNotPresent(this.acquisition().getOperations(), defaultOperation);
        }
    }

    public final void addAcquisitionRequirement(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            DefaultRequirement defaultRequirement = new DefaultRequirement();
            defaultRequirement.setIdentifier(this.sharedIdentifier(charSequence, string));
            MetadataBuilder.addIfNotPresent(this.acquisition().getAcquisitionRequirements(), defaultRequirement);
        }
    }

    public final void addProcessing(CharSequence charSequence, String string) {
        if (string != null && !(string = string.trim()).isEmpty()) {
            Identifier identifier;
            if (this.processing != null && (identifier = this.processing.getIdentifier()) != null) {
                if (string.equals(identifier.getCode())) {
                    return;
                }
                this.processStep().setProcessingInformation(this.processing);
                MetadataBuilder.addIfNotPresent(this.lineage().getProcessSteps(), this.processStep);
                this.processing = null;
                this.processStep = null;
            }
            this.processing().setIdentifier(this.sharedIdentifier(charSequence, string));
        }
    }

    public final void addSoftwareReference(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            MetadataBuilder.addIfNotPresent(this.processing().getSoftwareReferences(), this.sharedCitation(internationalString));
        }
    }

    public final void addHostComputer(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            internationalString = Resources.formatInternational((short)12, internationalString);
            DefaultProcessing defaultProcessing = this.processing();
            defaultProcessing.setProcedureDescription(MetadataBuilder.append(defaultProcessing.getProcedureDescription(), internationalString));
        }
    }

    public final void addProcessDescription(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultProcessStep defaultProcessStep = this.processStep();
            defaultProcessStep.setDescription(MetadataBuilder.append(defaultProcessStep.getDescription(), internationalString));
        }
    }

    public final void addCompression(CharSequence charSequence) {
        InternationalString internationalString = MetadataBuilder.trim(charSequence);
        if (internationalString != null) {
            DefaultFormat defaultFormat = this.format();
            defaultFormat.setFileDecompressionTechnique(MetadataBuilder.append(defaultFormat.getFileDecompressionTechnique(), internationalString));
        }
    }

    public final void addCompleteMetadata(URI uRI) {
        if (uRI != null) {
            DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(uRI);
            defaultOnlineResource.setFunction(OnLineFunction.valueOf("COMPLETE_METADATA"));
            defaultOnlineResource.setProtocol(uRI.getScheme());
            MetadataBuilder.addIfNotPresent(this.metadata().getMetadataLinkages(), defaultOnlineResource);
        }
    }

    public final DefaultMetadata build(boolean bl) {
        this.newIdentification();
        this.newGridRepresentation(GridType.UNSPECIFIED);
        this.newFeatureTypes();
        this.newCoverage(false);
        this.newAcquisition();
        this.newDistribution();
        DefaultMetadata defaultMetadata = this.metadata;
        this.metadata = null;
        if (bl && defaultMetadata != null) {
            defaultMetadata.freeze();
        }
        return defaultMetadata;
    }

    public final Double shared(Double d) {
        Double d2 = JDK8.putIfAbsent(this.sharedValues, d, d);
        return d2 != null ? d2 : d;
    }

    public final Integer shared(Integer n) {
        Integer n2 = JDK8.putIfAbsent(this.sharedValues, n, n);
        return n2 != null ? n2 : n;
    }

    private static final class LegalSymbols {
        private static final LegalSymbols[] VALUES = new LegalSymbols[]{new LegalSymbols(Restriction.COPYRIGHT, "COPYRIGHT", "(C)", "\u00a9", "All rights reserved"), new LegalSymbols(Restriction.TRADEMARK, "TRADEMARK", "(TM)", "\u2122", "(R)", "\u00ae")};
        private final Restriction restriction;
        private final String[] symbols;

        private LegalSymbols(Restriction restriction, String ... stringArray) {
            this.restriction = restriction;
            this.symbols = stringArray;
        }

        private static boolean isSpaceOrPunctuation(int n) {
            switch (Character.getType(n)) {
                case 12: 
                case 13: 
                case 14: 
                case 24: {
                    return true;
                }
            }
            return false;
        }

        static void parse(String string, DefaultLegalConstraints defaultLegalConstraints) {
            int n;
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            int n5 = 0;
            block8: while (n5 < n2) {
                boolean bl5;
                n = string.codePointAt(n5);
                int n6 = Character.charCount(n);
                int n7 = 0;
                boolean bl6 = false;
                switch (Character.getType(n)) {
                    case 21: 
                    case 29: {
                        n7 = 1;
                        bl4 = false;
                        bl5 = false;
                        break;
                    }
                    case 22: 
                    case 30: {
                        n7 = -1;
                        bl4 = false;
                        bl5 = false;
                        break;
                    }
                    default: {
                        bl4 = false;
                        bl5 = false;
                        break;
                    }
                    case 24: {
                        bl5 = true;
                        bl6 = true;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        bl5 = bl3;
                        bl6 = true;
                    }
                }
                if (bl2 && !bl6 && n4 == 0) {
                    LegalSymbols[] legalSymbolsArray = VALUES;
                    int n8 = legalSymbolsArray.length;
                    for (int i = 0; i < n8; ++i) {
                        LegalSymbols legalSymbols = legalSymbolsArray[i];
                        for (String string2 : legalSymbols.symbols) {
                            int n9;
                            if (!string.regionMatches(true, n5, string2, 0, string2.length()) || (n9 = n5 + string2.length()) < n2 && !LegalSymbols.isSpaceOrPunctuation(string.codePointAt(n9))) continue;
                            bl |= Restriction.COPYRIGHT.equals(legalSymbols.restriction);
                            defaultLegalConstraints.getUseConstraints().add(legalSymbols.restriction);
                            bl3 = true;
                            bl4 = true;
                            n5 = n9;
                            continue block8;
                        }
                    }
                    if (bl && bl3 && n3 == 0 && n >= 48 && n <= 57) {
                        int n10;
                        for (n10 = n5 + n6; n10 < n2 && (n8 = string.codePointAt(n10)) >= 48 && n8 <= 57; ++n10) {
                        }
                        n8 = CharSequences.skipLeadingWhitespaces(string, n10, n2);
                        if (n8 > n10 || LegalSymbols.isSpaceOrPunctuation(string.codePointAt(n8))) {
                            try {
                                n3 = Integer.parseInt(string.substring(n5, n10));
                                if (n3 >= 1800 && n3 <= 9999) {
                                    bl4 = true;
                                    n5 = n8;
                                    continue;
                                }
                                n3 = 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
                bl3 = bl5;
                bl2 = bl6;
                n4 += n7;
                if (!bl4 && !Character.isIdentifierIgnorable(n)) {
                    stringBuilder.appendCodePoint(n);
                }
                n5 += n6;
            }
            for (n5 = stringBuilder.length(); n5 > 0 && LegalSymbols.isSpaceOrPunctuation(n = stringBuilder.codePointBefore(n5)); n5 -= Character.charCount(n)) {
            }
            DefaultCitation defaultCitation = new DefaultCitation(string);
            if (n3 != 0) {
                Date date = new Date(LocalDate.of(n3, 1, 1).toEpochDay() * 86400000L);
                defaultCitation.setDates(Collections.singleton(new DefaultCitationDate(date, DateType.valueOf("IN_FORCE"))));
            }
            if (n5 != 0) {
                stringBuilder.setLength(n5);
                AbstractParty abstractParty = new AbstractParty(stringBuilder, null);
                DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.OWNER);
                defaultResponsibleParty.setParties(Collections.singleton(abstractParty));
                defaultCitation.setCitedResponsibleParties(Collections.singleton(defaultResponsibleParty));
            }
            defaultLegalConstraints.getReferences().add(defaultCitation);
        }
    }

    public static enum Scope {
        RESOURCE,
        METADATA,
        ALL;

    }

    public static enum GridType {
        GEORECTIFIED,
        GEOREFERENCEABLE,
        UNSPECIFIED;

    }

    public static enum PartyType {
        INDIVIDUAL,
        ORGANISATION,
        UNKNOWN;

    }
}

