/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.TypeDescription_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class TypeSystemDescription_impl
extends MetaDataObject_impl
implements TypeSystemDescription {
    static final long serialVersionUID = -3372766232454730201L;
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = Import.EMPTY_IMPORTS;
    private TypeDescription[] mTypes = new TypeDescription[0];
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("typeSystemDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("types", true)});

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public Import[] getImports() {
        return this.mImports;
    }

    @Override
    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    @Override
    public TypeDescription[] getTypes() {
        return this.mTypes;
    }

    @Override
    public void setTypes(TypeDescription[] aTypes) {
        if (aTypes == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aTypes", "setTypes"});
        }
        this.mTypes = aTypes;
    }

    @Override
    public TypeDescription addType(String aTypeName, String aDescription, String aSupertypeName) {
        TypeDescription_impl newType = new TypeDescription_impl(aTypeName, aDescription, aSupertypeName);
        TypeDescription[] types = this.getTypes();
        if (types == null) {
            this.setTypes(new TypeDescription[]{newType});
        } else {
            TypeDescription[] newArray = new TypeDescription[types.length + 1];
            System.arraycopy(types, 0, newArray, 0, types.length);
            newArray[types.length] = newType;
            this.setTypes(newArray);
        }
        return newType;
    }

    @Override
    public TypeDescription getType(String aTypeName) {
        for (int i = 0; i < this.mTypes.length; ++i) {
            if (!aTypeName.equals(this.mTypes[i].getName())) continue;
            return this.mTypes[i];
        }
        return null;
    }

    @Override
    public synchronized void resolveImports() throws InvalidXMLException {
        if (this.getImports().length == 0) {
            this.resolveImports(null, null);
        } else {
            this.resolveImports(new TreeSet<String>(), UIMAFramework.newDefaultResourceManager());
        }
    }

    @Override
    public synchronized void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(this.getImports().length == 0 ? null : new TreeSet<String>(), aResourceManager);
    }

    @Override
    public synchronized void resolveImports(Collection<String> aAlreadyImportedTypeSystemURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        TypeDescription[] existingTypes;
        ArrayList<TypeDescription> importedTypes = null;
        if (this.getImports().length != 0) {
            if (this.getSourceUrl() != null) {
                aAlreadyImportedTypeSystemURLs.add(this.getSourceUrl().toString());
            }
            importedTypes = new ArrayList<TypeDescription>();
            Import[] imports = this.getImports();
            for (int i = 0; i < imports.length; ++i) {
                URL url;
                if (imports[i] instanceof Import_impl) {
                    ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
                }
                if (aAlreadyImportedTypeSystemURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
                aAlreadyImportedTypeSystemURLs.add(url.toString());
                try {
                    this.resolveImport(url, aAlreadyImportedTypeSystemURLs, importedTypes, aResourceManager);
                    continue;
                }
                catch (IOException e) {
                    throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
                }
            }
        }
        if ((existingTypes = this.getTypes()) == null) {
            existingTypes = TypeDescription.EMPTY_TYPE_DESCRIPTIONS;
            this.setTypes(TypeDescription.EMPTY_TYPE_DESCRIPTIONS);
        }
        if (null != importedTypes) {
            TypeDescription[] newTypes = new TypeDescription[existingTypes.length + importedTypes.size()];
            System.arraycopy(existingTypes, 0, newTypes, 0, existingTypes.length);
            for (int i = 0; i < importedTypes.size(); ++i) {
                newTypes[existingTypes.length + i] = (TypeDescription)importedTypes.get(i);
            }
            this.setTypes(newTypes);
        }
        this.setImports(Import.EMPTY_IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveImport(URL aURL, Collection<String> aAlreadyImportedTypeSystemURLs, Collection<TypeDescription> aResults, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        TypeSystemDescription desc;
        String urlString = aURL.toString();
        Map<String, XMLizable> importCache = ((ResourceManager_impl)aResourceManager).getImportCache();
        Map<String, Set<String>> importUrlsCache = ((ResourceManager_impl)aResourceManager).getImportUrlsCache();
        Map<String, XMLizable> map = importCache;
        synchronized (map) {
            XMLizable cachedObject = importCache.get(urlString);
            if (cachedObject instanceof TypeSystemDescription) {
                desc = (TypeSystemDescription)cachedObject;
                aAlreadyImportedTypeSystemURLs.addAll((Collection<String>)importUrlsCache.get(urlString));
            } else {
                XMLInputSource input = new XMLInputSource(aURL);
                desc = UIMAFramework.getXMLParser().parseTypeSystemDescription(input);
                TreeSet<String> previouslyImported = new TreeSet<String>(aAlreadyImportedTypeSystemURLs);
                desc.resolveImports(aAlreadyImportedTypeSystemURLs, aResourceManager);
                importCache.put(urlString, desc);
                TreeSet<String> locallyImported = new TreeSet<String>(aAlreadyImportedTypeSystemURLs);
                locallyImported.removeAll(previouslyImported);
                importUrlsCache.put(urlString, locallyImported);
            }
        }
        aResults.addAll(Arrays.asList(desc.getTypes()));
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

