/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring;

import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.util.Matrix;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Movie {
    Matrix matrix = Matrix.ROTATE_0;
    List<Track> tracks = new LinkedList<Track>();

    public Movie() {
    }

    public Movie(List<Track> tracks) {
        this.tracks = tracks;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    public void addTrack(Track nuTrack) {
        if (this.getTrackByTrackId(nuTrack.getTrackMetaData().getTrackId()) != null) {
            nuTrack.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(nuTrack);
    }

    public String toString() {
        String s = "Movie{ ";
        for (Track track : this.tracks) {
            s = String.valueOf(s) + "track_" + track.getTrackMetaData().getTrackId() + " (" + track.getHandler() + ") ";
        }
        s = String.valueOf(s) + '}';
        return s;
    }

    public long getNextTrackId() {
        long nextTrackId = 0L;
        for (Track track : this.tracks) {
            long l = nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        return ++nextTrackId;
    }

    public Track getTrackByTrackId(long trackId) {
        for (Track track : this.tracks) {
            if (track.getTrackMetaData().getTrackId() != trackId) continue;
            return track;
        }
        return null;
    }

    public long getTimescale() {
        long timescale = this.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : this.getTracks()) {
            timescale = Movie.gcd(track.getTrackMetaData().getTimescale(), timescale);
        }
        return timescale;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return Movie.gcd(b, a % b);
    }
}

