/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.cenc;

import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.RangeStartMap;
import com.mp4parser.iso23001.part7.CencSampleAuxiliaryDataFormat;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CencDecryptingSampleList
extends AbstractList<Sample> {
    List<CencSampleAuxiliaryDataFormat> sencInfo;
    RangeStartMap<Integer, SecretKey> keys = new RangeStartMap();
    List<Sample> parent;
    String encryptionAlgo;

    public CencDecryptingSampleList(SecretKey secretKey, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> sencInfo) {
        this(new RangeStartMap<Integer, SecretKey>(0, secretKey), parent, sencInfo, "cenc");
    }

    public CencDecryptingSampleList(RangeStartMap<Integer, SecretKey> keys, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> sencInfo, String encryptionAlgo) {
        this.sencInfo = sencInfo;
        this.keys = keys;
        this.parent = parent;
        this.encryptionAlgo = encryptionAlgo;
    }

    Cipher getCipher(SecretKey sk, byte[] iv) {
        byte[] fullIv = new byte[16];
        System.arraycopy(iv, 0, fullIv, 0, iv.length);
        try {
            if ("cenc".equals(this.encryptionAlgo)) {
                Cipher c = Cipher.getInstance("AES/CTR/NoPadding");
                c.init(2, (Key)sk, new IvParameterSpec(fullIv));
                return c;
            }
            if ("cbc1".equals(this.encryptionAlgo)) {
                Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                c.init(2, (Key)sk, new IvParameterSpec(fullIv));
                return c;
            }
            throw new RuntimeException("Only cenc & cbc1 is supported as encryptionAlgo");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Sample get(int index) {
        if (this.keys.get(index) != null) {
            Sample encSample = this.parent.get(index);
            ByteBuffer encSampleBuffer = encSample.asByteBuffer();
            encSampleBuffer.rewind();
            ByteBuffer decSampleBuffer = ByteBuffer.allocate(encSampleBuffer.limit());
            CencSampleAuxiliaryDataFormat sencEntry = this.sencInfo.get(index);
            Cipher cipher = this.getCipher(this.keys.get(index), sencEntry.iv);
            try {
                if (sencEntry.pairs != null && sencEntry.pairs.length > 0) {
                    CencSampleAuxiliaryDataFormat.Pair[] pairArray = sencEntry.pairs;
                    int n = sencEntry.pairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CencSampleAuxiliaryDataFormat.Pair pair = pairArray[n2];
                        int clearBytes = pair.clear();
                        int encrypted = CastUtils.l2i(pair.encrypted());
                        byte[] clears = new byte[clearBytes];
                        encSampleBuffer.get(clears);
                        decSampleBuffer.put(clears);
                        if (encrypted > 0) {
                            byte[] encs = new byte[encrypted];
                            encSampleBuffer.get(encs);
                            byte[] decr = cipher.update(encs);
                            decSampleBuffer.put(decr);
                        }
                        ++n2;
                    }
                    if (encSampleBuffer.remaining() > 0) {
                        System.err.println("Decrypted sample but still data remaining: " + encSample.getSize());
                    }
                    decSampleBuffer.put(cipher.doFinal());
                } else {
                    byte[] fullyEncryptedSample = new byte[encSampleBuffer.limit()];
                    encSampleBuffer.get(fullyEncryptedSample);
                    if ("cbc1".equals(this.encryptionAlgo)) {
                        int encryptedLength = fullyEncryptedSample.length / 16 * 16;
                        decSampleBuffer.put(cipher.doFinal(fullyEncryptedSample, 0, encryptedLength));
                        decSampleBuffer.put(fullyEncryptedSample, encryptedLength, fullyEncryptedSample.length - encryptedLength);
                    } else if ("cenc".equals(this.encryptionAlgo)) {
                        decSampleBuffer.put(cipher.doFinal(fullyEncryptedSample));
                    }
                }
                encSampleBuffer.rewind();
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
            decSampleBuffer.rewind();
            return new SampleImpl(decSampleBuffer);
        }
        return this.parent.get(index);
    }

    @Override
    public int size() {
        return this.parent.size();
    }
}

