/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.cybozu.util;

import com.optimaize.langdetect.cybozu.util.LangProfile;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.ngram.OldNgramExtractor;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Util {
    private static final NgramExtractor ngramExtractor = NgramExtractors.standard();

    public static void addCharSequence(LangProfile langProfile, CharSequence text) {
        for (String s : OldNgramExtractor.extractNGrams(text, null)) {
            langProfile.add(s);
        }
    }

    public static String unicodeEncode(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '\u0080') {
                String st = Integer.toHexString(65536 + ch);
                while (st.length() < 4) {
                    st = "0" + st;
                }
                buf.append("\\u").append(st.subSequence(1, 5));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static double normalizeProb(double[] prob) {
        int i;
        double maxp = 0.0;
        double sump = 0.0;
        for (i = 0; i < prob.length; ++i) {
            sump += prob[i];
        }
        for (i = 0; i < prob.length; ++i) {
            double p = prob[i] / sump;
            if (maxp < p) {
                maxp = p;
            }
            prob[i] = p;
        }
        return maxp;
    }

    public static String wordProbToString(double[] prob, List<LdLocale> langlist) {
        Formatter formatter = new Formatter();
        for (int j = 0; j < prob.length; ++j) {
            double p = prob[j];
            if (!(p >= 1.0E-5)) continue;
            formatter.format(" %s:%.5f", langlist.get(j), p);
        }
        return formatter.toString();
    }

    public static double[] makeInternalPrioMap(@NotNull Map<LdLocale, Double> langWeightingMap, @NotNull List<LdLocale> langlist) {
        int i;
        assert (!langWeightingMap.isEmpty());
        double[] priorMap = new double[langlist.size()];
        double sump = 0.0;
        for (i = 0; i < priorMap.length; ++i) {
            LdLocale lang = langlist.get(i);
            if (!langWeightingMap.containsKey(lang)) continue;
            double p = langWeightingMap.get(lang);
            assert (p >= 0.0) : "Prior probability must be non-negative!";
            priorMap[i] = p;
            sump += p;
        }
        assert (sump > 0.0) : "Sum must be greater than zero!";
        i = 0;
        while (i < priorMap.length) {
            int n = i++;
            priorMap[n] = priorMap[n] / sump;
        }
        return priorMap;
    }
}

