/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class ZipInputStreamZipEntrySource
implements ZipEntrySource {
    private ArrayList<FakeZipEntry> zipEntries = new ArrayList();

    public ZipInputStreamZipEntrySource(ZipSecureFile.ThresholdInputStream inp) throws IOException {
        boolean going = true;
        while (going) {
            ZipEntry zipEntry = inp.getNextEntry();
            if (zipEntry == null) {
                going = false;
                continue;
            }
            FakeZipEntry entry = new FakeZipEntry(zipEntry, inp);
            inp.closeEntry();
            this.zipEntries.add(entry);
        }
        inp.close();
    }

    @Override
    public Enumeration<? extends ZipEntry> getEntries() {
        return new EntryEnumerator();
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) {
        assert (zipEntry instanceof FakeZipEntry);
        FakeZipEntry entry = (FakeZipEntry)zipEntry;
        return entry.getInputStream();
    }

    @Override
    public void close() {
        this.zipEntries = null;
    }

    @Override
    public boolean isClosed() {
        return this.zipEntries == null;
    }

    public static class FakeZipEntry
    extends ZipEntry {
        private byte[] data;

        public FakeZipEntry(ZipEntry entry, InputStream inp) throws IOException {
            super(entry.getName());
            ByteArrayOutputStream baos;
            long entrySize = entry.getSize();
            if (entrySize != -1L) {
                if (entrySize >= Integer.MAX_VALUE) {
                    throw new IOException("ZIP entry size is too large");
                }
                baos = new ByteArrayOutputStream((int)entrySize);
            } else {
                baos = new ByteArrayOutputStream();
            }
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = inp.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            this.data = baos.toByteArray();
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }
    }

    private class EntryEnumerator
    implements Enumeration<ZipEntry> {
        private Iterator<? extends ZipEntry> iterator;

        private EntryEnumerator() {
            this.iterator = ZipInputStreamZipEntrySource.this.zipEntries.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public ZipEntry nextElement() {
            return this.iterator.next();
        }
    }
}

