/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.cs.Normalizer;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="AbstractCoordinateSystemType")
@XmlRootElement(name="AbstractCoordinateSystem")
@XmlSeeAlso(value={DefaultAffineCS.class, DefaultCartesianCS.class, DefaultSphericalCS.class, DefaultEllipsoidalCS.class, DefaultCylindricalCS.class, DefaultPolarCS.class, DefaultLinearCS.class, DefaultVerticalCS.class, DefaultTimeCS.class, DefaultParametricCS.class, DefaultUserDefinedCS.class})
public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    static final int VALID = 0;
    static final int INVALID_DIRECTION = 1;
    static final int INVALID_UNIT = 2;
    private CoordinateSystemAxis[] axes;
    private transient Map<AxesConvention, AbstractCS> derived;
    private static final CoordinateSystemAxis[] EMPTY = new CoordinateSystemAxis[0];

    public AbstractCS(Map<String, ?> map, CoordinateSystemAxis ... coordinateSystemAxisArray) {
        super(map);
        ArgumentChecks.ensureNonNull("axes", coordinateSystemAxisArray);
        coordinateSystemAxisArray = (CoordinateSystemAxis[])coordinateSystemAxisArray.clone();
        this.axes = coordinateSystemAxisArray;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[i];
            ArgumentChecks.ensureNonNullElement("axes", i, coordinateSystemAxis);
            ReferenceIdentifier referenceIdentifier = coordinateSystemAxis.getName();
            ArgumentChecks.ensureNonNullElement("axes[#].name", i, referenceIdentifier);
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            ArgumentChecks.ensureNonNullElement("axes[#].direction", i, axisDirection);
            Unit<?> unit = coordinateSystemAxis.getUnit();
            ArgumentChecks.ensureNonNullElement("axes[#].unit", i, unit);
            switch (this.validateAxis(axisDirection, unit)) {
                case 1: {
                    throw new IllegalArgumentException(Resources.forProperties(map).getString((short)20, this.getClass(), axisDirection));
                }
                case 2: {
                    throw new IllegalArgumentException(Resources.forProperties(map).getString((short)26, referenceIdentifier, unit));
                }
            }
            AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
            if (axisDirection2.equals(AxisDirection.OTHER)) continue;
            int n = i;
            while (--n >= 0) {
                AxisDirection axisDirection3 = coordinateSystemAxisArray[n].getDirection();
                AxisDirection axisDirection4 = AxisDirections.absolute(axisDirection3);
                if (!axisDirection2.equals(axisDirection4) || axisDirection4.equals(AxisDirection.FUTURE)) continue;
                throw new IllegalArgumentException(Resources.forProperties(map).getString((short)10, axisDirection, axisDirection3));
            }
        }
    }

    protected AbstractCS(CoordinateSystem coordinateSystem) {
        super(coordinateSystem);
        this.axes = coordinateSystem instanceof AbstractCS ? ((AbstractCS)coordinateSystem).axes : AbstractCS.getAxes(coordinateSystem);
    }

    private static CoordinateSystemAxis[] getAxes(CoordinateSystem coordinateSystem) {
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            coordinateSystemAxisArray[i] = coordinateSystem.getAxis(i);
        }
        return coordinateSystemAxisArray;
    }

    public static AbstractCS castOrCopy(CoordinateSystem coordinateSystem) {
        return SubTypes.castOrCopy(coordinateSystem);
    }

    int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        return 0;
    }

    public Class<? extends CoordinateSystem> getInterface() {
        return CoordinateSystem.class;
    }

    @Override
    public final int getDimension() {
        return this.axes.length;
    }

    @Override
    public final CoordinateSystemAxis getAxis(int n) throws IndexOutOfBoundsException {
        return this.axes[n];
    }

    public synchronized AbstractCS forConvention(AxesConvention axesConvention) {
        AbstractCS abstractCS;
        ArgumentChecks.ensureNonNull("convention", axesConvention);
        if (this.derived == null) {
            this.derived = new EnumMap<AxesConvention, AbstractCS>(AxesConvention.class);
        }
        if ((abstractCS = this.derived.get(axesConvention)) == null) {
            abstractCS = Normalizer.forConvention(this, axesConvention);
            if (abstractCS == null) {
                abstractCS = this;
            }
            for (AbstractCS abstractCS2 : this.derived.values()) {
                if (!abstractCS.equals(abstractCS2)) continue;
                abstractCS = abstractCS2;
                break;
            }
            this.derived.put(axesConvention, abstractCS);
        }
        return abstractCS;
    }

    AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        return new AbstractCS(map, coordinateSystemAxisArray);
    }

    static IllegalArgumentException unexpectedDimension(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray, int n) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)81, "filter(cs)", n, coordinateSystemAxisArray.length));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        int n;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return Arrays.equals(this.axes, ((AbstractCS)object).axes);
            }
            case DEBUG: {
                int n2 = this.axes.length;
                n = ((CoordinateSystem)object).getDimension();
                if (n2 != n) {
                    throw new AssertionError((Object)Errors.format((short)80, n2, n));
                }
                break;
            }
        }
        CoordinateSystem coordinateSystem = (CoordinateSystem)object;
        n = this.getDimension();
        if (n != coordinateSystem.getDimension()) {
            return false;
        }
        if (comparisonMode != ComparisonMode.ALLOW_VARIANT) {
            for (int i = 0; i < n; ++i) {
                if (Utilities.deepEquals(this.getAxis(i), coordinateSystem.getAxis(i), comparisonMode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Arrays.hashCode(this.axes);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String string = WKTUtilities.toType(CoordinateSystem.class, this.getInterface());
        if (string == null) {
            formatter.setInvalidWKT(this, null);
        }
        formatter.append(string, ElementKind.CODE_LIST);
        formatter.append(this.getDimension());
        return "CS";
    }

    AbstractCS() {
        super(NilReferencingObject.INSTANCE);
        this.axes = EMPTY;
    }

    @XmlElement(name="axis")
    private CoordinateSystemAxis[] getAxis() {
        return AbstractCS.getAxes(this);
    }

    private void setAxis(CoordinateSystemAxis[] coordinateSystemAxisArray) {
        this.axes = coordinateSystemAxisArray;
    }
}

