/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ctakes;

import java.util.Collection;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ctakes.CTAKESAnnotationProperty;
import org.apache.tika.parser.ctakes.CTAKESConfig;
import org.apache.tika.parser.ctakes.CTAKESUtils;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CTAKESContentHandler
extends ContentHandlerDecorator {
    public static String CTAKES_META_PREFIX = "ctakes:";
    private CTAKESConfig config = null;
    private StringBuilder sb = null;
    private Metadata metadata = null;
    private AnalysisEngine ae = null;
    private JCas jcas = null;

    public CTAKESContentHandler(ContentHandler handler, Metadata metadata, CTAKESConfig config) {
        super(handler);
        this.metadata = metadata;
        this.config = config;
        this.sb = new StringBuilder();
    }

    public CTAKESContentHandler(ContentHandler handler, Metadata metadata) {
        this(handler, metadata, new CTAKESConfig());
    }

    public CTAKESContentHandler() {
        this(new DefaultHandler(), new Metadata());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.config.isText()) {
            this.sb.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.ae == null) {
                this.ae = CTAKESUtils.getAnalysisEngine(this.config.getAeDescriptorPath(), this.config.getUMLSUser(), this.config.getUMLSPass());
            }
            if (this.jcas == null) {
                this.jcas = CTAKESUtils.getJCas(this.ae);
            }
            StringBuilder metaText = new StringBuilder();
            String[] metadataToProcess = this.config.getMetadata();
            if (metadataToProcess != null) {
                for (String name : this.config.getMetadata()) {
                    for (String value : this.metadata.getValues(name)) {
                        metaText.append(value);
                        metaText.append(System.lineSeparator());
                    }
                }
            }
            this.jcas.setDocumentText(metaText.toString() + this.sb.toString());
            this.ae.process(this.jcas);
            this.metadata.add(CTAKES_META_PREFIX + "schema", this.config.getAnnotationPropsAsString());
            CTAKESAnnotationProperty[] annotationPros = this.config.getAnnotationProps();
            Collection<IdentifiedAnnotation> collection = JCasUtil.select(this.jcas, IdentifiedAnnotation.class);
            for (IdentifiedAnnotation annotation : collection) {
                StringBuilder annotationBuilder = new StringBuilder();
                annotationBuilder.append(annotation.getCoveredText());
                if (annotationPros != null) {
                    for (CTAKESAnnotationProperty property : annotationPros) {
                        annotationBuilder.append(this.config.getSeparatorChar());
                        annotationBuilder.append(CTAKESUtils.getAnnotationProperty(annotation, property));
                    }
                }
                this.metadata.add(CTAKES_META_PREFIX + annotation.getType().getShortName(), annotationBuilder.toString());
            }
            if (this.config.isSerialize()) {
                CTAKESUtils.serialize(this.jcas, this.config.getSerializerType(), this.config.isPrettyPrint(), this.config.getOutputStream());
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            CTAKESUtils.resetCAS(this.jcas);
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }
}

