/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.impl.JCasHashMap;

public class IntHashSet
implements PositiveIntSet {
    public static final int SIZE_NEEDING_4_BYTES = 65534;
    public static final float DEFAULT_LOAD_FACTOR = 0.66f;
    private static final boolean TUNE = false;
    private final float loadFactor = 0.66f;
    private final int initialCapacity;
    private int[] histogram;
    private int maxProbe = 0;
    private int sizeWhichTriggersExpansion;
    private int size;
    private int nbrRemoved;
    private int offset;
    private int[] keys4;
    private short[] keys2;
    private boolean secondTimeShrinkable = false;
    private int mostPositive = Integer.MIN_VALUE;
    private int mostNegative = Integer.MAX_VALUE;

    static int nextHigherPowerOf2(int i) {
        return i < 1 ? 1 : Integer.highestOneBit(i) << (Integer.bitCount(i) == 1 ? 0 : 1);
    }

    public IntHashSet() {
        this(12, 0);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntHashSet(int initialCapacity, int offset) {
        this.initialCapacity = initialCapacity;
        boolean force4 = offset == Integer.MIN_VALUE;
        this.offset = force4 ? 0 : offset;
        this.newTableKeepSize(this.tableSpace(initialCapacity), force4);
        this.size = 0;
    }

    public int tableSpace(int numberOfElements) {
        return IntHashSet.tableSpace(numberOfElements, Float.valueOf(0.66f));
    }

    public static int tableSpace(int numberOfElements, Float factor) {
        if (numberOfElements < 0) {
            throw new IllegalArgumentException("must be > 0");
        }
        int capacity = Math.round((float)numberOfElements / factor.floatValue());
        return Math.max(16, IntHashSet.nextHigherPowerOf2(capacity));
    }

    private void newTableKeepSize(int capacity, boolean make4) {
        if (!make4) {
            boolean bl = make4 = (capacity = Math.max(4, IntHashSet.nextHigherPowerOf2(capacity))) >= 65534;
        }
        if (make4) {
            this.keys4 = new int[capacity];
            this.keys2 = null;
        } else {
            this.keys2 = new short[capacity];
            this.keys4 = null;
        }
        this.sizeWhichTriggersExpansion = (int)((float)capacity * 0.66f);
        this.nbrRemoved = 0;
    }

    private void incrementSize() {
        if (this.size + this.nbrRemoved >= this.sizeWhichTriggersExpansion) {
            this.increaseTableCapacity();
        }
        ++this.size;
    }

    public boolean wontExpand() {
        return this.wontExpand(1);
    }

    public boolean wontExpand(int n) {
        return this.size + this.nbrRemoved + n < this.sizeWhichTriggersExpansion;
    }

    public int getSpaceUsedInWords() {
        return this.keys4 != null ? this.keys4.length : this.keys2.length >> 1;
    }

    public static int getSpaceOverheadInWords() {
        return 11;
    }

    private int getCapacity() {
        return null == this.keys4 ? this.keys2.length : this.keys4.length;
    }

    private int getRawFromAdjKey(int adjKey) {
        assert (adjKey != Short.MIN_VALUE);
        return adjKey + this.offset + (adjKey < 0 ? 1 : 0);
    }

    private void increaseTableCapacity() {
        int newCapacity;
        int oldCapacity = this.getCapacity();
        int n = newCapacity = this.nbrRemoved > this.size ? oldCapacity : oldCapacity << 1;
        if (this.keys2 != null) {
            short[] oldKeys = this.keys2;
            this.newTableKeepSize(newCapacity, false);
            if (newCapacity >= 65536) {
                for (short adjKey : oldKeys) {
                    if (adjKey == 0 || adjKey == Short.MIN_VALUE) continue;
                    this.addInner4(this.getRawFromAdjKey(adjKey));
                }
            } else {
                for (short adjKey : oldKeys) {
                    if (adjKey == 0 || adjKey == Short.MIN_VALUE) continue;
                    this.addInner2(adjKey);
                }
            }
        } else {
            int[] oldKeys = this.keys4;
            this.newTableKeepSize(newCapacity, true);
            for (int key : oldKeys) {
                if (key == 0 || key == Integer.MIN_VALUE) continue;
                this.addInner4(key);
            }
        }
    }

    private void newTable(int capacity) {
        this.newTableKeepSize(capacity, false);
        this.resetTable();
    }

    private void resetHistogram() {
    }

    private void resetArray() {
        if (this.keys4 == null) {
            Arrays.fill(this.keys2, (short)0);
        } else {
            Arrays.fill(this.keys4, 0);
        }
        this.resetTable();
    }

    private void resetTable() {
        this.mostPositive = Integer.MIN_VALUE;
        this.mostNegative = Integer.MAX_VALUE;
        this.resetHistogram();
        this.size = 0;
        this.nbrRemoved = 0;
    }

    @Override
    public void clear() {
        if (this.size < this.sizeWhichTriggersExpansion >>> 1) {
            if (this.secondTimeShrinkable) {
                this.secondTimeShrinkable = false;
                int currentCapacity = this.getCapacity();
                int newCapacity = Math.max(this.initialCapacity, currentCapacity >>> 1);
                if (newCapacity < currentCapacity) {
                    this.newTable(newCapacity);
                } else {
                    this.resetArray();
                }
                return;
            }
            this.secondTimeShrinkable = true;
        } else {
            this.secondTimeShrinkable = false;
        }
        this.resetArray();
    }

    private int findPosition(int adjKey) {
        int probeAddr;
        if (adjKey == 0) {
            throw new IllegalArgumentException("0 is an invalid key");
        }
        int hash = JCasHashMap.hashInt(adjKey);
        int nbrProbes = 1;
        int probeDelta = 1;
        if (this.keys4 == null) {
            short testKey;
            short[] localKeys2 = this.keys2;
            int bitMask = localKeys2.length - 1;
            probeAddr = hash & bitMask;
            while ((testKey = localKeys2[probeAddr]) != 0 && testKey != adjKey) {
                ++nbrProbes;
                probeAddr = bitMask & probeAddr + probeDelta++;
            }
        } else {
            int testKey;
            int[] localKeys4 = this.keys4;
            int bitMask = localKeys4.length - 1;
            probeAddr = hash & bitMask;
            while ((testKey = localKeys4[probeAddr]) != 0 && testKey != adjKey) {
                ++nbrProbes;
                probeAddr = bitMask & probeAddr + probeDelta++;
            }
        }
        return probeAddr;
    }

    private boolean isAdjKeyOutOfRange(int adjKey) {
        return adjKey > Short.MAX_VALUE || adjKey <= Short.MIN_VALUE;
    }

    @Override
    public boolean contains(int rawKey) {
        return this.find(rawKey) != -1;
    }

    @Override
    public int find(int rawKey) {
        if (rawKey == 0) {
            return -1;
        }
        if (this.keys4 == null) {
            int adjKey = this.getAdjKey(rawKey);
            if (this.isAdjKeyOutOfRange(adjKey)) {
                return -1;
            }
            int pos = this.findPosition(adjKey);
            return this.keys2[pos] == adjKey ? pos : -1;
        }
        if (rawKey == Integer.MIN_VALUE) {
            return -1;
        }
        int pos = this.findPosition(rawKey);
        return this.keys4[pos] == rawKey ? pos : -1;
    }

    private int getAdjKey(int rawKey) {
        int adjKey;
        return adjKey - ((adjKey = rawKey - this.offset) <= 0 ? 1 : 0);
    }

    private void switchTo4byte() {
        short[] oldKeys = this.keys2;
        this.newTableKeepSize(this.getCapacity(), true);
        for (short adjKey : oldKeys) {
            if (adjKey == 0 || adjKey == Short.MIN_VALUE) continue;
            this.addInner4(this.getRawFromAdjKey(adjKey));
        }
    }

    @Override
    public boolean add(int rawKey) {
        if (rawKey == 0) {
            throw new IllegalArgumentException("argument must be non-zero");
        }
        if (this.size == 0) {
            this.mostPositive = this.mostNegative = rawKey;
        } else {
            if (rawKey > this.mostPositive) {
                this.mostPositive = rawKey;
            }
            if (rawKey < this.mostNegative) {
                this.mostNegative = rawKey;
            }
        }
        if (this.keys4 != null) {
            return this.find4(rawKey);
        }
        int adjKey = this.getAdjKey(rawKey);
        if (this.isAdjKeyOutOfRange(adjKey)) {
            this.switchTo4byte();
            return this.find4(rawKey);
        }
        int i = this.findPosition(adjKey);
        if (this.keys2[i] == adjKey) {
            return false;
        }
        this.keys2[i] = (short)adjKey;
        this.incrementSize();
        return true;
    }

    private boolean find4(int rawKey) {
        int i = this.findPosition(rawKey);
        if (this.keys4[i] == rawKey) {
            return false;
        }
        this.keys4[i] = rawKey;
        this.incrementSize();
        return true;
    }

    private void addInner4(int rawKey) {
        int i = this.findPosition(rawKey);
        assert (this.keys4[i] == 0);
        this.keys4[i] = rawKey;
    }

    private void addInner2(short adjKey) {
        int i = this.findPosition(adjKey);
        assert (this.keys2[i] == 0);
        this.keys2[i] = adjKey;
    }

    @Override
    public boolean remove(int rawKey) {
        int pos = this.find(rawKey);
        if (pos < 0) {
            return false;
        }
        if (this.keys4 == null) {
            this.keys2[pos] = Short.MIN_VALUE;
        } else {
            this.keys4[pos] = Integer.MIN_VALUE;
        }
        --this.size;
        ++this.nbrRemoved;
        if (rawKey == this.mostPositive) {
            --this.mostPositive;
        }
        if (rawKey == this.mostNegative) {
            ++this.mostNegative;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getMostPositive() {
        return this.mostPositive;
    }

    public int getMostNegative() {
        return this.mostNegative;
    }

    public void showHistogram() {
    }

    @Override
    public int get(int index) {
        if (this.keys4 == null) {
            short adjKey = this.keys2[index];
            if (adjKey == 0 || adjKey == Short.MIN_VALUE) {
                return 0;
            }
            return this.getRawFromAdjKey(adjKey);
        }
        int adjKey = this.keys4[index];
        if (adjKey == 0 || adjKey == Integer.MIN_VALUE) {
            return 0;
        }
        return adjKey;
    }

    private int moveToNextFilled(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        int max = this.getCapacity();
        if (null == this.keys4) {
            while (true) {
                if (pos >= max) {
                    return pos;
                }
                int v = this.get(pos);
                if (v != 0 && v != Short.MIN_VALUE) {
                    return pos;
                }
                ++pos;
            }
        }
        while (pos < max) {
            int v = this.get(pos);
            if (v != 0 && v != Integer.MIN_VALUE) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private int moveToPreviousFilled(int pos) {
        int max = this.getCapacity();
        if (pos > max) {
            pos = max - 1;
        }
        while (pos >= 0) {
            int v = this.get(pos);
            if (v != 0 && v != (this.keys4 == null ? Short.MIN_VALUE : Integer.MIN_VALUE)) {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    @Override
    public IntListIterator iterator() {
        return new IntHashSetIterator();
    }

    @Override
    public int moveToFirst() {
        return this.size() == 0 ? -1 : this.moveToNextFilled(0);
    }

    @Override
    public int moveToLast() {
        return this.size() == 0 ? -1 : this.moveToPreviousFilled(this.getCapacity() - 1);
    }

    @Override
    public int moveToNext(int position) {
        if (position < 0) {
            return position;
        }
        int n = this.moveToNextFilled(position + 1);
        return n >= this.getCapacity() ? -1 : n;
    }

    @Override
    public int moveToPrevious(int position) {
        if (position >= this.getCapacity()) {
            return -1;
        }
        return this.moveToPreviousFilled(position - 1);
    }

    @Override
    public boolean isValid(int position) {
        return position >= 0 && position < this.getCapacity();
    }

    @Override
    public void bulkAddTo(IntVector v) {
        if (null == this.keys4) {
            for (short k : this.keys2) {
                if (k == 0 || k == Short.MIN_VALUE) continue;
                v.add(this.getRawFromAdjKey(k));
            }
        } else {
            for (int k : this.keys4) {
                if (k == 0 || k == Integer.MIN_VALUE) continue;
                v.add(k);
            }
        }
    }

    @Override
    public int[] toIntArray() {
        int s = this.size();
        if (s == 0) {
            return PositiveIntSet_impl.EMPTY_INT_ARRAY;
        }
        int[] r = new int[this.size()];
        int pos = this.moveToFirst();
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.get(pos);
            pos = this.moveToNextFilled(pos + 1);
        }
        return r;
    }

    public String toString() {
        return String.format("IntHashSet [loadFactor=%s, initialCapacity=%s, sizeWhichTriggersExpansion=%s, size=%s, offset=%s%n keys4=%s%n keys2=%s%n secondTimeShrinkable=%s, mostPositive=%s, mostNegative=%s]", Float.valueOf(0.66f), this.initialCapacity, this.sizeWhichTriggersExpansion, this.size, this.offset, Arrays.toString(this.keys4), Arrays.toString(this.keys2), this.secondTimeShrinkable, this.mostPositive, this.mostNegative);
    }

    boolean isShortHashSet() {
        return this.keys2 != null;
    }

    int getOffset() {
        return this.offset;
    }

    private class IntHashSetIterator
    implements IntListIterator {
        private int curPosition = 0;

        private IntHashSetIterator() {
        }

        @Override
        public final boolean hasNext() {
            this.curPosition = IntHashSet.this.moveToNextFilled(this.curPosition);
            return this.curPosition < IntHashSet.this.getCapacity();
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return IntHashSet.this.get(this.curPosition++);
        }

        @Override
        public boolean hasPrevious() {
            this.curPosition = IntHashSet.this.moveToPreviousFilled(this.curPosition);
            return this.curPosition >= 0;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return IntHashSet.this.get(this.curPosition--);
        }

        @Override
        public void moveToEnd() {
            this.curPosition = IntHashSet.this.getCapacity() - 1;
        }

        @Override
        public void moveToStart() {
            this.curPosition = 0;
        }
    }
}

