/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;

public class CoordinateUniquify<T> {
    private static Logger logger = LoggerFactory.getLogger(CoordinateUniquify.class);
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    Coordinate runtimeAll;
    CoordinateBuilder runtimeAllBuilder = new CoordinateRuntime.Builder2(null);
    Set<Coordinate> timeBuilders = new HashSet<Coordinate>();
    Set<Coordinate> timeIntvBuilders = new HashSet<Coordinate>();
    Set<Coordinate> vertBuilders = new HashSet<Coordinate>();
    Set<Coordinate> ensBuilders = new HashSet<Coordinate>();
    Map<Coordinate, Integer> coordMap;

    public void addCoords(List<Coordinate> coords) {
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    this.runtimeAllBuilder.addAll(coord);
                    break;
                }
                case time: {
                    this.timeBuilders.add(coord);
                    break;
                }
                case timeIntv: {
                    this.timeIntvBuilders.add(coord);
                    break;
                }
                case vert: {
                    this.vertBuilders.add(coord);
                    break;
                }
                case ens: {
                    this.ensBuilders.add(coord);
                }
            }
        }
    }

    public void finish() {
        this.runtimeAll = this.runtimeAllBuilder.finish();
        this.unionCoords.add(this.runtimeAll);
        for (Coordinate coord : this.timeBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.timeIntvBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.vertBuilders) {
            this.unionCoords.add(coord);
        }
        for (Coordinate coord : this.ensBuilders) {
            this.unionCoords.add(coord);
        }
        this.coordMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < this.unionCoords.size(); ++i) {
            this.coordMap.put(this.unionCoords.get(i), i);
        }
    }

    public List<Integer> reindex(List<Coordinate> coords) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Coordinate coord : coords) {
            Integer idx = this.coordMap.get(coord);
            if (idx == null) {
                if (coord.getType() == Coordinate.Type.runtime) {
                    idx = 0;
                } else {
                    logger.warn("CoordinateUniquify.reindex missing coordinate");
                }
            }
            result.add(idx);
        }
        return result;
    }

    public CoordinateND<T> reindex(CoordinateND<T> prev, List<Integer> index) {
        if (index == null) {
            index = new ArrayList<Integer>();
        }
        ArrayList<Coordinate> sharedCoords = new ArrayList<Coordinate>();
        boolean needReindex = false;
        for (Coordinate coord : prev.getCoordinates()) {
            if (coord.getType() == Coordinate.Type.runtime && !coord.equals(this.runtimeAll)) {
                needReindex = true;
                index.add(this.coordMap.get(this.runtimeAll));
                sharedCoords.add(this.runtimeAll);
                continue;
            }
            index.add(this.coordMap.get(coord));
            sharedCoords.add(coord);
        }
        if (needReindex) {
            CoordinateND<T> result = new CoordinateND<T>(sharedCoords);
            result.reindex(prev);
            return result;
        }
        return new CoordinateND<T>(sharedCoords, prev.getSparseArray());
    }

    public List<Coordinate> getUnionCoords() {
        return this.unionCoords;
    }
}

