/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.gui;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;

public class EdgeSegment
extends GenericSegment {
    public EdgeSegment(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
    }

    public EdgeSegment() {
    }

    public EdgeSegment(AdjacencyEdge<? extends GenericSegment> e) {
        switch (e.getDirection()) {
            case 0: {
                float newY1;
                float newX1 = e.getNodeTo().getX2();
                float newX2 = e.getNodeFrom().getX1();
                float yo1 = Utils.maximum(e.getNodeFrom().getY1(), e.getNodeTo().getY1());
                float yo2 = Utils.minimum(e.getNodeFrom().getY2(), e.getNodeTo().getY2());
                float newY2 = newY1 = (yo1 + yo2) / 2.0f;
                break;
            }
            case 1: {
                float newY1;
                float newX2 = e.getNodeTo().getX1();
                float newX1 = e.getNodeFrom().getX2();
                float yo1 = Utils.maximum(e.getNodeFrom().getY1(), e.getNodeTo().getY1());
                float yo2 = Utils.minimum(e.getNodeFrom().getY2(), e.getNodeTo().getY2());
                float newY2 = newY1 = (yo1 + yo2) / 2.0f;
                break;
            }
            case 2: {
                float newX1;
                float newY1 = e.getNodeFrom().getY2();
                float newY2 = e.getNodeTo().getY1();
                float xo1 = Utils.maximum(e.getNodeFrom().getX1(), e.getNodeTo().getX1());
                float xo2 = Utils.minimum(e.getNodeFrom().getX2(), e.getNodeTo().getX2());
                float newX2 = newX1 = (xo1 + xo2) / 2.0f;
                break;
            }
            case 3: {
                float newX1;
                float newY2 = e.getNodeFrom().getY1();
                float newY1 = e.getNodeTo().getY2();
                float xo1 = Utils.maximum(e.getNodeFrom().getX1(), e.getNodeTo().getX1());
                float xo2 = Utils.minimum(e.getNodeFrom().getX2(), e.getNodeTo().getX2());
                float newX2 = newX1 = (xo1 + xo2) / 2.0f;
                break;
            }
            default: {
                float newX1 = -1.0f;
                float newX2 = -1.0f;
                float newY1 = -1.0f;
                float newY2 = -1.0f;
            }
        }
    }
}

