/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class BorderOpImage
extends OpImage {
    protected BorderExtender extender;

    public BorderOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, int n3, int n4, BorderExtender borderExtender) {
        super(OpImage.vectorize(renderedImage), BorderOpImage.layoutHelper(imageLayout, renderedImage, n, n2, n3, n4), map, true);
        this.extender = borderExtender;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX() - n);
        imageLayout2.setMinY(renderedImage.getMinY() - n3);
        imageLayout2.setWidth(renderedImage.getWidth() + n + n2);
        imageLayout2.setHeight(renderedImage.getHeight() + n3 + n4);
        if (!imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(imageLayout2.getMinX(null));
        }
        if (!imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(imageLayout2.getMinY(null));
        }
        imageLayout2.setSampleModel(renderedImage.getSampleModel());
        imageLayout2.setColorModel(renderedImage.getColorModel());
        return imageLayout2;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage0"));
        }
        return new Rectangle(rectangle);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage2"));
        }
        Rectangle rectangle2 = this.getSourceImage(0).getBounds();
        return rectangle.intersection(rectangle2);
    }

    public Raster computeTile(int n, int n2) {
        WritableRaster writableRaster = this.createTile(n, n2);
        this.getSourceImage(0).copyExtendedData(writableRaster, this.extender);
        return writableRaster;
    }
}

