#!perl

use 5.010;
use strict;
use warnings;

use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'Parse::FSM',
    AUTHOR              => q{Paulo Custodio <pscust@cpan.org>},
    VERSION_FROM        => 'lib/Parse/FSM.pm',
    ABSTRACT_FROM       => 'lib/Parse/FSM.pm',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
      ? ('LICENSE'=> 'perl')
      : ()),
    PREREQ_PM => {
		'Capture::Tiny'			=> 0.10,
		'Class::XSAccessor'		=> 1.11,
		'Data::Dump'			=> 1.19,
		'File::Slurp'			=> 9999.15,
		'File::Spec'			=> 3.33,
		'File::Temp'			=> 0.22,
        'Test::More'            => 0.96,		# needs done_testing()
		'Text::Balanced'		=> 2.02,
		'Text::Template'		=> 1.45,
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'Parse-FSM-*' },
);

sub MY::postamble {
	return q{

pure_all :: $(INST_LIB)$(DFSEP)Parse$(DFSEP)FSM$(DFSEP)Parser.pm

$(INST_LIB)$(DFSEP)Parse$(DFSEP)FSM$(DFSEP)Parser.pm : \
				tools$(DFSEP)build_parser.pl \
				lib$(DFSEP)Parse$(DFSEP)FSM.pm \
				lib$(DFSEP)Parse$(DFSEP)FSM$(DFSEP)Driver.pm \
				$(FIRST_MAKEFILE)
	$(PERLRUNINST) tools$(DFSEP)build_parser.pl Parse::FSM::Parser $(INST_LIB)$(DFSEP)Parse$(DFSEP)FSM$(DFSEP)Parser.pm
};
}
