#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::FeatureIDCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FeatureIDCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::FeatureIDCodeType

=head1 DESCRIPTION

Specifies the feature IDs for which you want information. If you do not specify a
value, all feature IDs are returned.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ListingDurations

Returns information about the durations of listings you can use in a
given category.
<br><br>
<bold>Note:</bold> Durations for Local Market listings are not
supported by GetCategoryFeatures. Refer to the Local Market Listing
documentation in the
Web Services Guide for valid listing durations.



=cut


use constant ListingDurations => scalar('ListingDurations');


=head2 BestOfferEnabled

Returns information about whether a category supports best offers.



=cut


use constant BestOfferEnabled => scalar('BestOfferEnabled');


=head2 DutchBINEnabled

Returned if a site and category allow Buy It Now for Dutch auctions.



=cut


use constant DutchBINEnabled => scalar('DutchBINEnabled');


=head2 ShippingTermsRequired

Returns information about whether a seller is required to
specify at least one domestic shipping
service and associated cost in order to list the item.



=cut


use constant ShippingTermsRequired => scalar('ShippingTermsRequired');


=head2 UserConsentRequired

Returns information about whether a bidder must consent to the bid
by confirming that he or she read and agrees to the terms in eBay's privacy policy.



=cut


use constant UserConsentRequired => scalar('UserConsentRequired');


=head2 HomePageFeaturedEnabled

Indicates whether or not it is possible to enhance a listing by putting
it into a rotation for display on a special area of the eBay home page.
Support for this feature varies by site. Item or feedback restrictions may apply.



=cut


use constant HomePageFeaturedEnabled => scalar('HomePageFeaturedEnabled');


=head2 AdFormatEnabled

Indicates whether the category supports ad-format.



=cut


use constant AdFormatEnabled => scalar('AdFormatEnabled');


=head2 DigitalDeliveryEnabled

Returns information about whether a category supports digital delivery items. The digital delivery feature is disabled as of March 28, 2008.



=cut


use constant DigitalDeliveryEnabled => scalar('DigitalDeliveryEnabled');


=head2 BestOfferCounterEnabled

Returns information about whether a category supports counter-offers for Best Offers.



=cut


use constant BestOfferCounterEnabled => scalar('BestOfferCounterEnabled');


=head2 BestOfferAutoDeclineEnabled

Returns information about whether a category supports auto-decline for Best Offers.



=cut


use constant BestOfferAutoDeclineEnabled => scalar('BestOfferAutoDeclineEnabled');


=head2 ProPack

Returns information about ProPackBundle (a feature pack). Applies only to US
and Canadian eBay motor vehicle sellers. Contains the Bold, Border, Featured
and Highlight features.



=cut


use constant ProPack => scalar('ProPack');


=head2 BasicUpgradePack

Not applicable to any site.
Formerly, Australia site (site ID 15, abbreviation AU) only, and
returned information about the BasicUpgradePack bundle (a feature pack),
which combined the features Gallery and Subtitle for a discounted price.



=cut


use constant BasicUpgradePack => scalar('BasicUpgradePack');


=head2 ValuePack

Returns information about the ValuePack bundle (a feature pack), which
combines the features Gallery, Subtitle, and Listing Designer for a discounted
price. Support for this feature varies by site and category.



=cut


use constant ValuePack => scalar('ValuePack');


=head2 ProPackPlus

Returns information about the ProPackPlus bundle (a feature pack), which
combines the features BoldTitle, Border, Highlight, Featured, and Gallery for
a discounted price. Support for this feature varies by site and category.



=cut


use constant ProPackPlus => scalar('ProPackPlus');


=head2 LocalMarketSpecialitySubscription

Returns information about whether a category supports Local Market listings
for sellers subscribed to Local Market for Specialty Vehicles.



=cut


use constant LocalMarketSpecialitySubscription => scalar('LocalMarketSpecialitySubscription');


=head2 LocalMarketRegularSubscription

Returns information about whether a category supports Local Market listings
for sellers subscribed to Local Market for Vehicles.



=cut


use constant LocalMarketRegularSubscription => scalar('LocalMarketRegularSubscription');


=head2 LocalMarketPremiumSubscription

Returns information about whether a category supports Local Market listings
for sellers with a premium Local Market subscription.



=cut


use constant LocalMarketPremiumSubscription => scalar('LocalMarketPremiumSubscription');


=head2 LocalMarketNonSubscription

Returns information about whether a category supports Local Market listings
for sellers without a Local Market subscription.



=cut


use constant LocalMarketNonSubscription => scalar('LocalMarketNonSubscription');


=head2 ExpressEnabled

Returns information about whether a category is eligible for eBay Express.



=cut


use constant ExpressEnabled => scalar('ExpressEnabled');


=head2 ExpressPicturesRequired

Returns information about whether a category requires pictures to be listed on Express.



=cut


use constant ExpressPicturesRequired => scalar('ExpressPicturesRequired');


=head2 ExpressConditionRequired

Returns information about whether a category requires item condition to be
listed on Express.



=cut


use constant ExpressConditionRequired => scalar('ExpressConditionRequired');


=head2 SellerContactDetailsEnabled

Returns information about whether this category allows seller-level
contact information for Classified Ad listings.



=cut


use constant SellerContactDetailsEnabled => scalar('SellerContactDetailsEnabled');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');


=head2 MinimumReservePrice

Returns information about whether a category supports Minimum Reserve Price.



=cut


use constant MinimumReservePrice => scalar('MinimumReservePrice');


=head2 TransactionConfirmationRequestEnabled

Returns information about whether a category supports the Transaction
Confirmation Request (TCR) feature.



=cut


use constant TransactionConfirmationRequestEnabled => scalar('TransactionConfirmationRequestEnabled');


=head2 StoreInventoryEnabled

Indicates whether the category supports Store Inventory Format.



=cut


use constant StoreInventoryEnabled => scalar('StoreInventoryEnabled');


=head2 LocalListingDistances

Returns information about the supported local listing distances for different
levels of Local Market subscription.



=cut


use constant LocalListingDistances => scalar('LocalListingDistances');


=head2 SkypeMeTransactionalEnabled

Returns information about whether a category supports the addition of Skype
buttons to listings for transactional formats (e.g., the Chinese auction
format).



=cut


use constant SkypeMeTransactionalEnabled => scalar('SkypeMeTransactionalEnabled');


=head2 SkypeMeNonTransactionalEnabled

Returns information about whether a category supports the addition of Skype
buttons to listings for non-transactional formats (e.g., the advertisement
format).



=cut


use constant SkypeMeNonTransactionalEnabled => scalar('SkypeMeNonTransactionalEnabled');


=head2 ClassifiedAdPaymentMethodEnabled

Returns information about whether the payment method is displayed
to the user for Classified Ad listings in this category.
Even if payment method is displayed, checkout may or may not be enabled.



=cut


use constant ClassifiedAdPaymentMethodEnabled => scalar('ClassifiedAdPaymentMethodEnabled');


=head2 ClassifiedAdShippingMethodEnabled

Returns information about whether shipping options are available for
Classified Ad listings in this category.



=cut


use constant ClassifiedAdShippingMethodEnabled => scalar('ClassifiedAdShippingMethodEnabled');


=head2 ClassifiedAdBestOfferEnabled

Returns information about whether Best Offer is enabled for Classified
Ad listings.



=cut


use constant ClassifiedAdBestOfferEnabled => scalar('ClassifiedAdBestOfferEnabled');


=head2 ClassifiedAdCounterOfferEnabled

Returns information about whether counter offers are allowed on
Classified Ad listings for this category.
Returned only if this category overrides the site default.



=cut


use constant ClassifiedAdCounterOfferEnabled => scalar('ClassifiedAdCounterOfferEnabled');


=head2 ClassifiedAdAutoDeclineEnabled

Returns information about whether automatic decline for best
offers are allowed for Classified Ad listings in this category.
Returned only if this category overrides the site default.



=cut


use constant ClassifiedAdAutoDeclineEnabled => scalar('ClassifiedAdAutoDeclineEnabled');


=head2 ClassifiedAdContactByEmailEnabled

Returns information about whether this category supports including an email
address in the seller's contact information.



=cut


use constant ClassifiedAdContactByEmailEnabled => scalar('ClassifiedAdContactByEmailEnabled');


=head2 ClassifiedAdContactByPhoneEnabled

Returns information about whether this category supports including a telephone
number in the seller's contact information.



=cut


use constant ClassifiedAdContactByPhoneEnabled => scalar('ClassifiedAdContactByPhoneEnabled');


=head2 SafePaymentRequired

Returns information about whether a category requires
a safe payment method. If a seller has a 'SafePaymentExempt'
status (see GetUser), they are exempt from the requirement to offer at least
one safe payment method when listing an item.



=cut


use constant SafePaymentRequired => scalar('SafePaymentRequired');


=head2 MaximumBestOffersAllowed

Returns information about the number of Best Offers
allowed for a non-Ad-Format-Listings buyer.



=cut


use constant MaximumBestOffersAllowed => scalar('MaximumBestOffersAllowed');


=head2 ClassifiedAdMaximumBestOffersAllowed

Returns information about the number of Best Offers
allowed for a Classified-Ad-Format-Listings buyer.



=cut


use constant ClassifiedAdMaximumBestOffersAllowed => scalar('ClassifiedAdMaximumBestOffersAllowed');


=head2 ClassifiedAdContactByEmailAvailable

Returns information about whether this category supports including an email
address in the seller's contact information for classified-ad listings.



=cut


use constant ClassifiedAdContactByEmailAvailable => scalar('ClassifiedAdContactByEmailAvailable');


=head2 ClassifiedAdPayPerLeadEnabled

Returns information about whether a category supports pay-per-lead listings.



=cut


use constant ClassifiedAdPayPerLeadEnabled => scalar('ClassifiedAdPayPerLeadEnabled');


=head2 ItemSpecificsEnabled

Returns information about whether categories support
custom Item Specifics.



=cut


use constant ItemSpecificsEnabled => scalar('ItemSpecificsEnabled');


=head2 PaisaPayFullEscrowEnabled

Returns information about whether PaisaPayEscrow payment method is enabled.



=cut


use constant PaisaPayFullEscrowEnabled => scalar('PaisaPayFullEscrowEnabled');


=head2 ClassifiedAdAutoAcceptEnabled

Returns information about whether auto-accept for Best
Offers is allowed for Classified Ad listings in this category.



=cut


use constant ClassifiedAdAutoAcceptEnabled => scalar('ClassifiedAdAutoAcceptEnabled');


=head2 BestOfferAutoAcceptEnabled

Returns information about whether auto-accept for Best
Offers is allowed for listings in this category.



=cut


use constant BestOfferAutoAcceptEnabled => scalar('BestOfferAutoAcceptEnabled');


=head2 CrossBorderTradeEnabled

Returns information about whether a category allows listings to
be displayed in another site's default search results.



=cut


use constant CrossBorderTradeEnabled => scalar('CrossBorderTradeEnabled');


=head2 PayPalBuyerProtectionEnabled

On the Australia site, returns information about whether a category allows
PayPal buyer protection.



=cut


use constant PayPalBuyerProtectionEnabled => scalar('PayPalBuyerProtectionEnabled');


=head2 BuyerGuaranteeEnabled

On the Australia site, returns information about whether a category allows
PayPal buyer protection.



=cut


use constant BuyerGuaranteeEnabled => scalar('BuyerGuaranteeEnabled');


=head2 INEscrowWorkflowTimeline

On the India site, returns information about the escrow workflow version
applicable to the given category, if the category supports PaisaPayFullEscrow.



=cut


use constant INEscrowWorkflowTimeline => scalar('INEscrowWorkflowTimeline');


=head2 CombinedFixedPriceTreatment

On the Italy site, returns information about whether a category allows
combined fixed price treatment of the following two listing types: Store
Inventory Format and Basic Fixed Price.



=cut


use constant CombinedFixedPriceTreatment => scalar('CombinedFixedPriceTreatment');


=head2 GalleryFeaturedDurations

On the Italy Site, returns information about whether a category allows
durations for "Gallery Featured".



=cut


use constant GalleryFeaturedDurations => scalar('GalleryFeaturedDurations');


=head2 PayPalRequired

Returns information about whether listings in a category
require PayPal as a payment method.



=cut


use constant PayPalRequired => scalar('PayPalRequired');


=head2 eBayMotorsProAdFormatEnabled

Indicates whether the category supports ad-format. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProAdFormatEnabled => scalar('eBayMotorsProAdFormatEnabled');


=head2 eBayMotorsProContactByPhoneEnabled

Returns information about whether the telephone can be a contact method
for the category. Added for eBay Motorss Pro users.



=cut


use constant eBayMotorsProContactByPhoneEnabled => scalar('eBayMotorsProContactByPhoneEnabled');


=head2 eBayMotorsProContactByAddressEnabled

Returns information about whether this category supports including an address
in the seller's contact information. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProContactByAddressEnabled => scalar('eBayMotorsProContactByAddressEnabled');


=head2 eBayMotorsProCompanyNameEnabled

Returns information about whether this category supports including a company
name in the seller's contact information. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProCompanyNameEnabled => scalar('eBayMotorsProCompanyNameEnabled');


=head2 eBayMotorsProContactByEmailEnabled

Returns information about whether this category supports including an email
address in the seller's contact information. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProContactByEmailEnabled => scalar('eBayMotorsProContactByEmailEnabled');


=head2 eBayMotorsProBestOfferEnabled

Returns information about whether a category supports Best Offers.
Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProBestOfferEnabled => scalar('eBayMotorsProBestOfferEnabled');


=head2 eBayMotorsProAutoAcceptEnabled

Returns information about whether a category supports auto accept.
Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProAutoAcceptEnabled => scalar('eBayMotorsProAutoAcceptEnabled');


=head2 eBayMotorsProAutoDeclineEnabled

Returns information about whether a category supports auto decline.
Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProAutoDeclineEnabled => scalar('eBayMotorsProAutoDeclineEnabled');


=head2 eBayMotorsProPaymentMethodCheckOutEnabled

Returns information about whether a category supports payment method checkout.
Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProPaymentMethodCheckOutEnabled => scalar('eBayMotorsProPaymentMethodCheckOutEnabled');


=head2 eBayMotorsProShippingMethodEnabled

Returns information about whether shipping options are available in the category.
Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProShippingMethodEnabled => scalar('eBayMotorsProShippingMethodEnabled');


=head2 eBayMotorsProCounterOfferEnabled

Returns information about whether counter offers are allowed for this category.
Returned only if this category overrides the site default. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProCounterOfferEnabled => scalar('eBayMotorsProCounterOfferEnabled');


=head2 eBayMotorsProSellerContactDetailsEnabled

Returns information about whether this category allows seller-level
contact information for Classified Ad listings. Added for eBay Motors Pro users.



=cut


use constant eBayMotorsProSellerContactDetailsEnabled => scalar('eBayMotorsProSellerContactDetailsEnabled');


=head2 LocalMarketAdFormatEnabled

Indicates whether the category supports ad-format. Added for Local Market users.



=cut


use constant LocalMarketAdFormatEnabled => scalar('LocalMarketAdFormatEnabled');


=head2 LocalMarketContactByPhoneEnabled

Returns information about whether this category supports including a telephone
number in the seller's contact information. Added for Local Market users.



=cut


use constant LocalMarketContactByPhoneEnabled => scalar('LocalMarketContactByPhoneEnabled');


=head2 LocalMarketContactByAddressEnabled

Returns information about whether this category supports including an address
in the seller's contact information. Added for Local Market users.



=cut


use constant LocalMarketContactByAddressEnabled => scalar('LocalMarketContactByAddressEnabled');


=head2 LocalMarketCompanyNameEnabled

Returns information about whether this category supports including a company
name in the seller's contact information. Added for Local Market users.



=cut


use constant LocalMarketCompanyNameEnabled => scalar('LocalMarketCompanyNameEnabled');


=head2 LocalMarketContactByEmailEnabled

Returns information about whether this category supports including an email
address in the seller's contact information. Added for Local Market users.



=cut


use constant LocalMarketContactByEmailEnabled => scalar('LocalMarketContactByEmailEnabled');


=head2 LocalMarketBestOfferEnabled

Returns information about whether a category supports Best Offers for
Classified Ad listings. Added for Local Market users.



=cut


use constant LocalMarketBestOfferEnabled => scalar('LocalMarketBestOfferEnabled');


=head2 LocalMarketAutoAcceptEnabled

Returns information about whether a category supports auto accept.
Added for Local Market users.



=cut


use constant LocalMarketAutoAcceptEnabled => scalar('LocalMarketAutoAcceptEnabled');


=head2 LocalMarketAutoDeclineEnabled

Returns information about whether a category supports auto decline.
Added for Local Market users.



=cut


use constant LocalMarketAutoDeclineEnabled => scalar('LocalMarketAutoDeclineEnabled');


=head2 LocalMarketPaymentMethodCheckOutEnabled

Returns information about whether a category supports payment method checkout.
Added for Local Market users.



=cut


use constant LocalMarketPaymentMethodCheckOutEnabled => scalar('LocalMarketPaymentMethodCheckOutEnabled');


=head2 LocalMarketShippingMethodEnabled

Returns information about whether shipping options are available for
listings in the category. Added for Local Market users.



=cut


use constant LocalMarketShippingMethodEnabled => scalar('LocalMarketShippingMethodEnabled');


=head2 LocalMarketCounterOfferEnabled

Returns information about whether counter offers are allowed for this category .
Returned only if this category overrides the site default. Added for Local Market users.



=cut


use constant LocalMarketCounterOfferEnabled => scalar('LocalMarketCounterOfferEnabled');


=head2 LocalMarketSellerContactDetailsEnabled

Returns information about whether this category allows seller-level
contact information. Added for Local Market users.



=cut


use constant LocalMarketSellerContactDetailsEnabled => scalar('LocalMarketSellerContactDetailsEnabled');


=head2 ClassifiedAdContactByAddressEnabled

Returns information about whether the contact by address is enabled.
Added for For Sale By Owner.



=cut


use constant ClassifiedAdContactByAddressEnabled => scalar('ClassifiedAdContactByAddressEnabled');


=head2 ClassifiedAdCompanyNameEnabled

Returns information about whether this category supports including a company
name in the seller's contact information. Added for For Sale By Owmer.



=cut


use constant ClassifiedAdCompanyNameEnabled => scalar('ClassifiedAdCompanyNameEnabled');


=head2 SpecialitySubscription

Returns information about whether a category supports Local Market listings
for sellers subscribed to Local Market for Specialty Vehicles. Added for
subscription.



=cut


use constant SpecialitySubscription => scalar('SpecialitySubscription');


=head2 RegularSubscription

Returns information about whether a category supports Local Market listings
for sellers subscribed to Local Market for Vehicles. Added for subscription.



=cut


use constant RegularSubscription => scalar('RegularSubscription');


=head2 PremiumSubscription

Returns information about whether a category supports Local Market listings
for sellers with a premium Local Market subscription. Added for subscription.



=cut


use constant PremiumSubscription => scalar('PremiumSubscription');


=head2 NonSubscription

Returns information about whether a category supports Local Market listings
for sellers without a Local Market subscription. Added for subscription.



=cut


use constant NonSubscription => scalar('NonSubscription');







1;   
