#!/usr/bin/perl

package eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PromotionalShippingDiscountDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType

=head1 DESCRIPTION

Details of a promotional shipping discount.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PromotionalShippingDiscountDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::DiscountNameCodeType;


my @gaProperties = ( [ 'DiscountName', 'ns:DiscountNameCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DiscountNameCodeType', '' ]
	, [ 'ItemCount', 'xs:int', '', '', '' ]
	, [ 'OrderAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ShippingCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDiscountName()

The type of promotional shipping discount that is detailed in the profile.
If MaximumShippingCostPerOrder, see ShippingCost.
If ShippingCostXForAmountY, see ShippingCost and OrderAmount.
If ShippingCostXForItemCountN, see ShippingCost and ItemCount.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally
  OnlyTheseValues: 
								MaximumShippingCostPerOrder, ShippingCostXForAmountY, ShippingCostXForItemCountN
							

#    Argument: 'ns:DiscountNameCodeType'

=cut

sub setDiscountName {
  my $self = shift;
  $self->{'DiscountName'} = shift
}

=head2 getDiscountName()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally
  OnlyTheseValues: 
								MaximumShippingCostPerOrder, ShippingCostXForAmountY, ShippingCostXForItemCountN
							

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  OnlyTheseValues: 
								MaximumShippingCostPerOrder, ShippingCostXForAmountY, ShippingCostXForItemCountN
							

#    Returns: 'ns:DiscountNameCodeType'

=cut

sub getDiscountName {
  my $self = shift;
  return $self->{'DiscountName'};
}


=head2 setItemCount()

This is the number of items, when DiscountName is set to ShippingCostXForItemsY.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setItemCount {
  my $self = shift;
  $self->{'ItemCount'} = shift
}

=head2 getItemCount()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getItemCount {
  my $self = shift;
  return $self->{'ItemCount'};
}


=head2 setOrderAmount()

This is the cost Y of the order (not including shipping cost),
when DiscountName is set to ShippingCostXForAmountY.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setOrderAmount {
  my $self = shift;
  $self->{'OrderAmount'} = shift
}

=head2 getOrderAmount()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getOrderAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setShippingCost()

This is shipping cost X, when DiscountName is either ShippingCostXForAmountY or
ShippingCostXForItemCountN, and is the maximum cost when DiscountName is
MaximumShippingCostPerOrder.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setShippingCost {
  my $self = shift;
  $self->{'ShippingCost'} = shift
}

=head2 getShippingCost()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getShippingCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingCost'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
